#version 410 core

uniform vec2 resolution;

uniform sampler2D tex;

uniform float exposure;

uniform sampler2D titleTex;
uniform sampler2D logicomaTex;
uniform sampler2D endTex;
uniform sampler2D logicomaEnglishTex;
uniform sampler2D conveyorTex;

uniform float time;

in vec2 texCoords;

out vec4 FragColor;

vec3 hableTonemap(vec3 x)
{
    float a = .15;
    float b = .5;
    float c = .1;
    float d = .2;
    float e = .02;
    float f = .3;

    return ((x * (x * a + c * b) + d * e) / (x * (x * a + b) + d * f)) - e / f;
}

vec3 tonemap(vec3 rawColor, float exposure)
{
    float w = 11.2;

    vec3 exposedColor = max(rawColor * exposure, 0.0);

    vec3 linear = pow(exposedColor, vec3(1.0 / 2.2));

    vec3 reinhard = pow(exposedColor / (exposedColor + 1.0), vec3(1.0 / 2.2));

    vec3 x = max(exposedColor - .004, 0.0);
    vec3 hejlBurgessDawson = (x * (x * 6.2 + .5)) / (x * (x * 6.2 + 1.7) + .06);

    float exposureBias = 2.0;
    vec3 curr = hableTonemap(exposedColor * exposureBias);
    float whiteScale = (vec3(1.0) / hableTonemap(vec3(w))).x;
    vec3 color = curr * whiteScale;
    vec3 hable = pow(color, vec3(1.0 / 2.2));

    return
        //linear
        //reinhard
        hejlBurgessDawson
        //hable
        ;
}

float fadeIn(float from, float to)
{
    if (time < from || time >= to)
        return 0.0;

    return pow((time - from) / (to - from), 3.0);
}

float fadeOut(float from, float to)
{
    if (time < from || time >= to)
        return 0.0;

    return pow(1.0 - (time - from) / (to - from), 3.0);
}

void main()
{
    bool mirrorX = false;
    bool mirrorY = false;

    float titleAlpha = 0.0;
    float logicomaAlpha = 0.0;
    float endAlpha = 0.0;
    float logicomaEnglishAlpha = 0.0;
    float conveyorAlpha = 0.0;

    vec2 logoUv = vec2(texCoords.x, 1.0 - texCoords.y);

    float fade = 0.0;

    if (time >= 0.0 && time < 10.971) {
        logicomaAlpha = 1.0;
        logicomaEnglishAlpha = time < 5.485 ? fadeIn(2.0, 5.485) : 1.0;
    }

    if (time >= 10.971 && time < 21.942) {
        titleAlpha = 1.0;
        logoUv -= vec2(.25, 0.0);
    }

    if (time >= 21.942 && time < 43.885) {
        mirrorX = true;
    }

    if (time >= 43.885 && time < 54.857) {
    }

    if (time >= 54.857 && time < 60.342) {
    }

    if (time >= 60.342 && time < 65.485) {
    }

    if (time >= 65.485 && time < 65.657) {
    }

    if (time >= 65.657 && time < 65.828) {
    }

    if (time >= 65.828 && time < 69.942) {
        mirrorX = true;
        mirrorY = true;
    }

    if (time >= 69.942 && time < 71.314) {
        mirrorX = true;
        mirrorY = true;
    }

    if (time >= 71.314 && time < 75.428) {
        mirrorX = true;
        mirrorY = true;
    }

    if (time >= 75.428 && time < 76.800) {
    }

    if (time >= 76.800 && time < 85.028) {
        mirrorX = true;
        mirrorY = true;
    }

    if (time >= 85.028 && time < 86.400) {
    }

    if (time >= 86.400 && time < 87.771) {
    }

    if (time >= 87.771 && time < 90.514) {
        conveyorAlpha = 1.0;
    }

    if (time >= 90.514 && time < 97.371) {
        mirrorX = true;
    }

    if (time >= 97.371 && time < 98.742) {
        mirrorX = true;
    }

    if (time >= 98.742 && time < 108.342) {
        mirrorY = true;
    }

    if (time >= 108.342 && time < 109.714) {
        mirrorY = true;
    }

    if (time >= 109.714 && time < 120.685) {
        mirrorY = true;
    }

    if (time >= 120.685 && time < 131.657) {
        mirrorX = true;
    }

    if (time >= 131.657) {
        endAlpha = 1.0;
        logicomaEnglishAlpha = time < 135.771 ? fadeIn(132.514, 135.771) : 1.0;
    }

    fade += fadeOut(0.0, 5.485);
    fade -= fadeIn(9.6, 10.971);
    fade -= fadeOut(10.971, 13.714);
    fade += fadeIn(17.828, 21.942);
    fade += fadeOut(21.942, 23.314);
    fade += fadeIn(32.742, 32.914) * .2;
    fade += fadeOut(32.914, 33.6) * .2;
    fade += fadeIn(38.400, 43.885) * .6;
    fade += fadeOut(43.885, 48.0);
    fade -= fadeIn(52.114, 54.857);
    fade -= fadeOut(54.857, 56.228);
    fade += fadeOut(60.342, 61.514) * .2;
    fade += fadeOut(60.685, 60.857) * .2;
    fade += fadeOut(61.028, 61.2) * .2;
    fade += fadeOut(61.371, 61.542) * .2;
    fade += fadeOut(61.714, 61.885) * .2;
    fade += fadeOut(61.885, 62.057) * .2;
    fade += fadeOut(62.057, 62.228) * .2;
    fade += fadeOut(62.228, 62.4) * .2;
    fade += fadeOut(62.4, 62.571) * .2;
    fade += fadeOut(62.571, 62.742) * .2;
    fade += fadeOut(62.742, 62.914) * .2;
    fade += fadeOut(62.914, 63.085) * .2;
    fade += fadeIn(63.085, 65.485) * .8;
    fade -= fadeOut(65.485, 65.657);
    fade -= fadeOut(65.657, 65.828);
    fade += fadeOut(65.828, 67.2);
    fade += fadeOut(68.228, 68.4) * .8;
    fade += fadeOut(73.714, 73.885) * .8;
    fade += fadeOut(75.428, 75.6) * .8;
    fade += fadeOut(75.942, 76.114) * .8;
    fade += fadeOut(76.8, 78.171);
    fade -= fadeOut(85.028, 85.2) * .2;
    fade -= fadeOut(85.542, 85.714) * .2;
    fade += fadeOut(85.714, 85.885) * .8;
    fade -= fadeOut(85.885, 86.057) * .2;
    fade -= fadeOut(86.228, 86.4) * .2;
    fade += fadeOut(86.4, 86.742) * .8;
    fade += fadeOut(86.914, 87.085) * .8;
    fade += fadeOut(87.771, 89.142);
    fade += fadeOut(90.514, 91.2);
    fade += fadeOut(97.371, 97.714) * .6;
    fade += fadeOut(97.885, 98.228) * .6;
    fade += fadeOut(98.742, 99.428);
    fade += fadeOut(108.342, 108.685) * .6;
    fade += fadeOut(108.857, 109.2) * .6;
    fade += fadeOut(109.714, 110.457);
    fade -= fadeIn(119.314, 120.685);
    fade -= fadeOut(120.685, 122.057);
    fade += fadeIn(128.914, 131.657);
    fade += fadeOut(131.657, 134.4);
    fade -= fadeIn(137.142, 140.0);

    vec2 mirror = texCoords;
    if (mirrorX)
        mirror.x = abs(mirror.x - .5) + .5;
    if (mirrorY)
        mirror.y = abs(mirror.y - .5) + .5;

    vec3 inputColor = texture(tex, mirror).xyz;

    if (titleAlpha > 0.0)
        inputColor += texture(titleTex, logoUv).x * titleAlpha;
    if (logicomaAlpha > 0.0)
        inputColor += texture(logicomaTex, logoUv).x * logicomaAlpha;
    if (endAlpha > 0.0)
        inputColor += texture(endTex, logoUv).x * endAlpha;
    if (logicomaEnglishAlpha > 0.0)
        inputColor += texture(logicomaEnglishTex, logoUv + vec2(0, -.05)).x * logicomaEnglishAlpha;
    if (conveyorAlpha > 0.0)
        inputColor += texture(conveyorTex, logoUv).x * conveyorAlpha;

    vec3 tonemappedColor = tonemap(inputColor, pow(2.0, exposure));

    tonemappedColor += fade;

    // Output luma in a for FXAA
    float luma = sqrt(dot(tonemappedColor, vec3(0.299, 0.587, 0.114)));

    FragColor = vec4(tonemappedColor, luma);
}
