var Things = function(){
    PartBase.call(this);
    PartBase.prototype.initScene.call(this);
    
    this.scene.fog = new THREE.Fog(0xFFFFFF, 100, 800);
    
    this.pointLight = new THREE.PointLight(0x808080);
    this.scene.add(this.pointLight);
    
    this.box = this.createBox();
    this.setMidSphere();
};


Things.prototype = PartBase.prototype.inheritance();

Things.prototype.prepare = function(){
    PartBase.prototype.prepare.call(this);
    
    this.edge = new THREE.ShaderPass( THREE.EdgeShader2 );
    this.edge.uniforms[ "resolution" ].value =  new THREE.Vector2(TDEMO.width, TDEMO.height);
    TDEMO.composer.insertPass(this.edge, 1);
    
    this.bloom = new THREE.BloomPass(4);
    this.bloom.renderToScreen = true;
    TDEMO.composer.insertPass(this.bloom, 2);
    
    this.copy = new THREE.ShaderPass(THREE.CopyShader);
    TDEMO.composer.insertPass(this.copy, 3);
};

Things.prototype.finish = function(){
   PartBase.prototype.finish.call(this);
   this.edge.enabled = false;
   this.bloom.enabled = false;
   this.copy.enabled = false;
};


Things.prototype.animate = function(elapsedTime, delta){
  PartBase.prototype.animate.call(this, elapsedTime, delta);
  this.pointLight.position.set(this.camera.position.clone());
  var rot = delta/8;
  
  this.animateBoxTexture(rot);
  this.animateMidSphereTexture(rot);
};


Things.prototype.animateMidSphereTexture = function(delta) {
  this.midSphereTexture.offset.y += delta;
  this.midSphereTexture.offset.y %= 1;
  this.midSphereTexture.needsUpdate = true;
};


Things.prototype.animateBoxTexture = function(delta) {
  this.boxTexture.offset.y += delta;
  this.boxTexture.offset.y %= 1;
  this.boxTexture.needsUpdate = true;
}

//create and set things
Things.prototype.setMidSphere = function(){
    this.midsphere = this.createMidSphere(120);
    this.midsphere.position.set(this.box.position.x, this.box.position.y-70, this.box.position.z);
    this.midsphere.rotation.x = -Math.PI/3;
    this.scene.add(this.midsphere);    
};

Things.prototype.createBox = function() {
  var geometry = new THREE.SphereGeometry(30, 12, 12, 30);

  this.boxTexture = TDEMO.textures.box;
  
  var material = new THREE.MeshBasicMaterial({
      side : THREE.DoubleSide,
      map : this.boxTexture
  });

  var box = new THREE.Mesh(geometry, material);
  return box;  
};

Things.prototype.createMidSphere = function(radius) {
  var geometry = new THREE.SphereGeometry(radius,70,70);
  this.midSphereTexture = TDEMO.textures.midSphere;
    
  var material = new THREE.MeshBasicMaterial({
      side : THREE.DoubleSide,
      map : this.midSphereTexture
  });

  return new THREE.Mesh(geometry, material);
};