var Spheres = function(){
    PartBase.call(this);
    PartBase.prototype.initScene.call(this);
    
    this.scene.fog = new THREE.Fog(0xFFFFFF, 100, 800);
    
    this.pointLight = new THREE.PointLight(0x808080);
    this.scene.add(this.pointLight);
    
    this.createSpheres();
};


Spheres.prototype = PartBase.prototype.inheritance();

Spheres.prototype.prepare = function(){
    PartBase.prototype.prepare.call(this);
    
    this.edge = new THREE.ShaderPass( THREE.EdgeShader2 );
    this.edge.uniforms[ "resolution" ].value =  new THREE.Vector2(TDEMO.width, TDEMO.height);
    TDEMO.composer.insertPass(this.edge, 1);
    
    this.bloom = new THREE.BloomPass(2);
    this.bloom.renderToScreen = true;
    TDEMO.composer.insertPass(this.bloom, 2);
    
    this.copy = new THREE.ShaderPass(THREE.CopyShader);
    TDEMO.composer.insertPass(this.copy, 3);
};

Spheres.prototype.finish = function(){
   PartBase.prototype.finish.call(this);
   this.edge.enabled = false;
   this.bloom.enabled = false;
   this.copy.enabled = false;
};

Spheres.prototype.animateBox = function(rot) {
  this.box.rotation.z += rot;
  this.box.rotation.y += rot;
  this.box.rotation.x += rot;
};

Spheres.prototype.animate = function(elapsedTime, delta){
  PartBase.prototype.animate.call(this, elapsedTime, delta);
  this.pointLight.position.set(this.camera.position.clone());
  var rot = delta/8;
  
  this.animateBox(rot);
};


Spheres.prototype.createSpheres = function() {
    this.box = puurinki();
    this.scene.add(this.box);
};
