var Human = function(){
    PartBase.call(this);
    
    PartBase.prototype.initScene.call(this);
    
    var geometry = new THREE.PlaneGeometry(128, 256);
    var material = new THREE.MeshBasicMaterial({
        map : TDEMO.textures.ihminen
    });

    var ihminen = new THREE.Mesh(geometry, material);
    ihminen.position.z = -300;
    ihminen.rotation.z = Math.PI;
    this.scene.add(ihminen);
};

Human.prototype = PartBase.prototype.inheritance();

Human.prototype.prepare = function(){
    PartBase.prototype.prepare.call(this);
    
    this.edge = new THREE.ShaderPass( THREE.EdgeShader2 );
    this.edge.uniforms[ "resolution" ].value =  new THREE.Vector2(TDEMO.width, TDEMO.height);
    TDEMO.composer.insertPass(this.edge, 1);
    this.edge.enabled = false;
    
    this.bloom = new THREE.BloomPass(0.8);
    this.bloom.renderToScreen = true;
    TDEMO.composer.insertPass(this.bloom, 2);
    
    this.copy = new THREE.ShaderPass(THREE.CopyShader);
    TDEMO.composer.insertPass(this.copy, 3);
};

Human.prototype.finish = function(){
   PartBase.prototype.finish.call(this);
   this.edge.enabled = false;
   this.bloom.enabled = false;
   this.copy.enabled = false
};