var Globe = function(){
    PartBase.call(this);
    PartBase.prototype.initScene.call(this);
    
    this.scene.fog = new THREE.Fog(0xFFFFFF, 100, 800);
    
    this.pointLight = new THREE.PointLight(0x808080);
    this.scene.add(this.pointLight);
    var sky = this.createSky();
    sky.position.set(0, -180, -10);    
    this.setGlobe();
    this.scene.add(sky);
};


Globe.prototype = PartBase.prototype.inheritance();

Globe.prototype.prepare = function(){
    PartBase.prototype.prepare.call(this);
    
    this.edge = new THREE.ShaderPass( THREE.EdgeShader2 );
    this.edge.uniforms[ "resolution" ].value =  new THREE.Vector2(TDEMO.width, TDEMO.height);
    TDEMO.composer.insertPass(this.edge, 1);
    
    this.bloom = new THREE.BloomPass(4);
    this.bloom.renderToScreen = true;
    TDEMO.composer.insertPass(this.bloom, 2);
    
    this.copy = new THREE.ShaderPass(THREE.CopyShader);
    TDEMO.composer.insertPass(this.copy, 3);
    this.dof2 = new THREE.BokehPass(this.scene, this.camera, {
        focus : 1.0,
        width: TDEMO.width,
        height: TDEMO.height,
        maxblur: 2,
        aperture: 0.04
    });
    this.dof2.renderToScreen = true;
    TDEMO.composer.addPass(this.dof2);
    TDEMO.copyPass.enabled = false;
};

Globe.prototype.finish = function(){
   PartBase.prototype.finish.call(this);
   this.edge.enabled = false;
   this.bloom.enabled = false;
   this.copy.enabled = false
   this.dof2.enabled = false;
   TDEMO.copyPass.enabled = true;
};


Globe.prototype.animate = function(elapsedTime, delta){
  PartBase.prototype.animate.call(this, elapsedTime, delta);
  this.pointLight.position.set(this.camera.position.clone());
  var rot = delta/8;
  
  this.animateGlobeTexture(rot);
};


Globe.prototype.animateGlobeTexture = function(delta) {
  this.globeTexture.offset.y += delta;
  this.globeTexture.needsUpdate = true;
  
  this.skytexture.offset.y += delta/15;
  this.skytexture.needsUpdate = true
};

Globe.prototype.setGlobe = function() {
    this.globe = this.createSphere(TDEMO.textures.globe, 170);
    this.globe.position.set(0, -180, -70);
    this.globe.rotation.x = -Math.PI/3;
    this.scene.add(this.globe);    
};

Globe.prototype.createSphere = function(texture, radius) {
  var geometry = new THREE.SphereGeometry(radius,70,70);
  this.globeTexture = texture;
    
  var material = new THREE.MeshBasicMaterial({
      side : THREE.DoubleSide,
      map : this.globeTexture
  });

  return new THREE.Mesh(geometry, material);
};

Globe.prototype.createSky = function(){
    var geometry = new THREE.SphereGeometry(240, 64, 64);
    this.skytexture = TDEMO.textures.taivas;
    var material = new THREE.MeshBasicMaterial({
        map: this.skytexture,
        side : THREE.BackSide,
        color : 0x603072
    });
    
    var sky = new THREE.Mesh(geometry, material);
    return sky;
};
