
//Generates noise texture and height field based on it
var HeightField = function(){
    var rtt = new THREE.WebGLRenderTarget(255, 255);
    var geometry = new THREE.PlaneGeometry(1200,1200,180,180);
    geometry.dynamic = true;
    
    var plane = new THREE.Mesh(geometry, new THREE.ShaderMaterial({
        vertexShader : NoiseShader.vertexShader,
        fragmentShader : NoiseShader.fragmentShader
    }));
    var s = new THREE.Scene();
    var c = new THREE.OrthographicCamera(-256/2, 256/2, 256/2, -256/2);
    c.position.z = 1;
    s.add(c);
    s.add(plane);

    TDEMO.renderer.render(s, c, rtt, true);

    var gl = TDEMO.renderer.getContext();
    var pixels = new Uint8Array(4 * 256 * 256);
    gl.readPixels( 0, 0, 256, 256, gl.RGBA, gl.UNSIGNED_BYTE, pixels);

    //set height of vertices
    for( var i = 0; i < geometry.vertices.length; i++ ){
        geometry.vertices[i].z = pixels[i]*(Math.random()*0.1);
    }
    geometry.verticesNeedUpdate = true;
    
    return function(){
        return geometry;
    }
};