SamplerState sm:register(s1);
Texture2D input:register(t0);

cbuffer c : register(b1)
{
	float Aperture;
	float Focus;
}

#define pi (3.14159265359)
#define angle (pi/3*5)
#define direction (float2(cos(angle),sin(angle)*(1.6/0.9)))
#define sampleCount 10

float4 p(float4 PositionSS : SV_Position, float2 t : TEXCOORD) : SV_TARGET0
{
	float4 c = input.Sample(sm,t);
	float4 acc = 0;

	for (int i = 0; i<sampleCount; i++) {
		float fi = float(i) / sampleCount;
		float2 offset = direction*fi;
		float4 s = input.Sample(sm,t + offset*c.w);
		acc += s;
	}
	acc /= sampleCount;
	return acc;
}