#version 440 core
#pragma stage vertex

layout(location = 0) in vec2 attrPosition;

uniform vec2  uCameraPosition;
uniform float uCameraScale;
uniform vec2  uSpritePosition;
uniform float uSpriteLayer;
uniform vec2  uSpriteSize;
uniform float uSpriteScale;
uniform float uSpriteNumFrames;
uniform float uSpriteCurrentFrame;
uniform float uParallaxScale;
uniform vec2  uScreenSize;

out gl_PerVertex { vec4 gl_Position; float gl_PointSize; float gl_ClipDistance[]; };
out vec2 vUv;

void main()
{
	vec2 spritePosition = floor(uSpritePosition);
	vec2 cameraPosition = floor(uCameraPosition);

	vec2 spritePos = attrPosition * (uSpriteSize / uScreenSize) * uSpriteScale;     // Scale and size of the sprite in screen pixels
	spritePos -= vec2(1.0);                                                         // Origin is at bottom-left
	spritePos += 2.0 * (spritePosition / uScreenSize);                             // Offset sprite to its screen position in pixels

	vec2 camPos = 2.0 * (cameraPosition / uScreenSize) - vec2(1.0);                // Compute camera position in 2D world space
	spritePos -= camPos;                                                            // Offset sprite by the inverse of the camera position

	spritePos *= uCameraScale;                                                      // Offset sprite by the camera zoom scale (<1.0 = dezoom, >1.0 = zoom)
	
	vec2 deltaPos = spritePosition - cameraPosition;
	spritePos += deltaPos * uParallaxScale * uSpriteLayer * uCameraScale;           // Correct sprite position by parallax influence


	gl_Position = vec4(spritePos, 0.0, 1.0);

	float frameWidth = 1.0 / uSpriteNumFrames;

	vUv = attrPosition * 0.5 + vec2(0.5);

	vUv.x = frameWidth * (vUv.x + uSpriteCurrentFrame);
	vUv.y = 1.0 - vUv.y;
}
