var Game = {
	_currentState: null,

	init: function() {
        var gsm = this;
        var bindEventToState = function(event) {
            window.addEventListener(event, function(e) {
                if (gsm._currentState !== null)
                    gsm._currentState.handleInput(event, e);
            });
        };
        bindEventToState('keydown');
        bindEventToState('keypress');
		
		Game.switchState(Game.State.StartState);
    },
	getCurrentState: function() {
		return this._currentState;
	},
	// Repaint
    refresh: function() {
        this._currentState.render();
    },
	// Switch states
	switchState: function(state) {
        if (this._currentState !== null)
            this._currentState.exit();

        RotEngine.clear();

        this._currentState = state;
        if (!this._currentState !== null) {
            this._currentState.enter();
            this.refresh();
        }
    }
};
Game.State = {};

window.onload = function() {
	RotEngine.init();
	ThreeEngine.init();
	Game.init();
};