Game.Entity = function(properties) {
    properties = properties || {};
    Game.DynamicGlyph.call(this, properties);
    this._x = properties['x'] || 0;
    this._y = properties['y'] || 0;
    this._z = properties['z'] || 0;
    this._map = null;
    this._alive = true;
    this._speed = properties['speed'] || 1000;	// Acting speed
};
Game.Entity.extend(Game.DynamicGlyph);

Game.Entity.prototype.setX = function(x) {
    this._x = x;
};
Game.Entity.prototype.setY = function(y) {
    this._y = y;
};
Game.Entity.prototype.setZ = function(z) {
    this._z = z;
};
Game.Entity.prototype.setMap = function(map) {
    this._map = map;
};
Game.Entity.prototype.setSpeed = function(speed) {
    this._speed = speed;
};
Game.Entity.prototype.setPosition = function(x, y, z) {
    var oldX = this._x;
    var oldY = this._y;
    var oldZ = this._z;
    this._x = x;										// Update position
    this._y = y;
    this._z = z;
    if (this._map)										// If the entity is on a map, notify the map that the entity has moved
        this._map.updateEntityPosition(this, oldX, oldY, oldZ);
};
Game.Entity.prototype.getX = function() {
    return this._x;
};
Game.Entity.prototype.getY   = function() {
    return this._y;
};
Game.Entity.prototype.getZ = function() {
    return this._z;
};
Game.Entity.prototype.getMap = function() {
    return this._map;
};
Game.Entity.prototype.getSpeed = function() {
    return this._speed;
};
Game.Entity.prototype.isAlive = function() {
    return this._alive;
};

Game.Entity.prototype.tryMove = function(x, y, z, map) {
    var map = this.getMap();
    var tile = map.getTile(x, y, this.getZ());			// Must use starting z
    var target = map.getEntityAt(x, y, this.getZ());
    var zChanged = false;
	
    if (z < this.getZ()) {								// If our z level changed, check if we are on stair
        if (tile != Game.Tile.stairsUpTile)
            Game.sendMessage(this, "You can't go up here!");
        else {
			Game.sendMessage(this, "You "+Game.randomMessage(['ascend','clamber up','stumble up','stagger up','drag yourself up'])+" the stairs to level %d"+Game.randomMessage(['!','.']), [z + 1]);
			this.setPosition(x, y, z);
			zChanged = true;
        }
    } else if (z > this.getZ()) {
        if (tile === Game.Tile.holeToCavernTile && this.hasMixin(Game.EntityMixins.PlayerActor)) {	// Switch the entity to a boss cavern!
			Game.sendMessage(this, "You dive through a hole in the ruddy ground!");
			this.switchMap(new Game.Map.BossCavern());
			zChanged = true;
        } else if (tile != Game.Tile.stairsDownTile)
            Game.sendMessage(this, "You can't go down here!");
        else {
			Game.sendMessage(this, "You "+Game.randomMessage(['descend','clamber down','stumble down','stagger down'])+" the stairs to level %d"+Game.randomMessage(['!','.']), [z + 1]);
			this.setPosition(x, y, z);
			zChanged = true;
        }
    } else if (target) {								// If an entity was present at the tile
        // An entity can only attack if the entity has the Attacker mixin and either the entity or the target is the player.
        if (this.hasMixin('Attacker') && (this.hasMixin(Game.EntityMixins.PlayerActor) || target.hasMixin(Game.EntityMixins.PlayerActor))) {
            this.attack(target);
            return true;
        } 
        return false;        							// If not nothing we can do, but we can't move to the tile
    } else if (tile.isWalkable()) {        				// Check if we can walk on the tile and if so simply walk onto it
        this.setPosition(x, y, z);						// Update the entity's position
        var items = this.getMap().getItemsAt(x, y, z);	// Notify the entity that there are items at this position
        if (items) {
            if (items.length === 1)
                Game.sendMessage(this, Game.randomMessage(['You see %s.','There is %s here.','There\'s %s here.','You notice %s.' ]), [items[0].describeA()]);
            else
                Game.sendMessage(this, Game.randomMessage(['There are several objects here.','You see several objects here.','You notice several objects here.','You see several things here.']));
        }
        return true;
    } else if (tile.isDiggable()) {						// Check if the tile is diggable
        if (this.hasMixin(Game.EntityMixins.PlayerActor)) {	// Only dig if the the entity is the player
            map.dig(x, y, z);
            return true;
        }
        return false;									// If not nothing we can do, but we can't move to the tile
    }
	
	if (zChanged){
		$('#threeDisplay').hide();
		$('#minimap').hide();
		Game.State.PlayState.rebuildMinimap();
		Game.refresh();
		$('#threeDisplay').fadeIn(1000);
		$('#minimap').fadeIn(1000);
	}
	return false;
};

// Kill the entity
Game.Entity.prototype.kill = function(message) {
    if (!this._alive)									// Only kill once!
        return;
    this._alive = false;
    if (message)
        Game.sendMessage(this, message);
    else
        Game.sendMessage(this, Game.randomMessage(['You died...','You are dead...','You collapse...','You have passed on...','You have shuffled off your mortal coil...','You\'re a goner...','You\'ve bitten the dust...','Your time in this world is ended...','You return to your maker...','You will gulp air no more...','Another tragic death...','You have <i>become</i> death...','You are finished...','Your life slips away...','You can hang on no longer...','You withered in this place...','You slip away...','The light fades...','You breathe a little sigh...']));
    
    if (this.hasMixin(Game.EntityMixins.PlayerActor))
        this.act();
    else
        this.getMap().removeEntity(this);
};

// Move entity to a different map
Game.Entity.prototype.switchMap = function(newMap) {
    if (newMap === this.getMap())
        return;
	this.getMap().removeEntity(this);
    this._x = 0;
    this._y = 0;
    this._z = 0;
    newMap.addEntity(this);
};