import vector

def IsCollision(entity1, entity2):
    deltaSquared = vector.sub(entity1.Position, entity2.Position)
    deltaSquared[0] *= deltaSquared[0]
    deltaSquared[1] *= deltaSquared[1]

    #Calculate the sum of the radii, then square it
    sumRadiiSquared = entity1.Radius + entity2.Radius
    sumRadiiSquared *= sumRadiiSquared

    if deltaSquared[0] + deltaSquared[1] <= sumRadiiSquared:
        return True

    return False

#http://www.gamasutra.com/view/feature/131424/pool_hall_lessons_fast_accurate_.php
def Collide(entity1, entity2):
    #First, find the normalized vector n from the center of
    #circle1 to the center of circle2
    n = vector.sub(entity1.Position,entity2.Position)

    vector.normalize(n)
    #Find the length of the component of each of the movement
    #vectors along n.
    #a1 = v1 . n
    #a2 = v2 . n
    a1 = vector.dot(entity1.Velocity,n)
    a2 = vector.dot(entity2.Velocity,n)

    #Using the optimized version,
    #optimizedP =  2(a1 - a2)
    #             -----------
    #               m1 + m2
    optimizedP = (2.0 * (a1 - a2)) / (entity1.Radius + entity2.Radius)

    #Calculate v1', the new movement vector of circle1
    #v1' = v1 - optimizedP * m2 * n
    entity1.Velocity = vector.sub(entity1.Velocity, vector.multiply(n, optimizedP * entity2.Radius))

    #Calculate v1', the new movement vector of circle1
    #v2' = v2 + optimizedP * m1 * n
    entity2.Velocity = vector.add(entity2.Velocity, vector.multiply(n, optimizedP * entity1.Radius))

    return optimizedP