import pygame, sys, math
from pygame.locals import *
import math
from entity import Entity
from config import Config

class Ship:

    def __init__(self, _position):
        position = [
            _position[0] * Config.WINDOWWIDTH,
            _position[1] * Config.WINDOWHEIGHT]

        self.Points = []
        for point in Config.SHIPPOINTS:
            self.Points.append([
                point[0] * Config.SHIPSIZE,
                point[1] * Config.SHIPSIZE])

        self.BoostPoints = []
        for point in  Config.SHIPBOOSTPOINTS:
            self.BoostPoints.append([
                point[0] * Config.SHIPSIZE,
                point[1] * Config.SHIPSIZE])

        self.Entity = Entity(position, Config.SHIPSIZE, self.Points)
        self.IsFlying = False
        self.BoostActive = False

    def Boost(self, _fTime, _screen):
        self.Entity.Velocity[0] += Config.SHIPBOOSTFORCE * math.sin(self.Entity.Rotation) * _fTime
        self.Entity.Velocity[1] -= Config.SHIPBOOSTFORCE * math.cos(self.Entity.Rotation) * _fTime
        self.BoostActive = True

    def RotateLeft(self, _fTime):
        if self.IsFlying:
            self.Entity.Rotation -= Config.SHIPROTATIONSPEED * _fTime

    def RotateRight(self, _fTime):
        if self.IsFlying:
            self.Entity.Rotation += Config.SHIPROTATIONSPEED * _fTime

    def Update(self, _fTime):
        self.Entity.Update(_fTime)
        self.Entity.UpdateXLimit()

        if self.Entity.Position[1] > Config.WINDOWHEIGHT:
            self.Entity.Position[1] = Config.WINDOWHEIGHT
            self.Entity.Velocity[1] = 0

        if self.Entity.Position[1] <= Config.OFFSETLIMIT:
            self.IsFlying = True
            Entity.Offset = self.Entity.Position[1] - Config.OFFSETLIMIT

    def Draw(self, _screen):
        self.Entity.Draw(_screen)

        if self.BoostActive:
            transformedPoints = self.Entity.TransformPoints(self.BoostPoints)
            pygame.draw.polygon(_screen, Config.GREEN, transformedPoints, 5)
            self.BoostActive = False