import pygame, sys, math, random, vector, utils, statemanager
from pygame.locals import *
from tween import *
from letter import Letter
from asteroid import Asteroid
from config import Config

class Outro:

    def Init(self, _gameInfo):

        self.Font1 = pygame.font.SysFont("monospace", 64)
        self.Font2 = pygame.font.SysFont("monospace", 48)
        self.Font3 = pygame.font.SysFont("monospace", 32)

        self.Timer = 0;

        self.GameInfo = _gameInfo

        self.inputTimer = 2

        self.IsInitialized = True

    def Reset(self):
        self.IsInitialized = False

    def Input(self, _fTime, _screen, _anyKeyDown):

        if not self.IsInitialized:
            return

        if self.inputTimer <= 0:
            if _anyKeyDown:
                statemanager.Set(0)

    def Update(self, _fTime):

        if not self.IsInitialized:
            return

        if self.inputTimer > 0:
            self.inputTimer -= _fTime

        self.Timer += _fTime

    def Draw(self, _screen):

        if not self.IsInitialized:
            return

        # render text
        label = self.Font1.render("Game Over", 1, Config.GREY)
        pos = mytween(easeOutElasticSmall, -100,60,self.Timer)
        _screen.blit(label, (60, pos))

        if self.GameInfo.IsNewRecord:
            label = self.Font2.render("New Record!", 1, Config.WHITE)
            pos = mytween(easeOutElasticSmall, -100,120,self.Timer - 0.5)
            _screen.blit(label, (140, pos))
        else:
            label = self.Font2.render("Try again :)", 1, Config.GREY)
            pos = mytween(easeOutElasticSmall, -100,120,self.Timer - 0.5)
            _screen.blit(label, (140, pos))

        label = self.Font3.render("Stage: "+str(int(self.GameInfo.CurrentStageId+1)), 1, Config.GREEN)
        pos = mytween(easeOutElasticSmall, -100,220,self.Timer - 0.8)
        _screen.blit(label, (140, pos))

        label = self.Font3.render("Distance: "+str(self.GameInfo.CurrentDistance), 1, Config.GREEN)
        pos = mytween(easeOutElasticSmall, -100,260,self.Timer - 1)
        _screen.blit(label, (140, pos))

        label = self.Font3.render("Collisions: "+str(self.GameInfo.AsteroidsTouched), 1, Config.GREEN)
        pos = mytween(easeOutElasticSmall, -100,300,self.Timer - 1.2)
        _screen.blit(label, (140, pos))

        label = self.Font3.render("Max Speed: "+str(int(self.GameInfo.MaxSpeed))+" km/h", 1, Config.GREEN)
        pos = mytween(easeOutElasticSmall, -100,340,self.Timer - 1.4)
        _screen.blit(label, (140, pos))

        label = self.Font3.render("Total Time: "+str(int(self.GameInfo.Time))+" sec", 1, Config.GREEN)
        pos = mytween(easeOutElasticSmall, -100,380,self.Timer - 1.6)
        _screen.blit(label, (140, pos))
