import pygame, sys, math, vector
from pygame.locals import *
from entity import Entity
from config import Config

class Letter:

    def __init__(self, _position, _offset, _lineClosed, _points):

        _position = vector.multiply(_position, Config.INTRO_LETTER_SCALE)

        centerOffset = [
            Config.WINDOWWIDTH/2 - 4.5 * Config.INTRO_LETTER_SCALE,
            Config.WINDOWHEIGHT/2]
        _position = vector.add(_position, centerOffset)


        self.Points = []
        for point in _points:
            self.Points.append([
                (point[0] - _offset[0]) * Config.INTRO_LETTER_SCALE ,
                (_offset[1] - point[1]) * Config.INTRO_LETTER_SCALE])

        radius = _offset[1] * Config.INTRO_LETTER_SCALE

        self.Entity = Entity(_position, radius, self.Points)
        self.Entity.LineClosed = _lineClosed

        self.InitialPosition = [
            _position[0],
            _position[1]]

    def Update(self, _fTime):

        delta = vector.sub(self.InitialPosition, self.Entity.Position)
        self.Entity.Velocity = vector.add(self.Entity.Velocity, vector.multiply(delta, _fTime*10))

        self.Entity.Update(_fTime)


    def Draw(self, _screen):
        self.Entity.Draw(_screen)