var GlitchCube = function(){
    PartBase.call(this);

    this.setDoF({focus: 1.0, maxblur: 3.0, aperture: 0.05});
    this.setBloom(2);
    this.setHorizontalBlur(2);
    this.setVerticalBlur(3);

    this.scene.fog = new THREE.Fog(0xA81214, this.near, this.far*0.5);

    this.cube = this.createGeometry();
    this.scene.add(this.cube);

    this.sky = this.createSky();
    this.scene.add(this.sky);
}

GlitchCube.prototype = PartBase.prototype.inheritance();

GlitchCube.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta);

    var hb = TDEMO.SYNC.getHeartBeat();
    this.cube.morphTargetInfluences[0] = hb;

    var pos = TDEMO.SYNC.getObjPosition();
    this.cube.position.x = pos.x;
    this.cube.position.y = pos.y;
    this.cube.position.z = pos.z;
}

GlitchCube.prototype.createGeometry = function(){
    var morphGeo = new THREE.BoxGeometry(120, 120, 120, 32, 32, 32);
    var geometry = new THREE.SphereGeometry(160, 64, 64);
    geometry.morphTargets.push({
        name : "sphere",
        vertices : morphGeo.vertices,
        side : THREE.DoubleSide
    });

    var material = new THREE.MeshBasicMaterial({
        color : 0xFFFFFF,
        map: TDEMO.TEXTURES.getTextures().satellite,
        morphTargets : true
    });

    return new THREE.Mesh(geometry, material);
};

GlitchCube.prototype.createSky = function(){
    var geometry = new THREE.SphereGeometry(400, 32, 32);
    var material = new THREE.MeshBasicMaterial({
        map: TDEMO.TEXTURES.getTextures().satellite,
        side : THREE.BackSide
    });

    return new THREE.Mesh(geometry, material);
}
