#version 120

uniform sampler2D texture;


uniform float time = 1.0;



void main()
{
	vec2 coord = gl_TexCoord[0].st;

    vec2 position = ( coord.xy)-vec2(0.5,0.5);

        // 256 angle steps
        float angle = atan(position.y,position.x)/(1*3.14159265359);
        angle -= floor(angle);
        float rad = length(position);
        
        float color = 0.0;
        for (int i = 0; i < 2; i++) {
            float angleFract = fract(angle*36.);
            float angleRnd = floor(angle*360.)+1.;
            float angleRnd1 = fract(angleRnd*fract(angleRnd*5.7235)*45.1);
            float angleRnd2 = fract(angleRnd*fract(angleRnd*5.82657)*13.724);
            float t = 7*time+angleRnd1*100.;
            float radDist = 5*sqrt(angleRnd2+float(i));
            
            float adist = radDist/rad*1.5;
            float dist = (t*.2+adist);
            dist = abs(fract(dist)-.1);
            color += max(0.,.8-dist*100./adist)*(.5-abs(angleFract-.5))*99./adist/radDist;
            
            angle = fract(angle);
        }
    
    
    
    
    
    


	gl_FragColor = vec4(color*2.5,color*0.5,color*0.3,1.0);
}