/*
 * Decompiled with CFR 0.152.
 */
package com.github.bjakke;

import com.jogamp.opengl.GL3;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PVector;
import processing.opengl.PJOGL;
import processing.opengl.PShader;

public class ShaderTest {
    private final PShader shader;
    private final PApplet applet;
    private final PGraphics pg;
    private Moonlander ml;

    public ShaderTest(PApplet p, PGraphics pg, String vertFilePath, String fragFilePath, Moonlander ml) {
        this.applet = p;
        this.shader = new PShader(p, vertFilePath, fragFilePath);
        this.pg = pg;
        this.ml = ml;
    }

    public void draw(float timeSeconds) {
        PJOGL pgl = (PJOGL)this.pg.beginPGL();
        GL3 gl = pgl.gl.getGL3();
        int cubes = this.ml.getIntValue("cubes");
        if (cubes > 1000) {
            cubes = 1000;
        }
        if (cubes < 1) {
            cubes = 1;
        }
        System.out.println("CUBES:" + cubes);
        float d = 1.0f / (float)cubes * 2.0f * (float)Math.PI;
        if (cubes < 299) {
            d = (float)Math.PI * 50.0f;
        }
        float cube_size = this.ml("cube_size");
        float time_multiplier = this.ml("time_div");
        this.shader.set("u_timeSeconds", timeSeconds / time_multiplier);
        this.shader.set("u_timeDisplacement", d);
        this.shader.set("u_cubeSize", cube_size);
        float rotVX = this.ml("rotVX");
        float rotVY = this.ml("rotVY");
        float rotVZ = this.ml("rotVZ");
        this.shader.set("u_vrot", new PVector(rotVX, rotVY, rotVZ));
        int torus_loops = this.mli("torus_loops");
        float torus_major = this.ml("torus_major");
        float torus_minor = this.ml("torus_minor");
        this.shader.set("u_torusLoops", torus_loops);
        this.shader.set("u_torusMajor", torus_major);
        this.shader.set("u_torusMinor", torus_minor);
        PVector lightDir = new PVector(0.0f, 0.0f, 1.0f);
        this.shader.set("u_lightDirection", lightDir);
        PVector lightInt = new PVector(1.0f, 0.0f, 0.0f);
        this.shader.set("u_lightIntensity", lightInt);
        float pl_t = timeSeconds * 1.0f;
        float pl_x = torus_major * 1.2f * PApplet.cos((float)pl_t);
        float pl_y = torus_major * 1.2f * PApplet.sin((float)pl_t);
        float pl_z = 0.0f;
        PVector pLDir = new PVector(pl_x, pl_y, pl_z);
        this.shader.set("u_pointLightLocation", pLDir);
        PVector pLInt = new PVector(0.0f, 0.3f, 0.3f);
        this.shader.set("u_pointLightIntensity", pLInt);
        this.shader.bind();
        gl.glDrawArrays(4, 0, 36 * cubes);
        this.shader.unbind();
        this.pg.endPGL();
    }

    private float ml(String trackName) {
        return (float)this.ml.getValue(trackName);
    }

    private int mli(String trackName) {
        return this.ml.getIntValue(trackName);
    }
}

