/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.CmapFormat;

public class CmapFormat4
extends CmapFormat {
    private final int _segCountX2;
    private final int _searchRange;
    private final int _entrySelector;
    private final int _rangeShift;
    private final int[] _endCode;
    private final int[] _startCode;
    private final int[] _idDelta;
    private final int[] _idRangeOffset;
    private final int[] _glyphIdArray;
    private final int _segCount;

    protected CmapFormat4(DataInput dataInput) throws IOException {
        super(dataInput);
        int n;
        this._format = 4;
        this._segCountX2 = dataInput.readUnsignedShort();
        this._segCount = this._segCountX2 / 2;
        this._endCode = new int[this._segCount];
        this._startCode = new int[this._segCount];
        this._idDelta = new int[this._segCount];
        this._idRangeOffset = new int[this._segCount];
        this._searchRange = dataInput.readUnsignedShort();
        this._entrySelector = dataInput.readUnsignedShort();
        this._rangeShift = dataInput.readUnsignedShort();
        for (n = 0; n < this._segCount; ++n) {
            this._endCode[n] = dataInput.readUnsignedShort();
        }
        dataInput.readUnsignedShort();
        for (n = 0; n < this._segCount; ++n) {
            this._startCode[n] = dataInput.readUnsignedShort();
        }
        for (n = 0; n < this._segCount; ++n) {
            this._idDelta[n] = dataInput.readUnsignedShort();
        }
        for (n = 0; n < this._segCount; ++n) {
            this._idRangeOffset[n] = dataInput.readUnsignedShort();
        }
        n = (this._length - (8 * this._segCount + 16)) / 2;
        this._glyphIdArray = new int[n];
        for (int i = 0; i < n; ++i) {
            this._glyphIdArray[i] = dataInput.readUnsignedShort();
        }
    }

    @Override
    public int getRangeCount() {
        return this._segCount;
    }

    @Override
    public CmapFormat.Range getRange(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this._segCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new CmapFormat.Range(this._startCode[n], this._endCode[n]);
    }

    @Override
    public int mapCharCode(int n) {
        try {
            for (int i = 0; i < this._segCount; ++i) {
                if (this._endCode[i] < n) continue;
                if (this._startCode[i] <= n) {
                    if (this._idRangeOffset[i] > 0) {
                        return this._glyphIdArray[this._idRangeOffset[i] / 2 + (n - this._startCode[i]) - (this._segCount - i)];
                    }
                    return (this._idDelta[i] + n) % 65536;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("error: Array out of bounds - " + arrayIndexOutOfBoundsException.getMessage());
        }
        return 0;
    }

    @Override
    public String toString() {
        return super.toString() + ", segCountX2: " + this._segCountX2 + ", searchRange: " + this._searchRange + ", entrySelector: " + this._entrySelector + ", rangeShift: " + this._rangeShift + ", endCodeLen: " + this._endCode.length + ", startCodeLen: " + this._endCode.length + ", idDeltaLen: " + this._idDelta.length + ", idRangeOffsetLen: " + this._idRangeOffset.length;
    }
}

