/*
 * Decompiled with CFR 0.152.
 */
package peasy;

import peasy.CameraState;
import peasy.DampedAction;
import peasy.InterpolationManager;
import peasy.InterpolationUtil;
import peasy.PeasyDragHandler;
import peasy.PeasyWheelHandler;
import peasy.org.apache.commons.math.geometry.CardanEulerSingularityException;
import peasy.org.apache.commons.math.geometry.Rotation;
import peasy.org.apache.commons.math.geometry.RotationOrder;
import peasy.org.apache.commons.math.geometry.Vector3D;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PMatrix3D;
import processing.event.KeyEvent;
import processing.event.MouseEvent;

public class PeasyCam {
    private static final Vector3D LOOK = Vector3D.plusK;
    private static final Vector3D UP = Vector3D.plusJ;
    private final PGraphics g;
    private final PApplet p;
    private final double startDistance;
    private final Vector3D startCenter;
    private boolean resetOnDoubleClick = true;
    private double minimumDistance = 1.0;
    private double maximumDistance = Double.MAX_VALUE;
    private final DampedAction rotateX;
    private final DampedAction rotateY;
    private final DampedAction rotateZ;
    private final DampedAction dampedZoom;
    private final DampedAction dampedPanX;
    private final DampedAction dampedPanY;
    private double distance;
    private Vector3D center;
    private Rotation rotation;
    private Constraint dragConstraint = null;
    private Constraint permaConstraint = null;
    private final InterpolationManager rotationInterps = new InterpolationManager();
    private final InterpolationManager centerInterps = new InterpolationManager();
    private final InterpolationManager distanceInterps = new InterpolationManager();
    private final PeasyDragHandler panHandler;
    private PeasyDragHandler centerDragHandler = this.panHandler = new PeasyDragHandler(){

        public void handleDrag(double dx, double dy) {
            PeasyCam.this.dampedPanX.impulse(dx / 8.0);
            PeasyCam.this.dampedPanY.impulse(dy / 8.0);
        }
    };
    private final PeasyDragHandler rotateHandler;
    private PeasyDragHandler leftDragHandler = this.rotateHandler = new PeasyDragHandler(){

        public void handleDrag(double dx, double dy) {
            PeasyCam.this.mouseRotate(dx, dy);
        }
    };
    private final PeasyDragHandler zoomHandler;
    private PeasyDragHandler rightDraghandler = this.zoomHandler = new PeasyDragHandler(){

        public void handleDrag(double dx, double dy) {
            PeasyCam.this.dampedZoom.impulse(dy / 10.0);
        }
    };
    private final PeasyWheelHandler zoomWheelHandler;
    private PeasyWheelHandler wheelHandler = this.zoomWheelHandler = new PeasyWheelHandler(){

        public void handleWheel(int delta) {
            PeasyCam.this.dampedZoom.impulse(PeasyCam.this.wheelScale * (double)delta);
        }
    };
    private double wheelScale = 1.0;
    private final PeasyEventListener peasyEventListener = new PeasyEventListener();
    private boolean isActive = false;
    private final PMatrix3D originalMatrix;
    public final String VERSION = "201";

    public PeasyCam(PApplet parent, double distance) {
        this(parent, parent.g, 0.0, 0.0, 0.0, distance);
    }

    public PeasyCam(PApplet parent, double lookAtX, double lookAtY, double lookAtZ, double distance) {
        this(parent, parent.g, lookAtX, lookAtY, lookAtZ, distance);
    }

    public PeasyCam(PApplet parent, PGraphics pg, double distance) {
        this(parent, pg, 0.0, 0.0, 0.0, distance);
    }

    public PeasyCam(PApplet parent, PGraphics pg, double lookAtX, double lookAtY, double lookAtZ, double distance) {
        this.p = parent;
        this.g = pg;
        this.startCenter = this.center = new Vector3D(lookAtX, lookAtY, lookAtZ);
        this.startDistance = this.distance = distance;
        this.rotation = new Rotation();
        this.originalMatrix = parent.getMatrix(null);
        this.feed();
        this.rotateX = new DampedAction(this){

            protected void behave(double velocity) {
                PeasyCam.this.rotation = PeasyCam.this.rotation.applyTo(new Rotation(Vector3D.plusI, velocity));
            }
        };
        this.rotateY = new DampedAction(this){

            protected void behave(double velocity) {
                PeasyCam.this.rotation = PeasyCam.this.rotation.applyTo(new Rotation(Vector3D.plusJ, velocity));
            }
        };
        this.rotateZ = new DampedAction(this){

            protected void behave(double velocity) {
                PeasyCam.this.rotation = PeasyCam.this.rotation.applyTo(new Rotation(Vector3D.plusK, velocity));
            }
        };
        this.dampedZoom = new DampedAction(this){

            protected void behave(double velocity) {
                PeasyCam.this.mouseZoom(velocity);
            }
        };
        this.dampedPanX = new DampedAction(this){

            protected void behave(double velocity) {
                PeasyCam.this.mousePan(velocity, 0.0);
            }
        };
        this.dampedPanY = new DampedAction(this){

            protected void behave(double velocity) {
                PeasyCam.this.mousePan(0.0, velocity);
            }
        };
        this.setActive(true);
    }

    public void setActive(boolean active) {
        if (active == this.isActive) {
            return;
        }
        this.isActive = active;
        if (this.isActive) {
            this.p.registerMethod("mouseEvent", (Object)this.peasyEventListener);
            this.p.registerMethod("keyEvent", (Object)this.peasyEventListener);
        } else {
            this.p.unregisterMethod("mouseEvent", (Object)this.peasyEventListener);
            this.p.unregisterMethod("keyEvent", (Object)this.peasyEventListener);
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    @Deprecated
    public void setMouseControlled(boolean isMouseControlled) {
        this.setActive(isMouseControlled);
    }

    public double getWheelScale() {
        return this.wheelScale;
    }

    public void setWheelScale(double wheelScale) {
        this.wheelScale = wheelScale;
    }

    public PeasyDragHandler getPanDragHandler() {
        return this.panHandler;
    }

    public PeasyDragHandler getRotateDragHandler() {
        return this.rotateHandler;
    }

    public PeasyDragHandler getZoomDragHandler() {
        return this.zoomHandler;
    }

    public PeasyWheelHandler getZoomWheelHandler() {
        return this.zoomWheelHandler;
    }

    public void setLeftDragHandler(PeasyDragHandler handler) {
        this.leftDragHandler = handler;
    }

    public void setCenterDragHandler(PeasyDragHandler handler) {
        this.centerDragHandler = handler;
    }

    public void setRightDragHandler(PeasyDragHandler handler) {
        this.rightDraghandler = handler;
    }

    public PeasyWheelHandler getWheelHandler() {
        return this.wheelHandler;
    }

    public void setWheelHandler(PeasyWheelHandler wheelHandler) {
        this.wheelHandler = wheelHandler;
    }

    public String version() {
        return "201";
    }

    private void mouseZoom(double delta) {
        this.safeSetDistance(this.distance + delta * Math.log1p(this.distance));
    }

    private void mousePan(double dxMouse, double dyMouse) {
        double panScale = Math.sqrt(this.distance * 0.005);
        this.pan(this.dragConstraint == Constraint.PITCH ? 0.0 : -dxMouse * panScale, this.dragConstraint == Constraint.YAW ? 0.0 : -dyMouse * panScale);
    }

    private void mouseRotate(double dx, double dy) {
        Vector3D u = LOOK.scalarMultiply(100.0 + 0.6 * this.startDistance).negate();
        int xSign = dx > 0.0 ? -1 : 1;
        int ySign = dy < 0.0 ? -1 : 1;
        double eccentricity = Math.abs((double)this.p.height / 2.0 - (double)this.p.mouseY) / ((double)this.p.height / 2.0);
        double rho = Math.abs((double)this.p.width / 2.0 - (double)this.p.mouseX) / ((double)this.p.width / 2.0);
        if (this.dragConstraint == null || this.dragConstraint == Constraint.YAW || this.dragConstraint == Constraint.SUPPRESS_ROLL) {
            double adx = Math.abs(dx) * (1.0 - eccentricity);
            Vector3D vx = u.add(new Vector3D(adx, 0.0, 0.0));
            this.rotateY.impulse(Vector3D.angle(u, vx) * (double)xSign);
        }
        if (this.dragConstraint == null || this.dragConstraint == Constraint.PITCH || this.dragConstraint == Constraint.SUPPRESS_ROLL) {
            double ady = Math.abs(dy) * (1.0 - rho);
            Vector3D vy = u.add(new Vector3D(0.0, ady, 0.0));
            this.rotateX.impulse(Vector3D.angle(u, vy) * (double)ySign);
        }
        if (this.dragConstraint == null || this.dragConstraint == Constraint.ROLL) {
            double adz = Math.abs(dy) * rho;
            Vector3D vz = u.add(new Vector3D(0.0, adz, 0.0));
            this.rotateZ.impulse(Vector3D.angle(u, vz) * (double)(-ySign) * (double)(this.p.mouseX < this.p.width / 2 ? -1 : 1));
            adz = Math.abs(dx) * eccentricity;
            vz = u.add(new Vector3D(0.0, adz, 0.0));
            this.rotateZ.impulse(Vector3D.angle(u, vz) * (double)xSign * (double)(this.p.mouseY > this.p.height / 2 ? -1 : 1));
        }
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double newDistance) {
        this.setDistance(newDistance, 300L);
    }

    public void setDistance(double newDistance, long animationTimeMillis) {
        this.distanceInterps.startInterpolation(new DistanceInterp(newDistance, animationTimeMillis));
    }

    public float[] getLookAt() {
        return new float[]{(float)this.center.getX(), (float)this.center.getY(), (float)this.center.getZ()};
    }

    public void lookAt(double x, double y, double z) {
        this.centerInterps.startInterpolation(new CenterInterp(new Vector3D(x, y, z), 300L));
    }

    public void lookAt(double x, double y, double z, double distance) {
        this.lookAt(x, y, z);
        this.setDistance(distance);
    }

    public void lookAt(double x, double y, double z, long animationTimeMillis) {
        this.lookAt(x, y, z, this.distance, animationTimeMillis);
    }

    public void lookAt(double x, double y, double z, double distance, long animationTimeMillis) {
        this.setState(new CameraState(this.rotation, new Vector3D(x, y, z), distance), animationTimeMillis);
    }

    private void safeSetDistance(double distance) {
        this.distance = Math.min(this.maximumDistance, Math.max(this.minimumDistance, distance));
        this.feed();
    }

    public void feed() {
        Vector3D pos = this.rotation.applyTo(LOOK).scalarMultiply(this.distance).add(this.center);
        Vector3D rup = this.rotation.applyTo(UP);
        this.g.camera((float)pos.getX(), (float)pos.getY(), (float)pos.getZ(), (float)this.center.getX(), (float)this.center.getY(), (float)this.center.getZ(), (float)rup.getX(), (float)rup.getY(), (float)rup.getZ());
    }

    static void apply(PGraphics g, Vector3D center, Rotation rotation, double distance) {
        Vector3D pos = rotation.applyTo(LOOK).scalarMultiply(distance).add(center);
        Vector3D rup = rotation.applyTo(UP);
        g.camera((float)pos.getX(), (float)pos.getY(), (float)pos.getZ(), (float)center.getX(), (float)center.getY(), (float)center.getZ(), (float)rup.getX(), (float)rup.getY(), (float)rup.getZ());
    }

    public float[] getPosition() {
        Vector3D pos = this.rotation.applyTo(LOOK).scalarMultiply(this.distance).add(this.center);
        return new float[]{(float)pos.getX(), (float)pos.getY(), (float)pos.getZ()};
    }

    public void reset() {
        this.reset(300L);
    }

    public void reset(long animationTimeInMillis) {
        this.setState(new CameraState(new Rotation(), this.startCenter, this.startDistance), animationTimeInMillis);
    }

    public void pan(double dx, double dy) {
        this.center = this.center.add(this.rotation.applyTo(new Vector3D(dx, dy, 0.0)));
        this.feed();
    }

    public void rotateX(double angle) {
        this.rotation = this.rotation.applyTo(new Rotation(Vector3D.plusI, angle));
        this.feed();
    }

    public void rotateY(double angle) {
        this.rotation = this.rotation.applyTo(new Rotation(Vector3D.plusJ, angle));
        this.feed();
    }

    public void rotateZ(double angle) {
        this.rotation = this.rotation.applyTo(new Rotation(Vector3D.plusK, angle));
        this.feed();
    }

    PApplet getApplet() {
        return this.p;
    }

    public CameraState getState() {
        return new CameraState(this.rotation, this.center, this.distance);
    }

    public void setFreeRotationMode() {
        this.permaConstraint = null;
    }

    public void setYawRotationMode() {
        this.permaConstraint = Constraint.YAW;
    }

    public void setPitchRotationMode() {
        this.permaConstraint = Constraint.PITCH;
    }

    public void setRollRotationMode() {
        this.permaConstraint = Constraint.ROLL;
    }

    public void setSuppressRollRotationMode() {
        this.permaConstraint = Constraint.SUPPRESS_ROLL;
    }

    public void setMinimumDistance(double minimumDistance) {
        this.minimumDistance = minimumDistance;
        this.safeSetDistance(this.distance);
    }

    public void setMaximumDistance(double maximumDistance) {
        this.maximumDistance = maximumDistance;
        this.safeSetDistance(this.distance);
    }

    public void setResetOnDoubleClick(boolean resetOnDoubleClick) {
        this.resetOnDoubleClick = resetOnDoubleClick;
    }

    public void setState(CameraState state) {
        this.setState(state, 300L);
    }

    public void setState(CameraState state, long animationTimeMillis) {
        if (animationTimeMillis > 0L) {
            this.rotationInterps.startInterpolation(new RotationInterp(state.rotation, animationTimeMillis));
            this.centerInterps.startInterpolation(new CenterInterp(state.center, animationTimeMillis));
            this.distanceInterps.startInterpolation(new DistanceInterp(state.distance, animationTimeMillis));
        } else {
            this.rotation = state.rotation;
            this.center = state.center;
            this.distance = state.distance;
        }
        this.feed();
    }

    public void setRotations(double pitch, double yaw, double roll) {
        this.rotationInterps.cancelInterpolation();
        this.rotation = new Rotation(RotationOrder.XYZ, pitch, yaw, roll);
        this.feed();
    }

    public float[] getRotations() {
        try {
            double[] angles = this.rotation.getAngles(RotationOrder.XYZ);
            return new float[]{(float)angles[0], (float)angles[1], (float)angles[2]};
        }
        catch (CardanEulerSingularityException angles) {
            try {
                double[] angles2 = this.rotation.getAngles(RotationOrder.YXZ);
                return new float[]{(float)angles2[1], (float)angles2[0], (float)angles2[2]};
            }
            catch (CardanEulerSingularityException angles2) {
                try {
                    double[] angles3 = this.rotation.getAngles(RotationOrder.ZXY);
                    return new float[]{(float)angles3[2], (float)angles3[0], (float)angles3[1]};
                }
                catch (CardanEulerSingularityException cardanEulerSingularityException) {
                    return new float[]{0.0f, 0.0f, 0.0f};
                }
            }
        }
    }

    public void beginHUD() {
        this.g.pushMatrix();
        this.g.hint(2);
        this.g.resetMatrix();
        this.g.applyMatrix(this.originalMatrix);
    }

    public void endHUD() {
        this.g.hint(-2);
        this.g.popMatrix();
    }

    public abstract class AbstractInterp {
        double startTime;
        final double timeInMillis;

        protected AbstractInterp(long timeInMillis) {
            this.timeInMillis = timeInMillis;
        }

        void start() {
            this.startTime = PeasyCam.this.p.millis();
            PeasyCam.this.p.registerMethod("draw", (Object)this);
        }

        void cancel() {
            PeasyCam.this.p.unregisterMethod("draw", (Object)this);
        }

        public void draw() {
            double t = ((double)PeasyCam.this.p.millis() - this.startTime) / this.timeInMillis;
            if (t > 0.99) {
                this.cancel();
                this.setEndState();
            } else {
                this.interp(t);
            }
            PeasyCam.this.feed();
        }

        protected abstract void interp(double var1);

        protected abstract void setEndState();
    }

    class CenterInterp
    extends AbstractInterp {
        private final Vector3D startCenter;
        private final Vector3D endCenter;

        public CenterInterp(Vector3D endCenter, long timeInMillis) {
            super(timeInMillis);
            this.startCenter = PeasyCam.this.center;
            this.endCenter = endCenter;
        }

        protected void interp(double t) {
            PeasyCam.this.center = InterpolationUtil.smooth(this.startCenter, this.endCenter, t);
        }

        protected void setEndState() {
            PeasyCam.this.center = this.endCenter;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Constraint {
        YAW,
        PITCH,
        ROLL,
        SUPPRESS_ROLL;

    }

    class DistanceInterp
    extends AbstractInterp {
        private final double startDistance;
        private final double endDistance;

        public DistanceInterp(double endDistance, long timeInMillis) {
            super(timeInMillis);
            this.startDistance = PeasyCam.this.distance;
            this.endDistance = Math.min(PeasyCam.this.maximumDistance, Math.max(PeasyCam.this.minimumDistance, endDistance));
        }

        protected void interp(double t) {
            PeasyCam.this.distance = InterpolationUtil.smooth(this.startDistance, this.endDistance, t);
        }

        protected void setEndState() {
            PeasyCam.this.distance = this.endDistance;
        }
    }

    protected class PeasyEventListener {
        protected PeasyEventListener() {
        }

        public void keyEvent(KeyEvent e) {
            if (e.getAction() == 2 && e.isShiftDown()) {
                PeasyCam.this.dragConstraint = null;
            }
        }

        public void mouseEvent(MouseEvent e) {
            switch (e.getAction()) {
                case 8: {
                    PeasyCam.this.wheelHandler.handleWheel(e.getCount());
                    break;
                }
                case 2: {
                    PeasyCam.this.dragConstraint = null;
                    break;
                }
                case 3: {
                    if (!PeasyCam.this.resetOnDoubleClick || 2 != e.getCount()) break;
                    PeasyCam.this.reset();
                    break;
                }
                case 4: {
                    double dx = ((PeasyCam)PeasyCam.this).p.mouseX - ((PeasyCam)PeasyCam.this).p.pmouseX;
                    double dy = ((PeasyCam)PeasyCam.this).p.mouseY - ((PeasyCam)PeasyCam.this).p.pmouseY;
                    if (e.isShiftDown()) {
                        if (PeasyCam.this.dragConstraint == null && Math.abs(dx - dy) > 1.0) {
                            PeasyCam.this.dragConstraint = Math.abs(dx) > Math.abs(dy) ? Constraint.YAW : Constraint.PITCH;
                        }
                    } else if (PeasyCam.this.permaConstraint != null) {
                        PeasyCam.this.dragConstraint = PeasyCam.this.permaConstraint;
                    } else {
                        PeasyCam.this.dragConstraint = null;
                    }
                    int b = ((PeasyCam)PeasyCam.this).p.mouseButton;
                    if (PeasyCam.this.centerDragHandler != null && (b == 3 || b == 37 && e.isMetaDown())) {
                        PeasyCam.this.centerDragHandler.handleDrag(dx, dy);
                        break;
                    }
                    if (PeasyCam.this.leftDragHandler != null && b == 37) {
                        PeasyCam.this.leftDragHandler.handleDrag(dx, dy);
                        break;
                    }
                    if (PeasyCam.this.rightDraghandler == null || b != 39) break;
                    PeasyCam.this.rightDraghandler.handleDrag(dx, dy);
                }
            }
        }
    }

    class RotationInterp
    extends AbstractInterp {
        final Rotation startRotation;
        final Rotation endRotation;

        public RotationInterp(Rotation endRotation, long timeInMillis) {
            super(timeInMillis);
            this.startRotation = PeasyCam.this.rotation;
            this.endRotation = endRotation;
        }

        void start() {
            PeasyCam.this.rotateX.stop();
            PeasyCam.this.rotateY.stop();
            PeasyCam.this.rotateZ.stop();
            super.start();
        }

        protected void interp(double t) {
            PeasyCam.this.rotation = InterpolationUtil.slerp(this.startRotation, this.endRotation, t);
        }

        protected void setEndState() {
            PeasyCam.this.rotation = this.endRotation;
        }
    }
}

