/*
 * Decompiled with CFR 0.152.
 */
package moonlander.library;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import moonlander.library.Track;
import moonlander.library.TrackContainerListener;

class TrackContainer {
    private LinkedHashMap<String, Track> tracks = new LinkedHashMap();
    private ArrayList<TrackContainerListener> listeners = new ArrayList();

    public void addEventListener(TrackContainerListener trackContainerListener) {
        this.listeners.add(trackContainerListener);
    }

    public void removeEventListener(TrackContainerListener trackContainerListener) {
        this.listeners.remove(trackContainerListener);
    }

    public Track get(String string) {
        return this.tracks.get(string);
    }

    public Track getById(int n) {
        return new ArrayList<Track>(this.tracks.values()).get(n);
    }

    public Track getOrCreate(String string) {
        Track track = this.get(string);
        if (track == null) {
            track = new Track(string);
            this.tracks.put(string, track);
            for (TrackContainerListener trackContainerListener : this.listeners) {
                trackContainerListener.trackAdded(string);
            }
        }
        return track;
    }

    public void delete(String string) {
        if (this.tracks.get(string) != null) {
            this.tracks.remove(string);
            for (TrackContainerListener trackContainerListener : this.listeners) {
                trackContainerListener.trackDeleted(string);
            }
        }
    }

    public List<Track> getAll() {
        return Collections.unmodifiableList(new ArrayList<Track>(this.tracks.values()));
    }
}

