/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.AudioMetaData;
import ddf.minim.MultiChannelBuffer;
import ddf.minim.spi.AudioRecording;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;

class JSAudioRecordingClip
implements AudioRecording {
    private Clip c;
    private int loopCount;
    private AudioMetaData meta;
    private boolean playing;

    JSAudioRecordingClip(Clip clip, AudioMetaData mdata) {
        this.c = clip;
        this.c.addLineListener(new LineListener(){

            public void update(LineEvent event) {
                if (event.getType().equals(LineEvent.Type.STOP)) {
                    if (JSAudioRecordingClip.this.playing && JSAudioRecordingClip.this.loopCount != 0) {
                        JSAudioRecordingClip.this.c.setMicrosecondPosition(0L);
                        JSAudioRecordingClip.this.c.start();
                        if (JSAudioRecordingClip.this.loopCount > 0) {
                            JSAudioRecordingClip jSAudioRecordingClip = JSAudioRecordingClip.this;
                            jSAudioRecordingClip.loopCount = jSAudioRecordingClip.loopCount - 1;
                        }
                    } else {
                        JSAudioRecordingClip.this.playing = false;
                    }
                }
            }
        });
        this.playing = false;
        this.loopCount = 0;
        this.meta = mdata;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public int getMillisecondLength() {
        return (int)this.c.getMicrosecondLength() / 1000;
    }

    public int getMillisecondPosition() {
        return (int)this.c.getMicrosecondPosition() / 1000;
    }

    public AudioMetaData getMetaData() {
        return this.meta;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void loop(int count) {
        this.play();
        this.loopCount = count;
    }

    public void setLoopPoints(int start, int end) {
        this.c.setLoopPoints(start, end);
    }

    public void setMillisecondPosition(int pos) {
        this.c.setMicrosecondPosition(pos * 1000);
    }

    public void play() {
        if (this.c.getMicrosecondPosition() != this.c.getMicrosecondLength()) {
            this.c.start();
            this.playing = true;
        }
    }

    public void pause() {
        this.c.stop();
        this.playing = false;
    }

    public void close() {
        this.c.close();
    }

    public Control[] getControls() {
        return this.c.getControls();
    }

    public AudioFormat getFormat() {
        return this.c.getFormat();
    }

    public void open() {
    }

    public int bufferSize() {
        return 0;
    }

    public float[] read() {
        return null;
    }

    public void read(MultiChannelBuffer buffer) {
    }
}

