/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.AudioMetaData;
import ddf.minim.MultiChannelBuffer;
import ddf.minim.javasound.JSMinim;
import ddf.minim.spi.AudioRecording;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.SourceDataLine;
import org.tritonus.share.sampled.AudioUtils;

class JSAudioRecording
implements AudioRecording,
Runnable {
    private AudioMetaData meta;
    private byte[] samples;
    private Thread iothread;
    private boolean play;
    private boolean loop;
    private int numLoops;
    private int loopBegin;
    private int loopEnd;
    private byte[] rawBytes;
    private int totalBytesRead;
    private boolean shouldRead;
    private int bytesWritten;
    protected AudioFormat format;
    private SourceDataLine line;
    private boolean finished;
    private JSMinim system;

    JSAudioRecording(JSMinim sys, byte[] samps, SourceDataLine sdl, AudioMetaData mdata) {
        this.system = sys;
        this.samples = samps;
        this.meta = mdata;
        this.format = sdl.getFormat();
        this.finished = false;
        this.line = sdl;
        this.loop = false;
        this.play = false;
        this.numLoops = 0;
        this.loopBegin = 0;
        this.loopEnd = (int)AudioUtils.millis2BytesFrameAligned((long)this.meta.length(), (AudioFormat)this.format);
        this.rawBytes = new byte[sdl.getBufferSize() / 8];
        this.iothread = null;
        this.totalBytesRead = 0;
        this.bytesWritten = 0;
        this.shouldRead = true;
    }

    public void run() {
        while (!this.finished) {
            if (this.play) {
                if (this.shouldRead) {
                    if (this.loop) {
                        this.readBytesLoop();
                    } else {
                        this.readBytes();
                    }
                }
                this.writeBytes();
                Thread.yield();
                continue;
            }
            this.sleep(30000);
        }
        this.line.flush();
        this.line.close();
        this.line = null;
    }

    private void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void readBytes() {
        int samplesLeft = this.samples.length - this.totalBytesRead;
        if (samplesLeft < this.rawBytes.length) {
            this.readBytes(samplesLeft, 0);
            this.system.debug("readBytes: filling rawBytes from " + samplesLeft + " to " + this.rawBytes.length + " with silence.");
            int silent = 0;
            if (this.format.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED) {
                silent = -128;
            }
            int i = samplesLeft;
            while (i < this.rawBytes.length) {
                this.rawBytes[i] = silent;
                ++i;
            }
            this.play = false;
        } else {
            this.readBytes(this.rawBytes.length, 0);
        }
    }

    private synchronized void readBytesLoop() {
        int toLoopEnd = this.loopEnd - this.totalBytesRead;
        if (toLoopEnd <= 0) {
            this.setMillisecondPosition(this.loopBegin);
            this.readBytesLoop();
            return;
        }
        if (toLoopEnd < this.rawBytes.length) {
            this.readBytes(toLoopEnd, 0);
            if (this.loop && this.numLoops == 0) {
                this.loop = false;
                this.play = false;
            } else if (this.loop) {
                this.setMillisecondPosition(this.loopBegin);
                this.readBytes(this.rawBytes.length - toLoopEnd, toLoopEnd);
                if (this.numLoops != -1) {
                    --this.numLoops;
                }
            }
        } else {
            this.readBytes(this.rawBytes.length, 0);
        }
    }

    private void readBytes(int toRead, int offset) {
        System.arraycopy(this.samples, this.totalBytesRead, this.rawBytes, offset, toRead);
        this.totalBytesRead += toRead;
    }

    private void writeBytes() {
        int needToWrite = this.rawBytes.length - this.bytesWritten;
        int actualWrit = this.line.write(this.rawBytes, this.bytesWritten, needToWrite);
        if (actualWrit != needToWrite) {
            this.shouldRead = false;
            this.bytesWritten += actualWrit;
        } else {
            this.shouldRead = true;
            this.bytesWritten = 0;
        }
    }

    public void play() {
        this.line.start();
        this.loop = false;
        this.numLoops = 0;
        this.play = true;
        this.iothread.interrupt();
    }

    public boolean isPlaying() {
        return this.play;
    }

    public void pause() {
        this.line.stop();
        this.play = false;
    }

    public void loop(int n) {
        this.loop = true;
        this.numLoops = n;
        this.play = true;
        this.setMillisecondPosition(this.loopBegin);
        this.line.start();
        this.iothread.interrupt();
    }

    public void open() {
        this.iothread = new Thread(this);
        this.finished = false;
        this.iothread.start();
    }

    public void close() {
        this.line.stop();
        this.finished = true;
        try {
            this.iothread.join(10L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.iothread = null;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public int getLoopCount() {
        return this.numLoops;
    }

    public synchronized void setLoopPoints(int start, int stop) {
        this.loopBegin = start <= 0 || start > stop ? 0 : start;
        this.loopEnd = stop <= this.getMillisecondLength() && stop > start ? (int)AudioUtils.millis2BytesFrameAligned((long)stop, (AudioFormat)this.format) : (int)AudioUtils.millis2BytesFrameAligned((long)this.getMillisecondLength(), (AudioFormat)this.format);
    }

    public int getMillisecondPosition() {
        return (int)AudioUtils.bytes2Millis((long)this.totalBytesRead, (AudioFormat)this.format);
    }

    public synchronized void setMillisecondPosition(int millis) {
        this.totalBytesRead = millis <= 0 ? 0 : (millis > this.getMillisecondLength() ? this.samples.length : (int)AudioUtils.millis2BytesFrameAligned((long)millis, (AudioFormat)this.format));
    }

    public Control[] getControls() {
        return this.line.getControls();
    }

    public AudioMetaData getMetaData() {
        return this.meta;
    }

    public int getMillisecondLength() {
        return this.meta.length();
    }

    public int bufferSize() {
        return 0;
    }

    public float[] read() {
        return null;
    }

    public void read(MultiChannelBuffer buffer) {
    }
}

