/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.analysis;

import ddf.minim.Minim;
import ddf.minim.analysis.FourierTransform;

public class DFT
extends FourierTransform {
    private float[] sinlookup;
    private float[] coslookup;

    public DFT(int timeSize, float sampleRate) {
        super(timeSize, sampleRate);
        if (timeSize % 2 != 0) {
            throw new IllegalArgumentException("DFT: timeSize must be even.");
        }
        this.buildTrigTables();
    }

    protected void allocateArrays() {
        this.spectrum = new float[this.timeSize / 2 + 1];
        this.real = new float[this.timeSize / 2 + 1];
        this.imag = new float[this.timeSize / 2 + 1];
    }

    public void scaleBand(int i, float s) {
    }

    public void setBand(int i, float a) {
    }

    public void forward(float[] samples) {
        if (samples.length != this.timeSize) {
            Minim.error("DFT.forward: The length of the passed sample buffer must be equal to DFT.timeSize().");
            return;
        }
        this.doWindow(samples);
        int N = samples.length;
        int f = 0;
        while (f <= N / 2) {
            this.real[f] = 0.0f;
            this.imag[f] = 0.0f;
            int t = 0;
            while (t < N) {
                int n = f;
                this.real[n] = this.real[n] + samples[t] * this.cos(t * f);
                int n2 = f;
                this.imag[n2] = this.imag[n2] + samples[t] * -this.sin(t * f);
                ++t;
            }
            ++f;
        }
        this.fillSpectrum();
    }

    public void inverse(float[] buffer) {
        int N = buffer.length;
        this.real[0] = this.real[0] / (float)N;
        this.imag[0] = -this.imag[0] / (float)(N / 2);
        int n = N / 2;
        this.real[n] = this.real[n] / (float)N;
        this.imag[N / 2] = -this.imag[0] / (float)(N / 2);
        int i = 0;
        while (i < N / 2) {
            int n2 = i;
            this.real[n2] = this.real[n2] / (float)(N / 2);
            this.imag[i] = -this.imag[i] / (float)(N / 2);
            ++i;
        }
        int t = 0;
        while (t < N) {
            buffer[t] = 0.0f;
            int f = 0;
            while (f < N / 2) {
                int n3 = t;
                buffer[n3] = buffer[n3] + (this.real[f] * this.cos(t * f) + this.imag[f] * this.sin(t * f));
                ++f;
            }
            ++t;
        }
    }

    private void buildTrigTables() {
        int N = this.spectrum.length * this.timeSize;
        this.sinlookup = new float[N];
        this.coslookup = new float[N];
        int i = 0;
        while (i < N) {
            this.sinlookup[i] = (float)Math.sin((float)i * ((float)Math.PI * 2) / (float)this.timeSize);
            this.coslookup[i] = (float)Math.cos((float)i * ((float)Math.PI * 2) / (float)this.timeSize);
            ++i;
        }
    }

    private float sin(int i) {
        return this.sinlookup[i];
    }

    private float cos(int i) {
        return this.coslookup[i];
    }
}

