//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.Dynamic;

namespace Framefield.Core.ID9fd3ae11_52c4_440d_82cc_6ff5d5020a80
{
    public class Class_PointLightRaw : OperatorPart.Function, IPointLight
    {
        //>>> _inputids
        private enum InputId
        {
            Scene = 0,
            PositionX = 1,
            PositionY = 2,
            PositionZ = 3,
            AmbientR = 4,
            AmbientG = 5,
            AmbientB = 6,
            AmbientA = 7,
            DiffuseR = 8,
            DiffuseG = 9,
            DiffuseB = 10,
            DiffuseA = 11,
            SpecularR = 12,
            SpecularG = 13,
            SpecularB = 14,
            SpecularA = 15,
            IntensityAmbient = 16,
            IntensityDiffuse = 17,
            IntensitySpecular = 18,
            AttenuationLinear = 19,
            AttenuationQuad = 20,
            AttenuationCubic = 21,
            Enabled = 22
        }
        //<<< _inputids
        //>>> _outputids
        private enum OutputId
        {
            Scene = 0,
            This = 1
        }
        //<<< _outputids
    
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) {
            //>>> _params
            var Scene = inputs[(int)InputId.Scene];
            var PositionX = inputs[(int)InputId.PositionX].Eval(context).Value;
            var PositionY = inputs[(int)InputId.PositionY].Eval(context).Value;
            var PositionZ = inputs[(int)InputId.PositionZ].Eval(context).Value;
            var Position = new Vector3(PositionX, PositionY, PositionZ);
            var AmbientR = inputs[(int)InputId.AmbientR].Eval(context).Value;
            var AmbientG = inputs[(int)InputId.AmbientG].Eval(context).Value;
            var AmbientB = inputs[(int)InputId.AmbientB].Eval(context).Value;
            var AmbientA = inputs[(int)InputId.AmbientA].Eval(context).Value;
            var Ambient = new Color4(AmbientR, AmbientG, AmbientB, AmbientA);
            var DiffuseR = inputs[(int)InputId.DiffuseR].Eval(context).Value;
            var DiffuseG = inputs[(int)InputId.DiffuseG].Eval(context).Value;
            var DiffuseB = inputs[(int)InputId.DiffuseB].Eval(context).Value;
            var DiffuseA = inputs[(int)InputId.DiffuseA].Eval(context).Value;
            var Diffuse = new Color4(DiffuseR, DiffuseG, DiffuseB, DiffuseA);
            var SpecularR = inputs[(int)InputId.SpecularR].Eval(context).Value;
            var SpecularG = inputs[(int)InputId.SpecularG].Eval(context).Value;
            var SpecularB = inputs[(int)InputId.SpecularB].Eval(context).Value;
            var SpecularA = inputs[(int)InputId.SpecularA].Eval(context).Value;
            var Specular = new Color4(SpecularR, SpecularG, SpecularB, SpecularA);
            var IntensityAmbient = inputs[(int)InputId.IntensityAmbient].Eval(context).Value;
            var IntensityDiffuse = inputs[(int)InputId.IntensityDiffuse].Eval(context).Value;
            var IntensitySpecular = inputs[(int)InputId.IntensitySpecular].Eval(context).Value;
            var Intensity = new Vector3(IntensityAmbient, IntensityDiffuse, IntensitySpecular);
            var AttenuationLinear = inputs[(int)InputId.AttenuationLinear].Eval(context).Value;
            var AttenuationQuad = inputs[(int)InputId.AttenuationQuad].Eval(context).Value;
            var AttenuationCubic = inputs[(int)InputId.AttenuationCubic].Eval(context).Value;
            var Attenuation = new Vector3(AttenuationLinear, AttenuationQuad, AttenuationCubic);
            var Enabled = (int) inputs[(int)InputId.Enabled].Eval(context).Value;
            //<<< _params

            // store values for later use of IPointLight
            this.Position = Position;
            this.Ambient = Ambient;
            this.Diffuse = Diffuse;
            this.Specular = Specular;
            this.Intensity = Intensity;
            this.Attenuation = Attenuation;
            
            var isLightEnabled = Enabled > 0.01f;
            var pointLightContainer = (HashSet<IPointLight>) context.Objects[OperatorPartContext.POINT_LIGHT_CONTAINER_ID];
            if (isLightEnabled && (pointLightContainer != null)) {
                pointLightContainer.Add(this);
            }
            else {
                //Logger.Error(this,"No point light container found in context!");
            }

            switch (outputIdx)
            {
                case (int)OutputId.Scene:
                    Scene.Eval(context);
                    break;
                case (int)OutputId.This:
                    dynamic obj = new ExpandoObject();
                    obj.This = this;
                    context.Dynamic = obj;
                    break;
            }

            pointLightContainer.Remove(this);

            return context;
        }

        public Vector3 Position { get; private set; }
        public Color4 Ambient { get; private set; }
        public Color4 Diffuse { get; private set; }
        public Color4 Specular { get; private set; }
        public Vector3 Intensity { get; private set; }
        public Vector3 Attenuation { get; private set; }
    }
}

