using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;

namespace Framefield.Core.IDf211e095_ff6d_49eb_aaaa_9d8485599122
{
    public class Class_SetTexture : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            Scene = 0,
            Image = 1
        }
        //<<< _inputids

        public override void Dispose()
        {
            Utilities.DisposeObj(ref _texture);
        }
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> __params
            var Scene = inputs[(int)InputId.Scene];
            var ImageInput = inputs[(int)InputId.Image];
            //<<< __params

            if (ImageInput.Func.Changed)
            {
                var Image = ImageInput.Eval(context).Image;
                Dispose();
                if (Image != null)
                {
                    _texture = new ShaderResourceView(context.D3DDevice, Image);
                }
                ImageInput.Func.Changed = false;
            }

            var prevTexture0 = context.Texture0;
            if (_texture != null)
                context.Texture0 = _texture;

            Scene.Eval(context);

            context.Texture0 = prevTexture0;
            return context;
        }

        ShaderResourceView _texture = null;
    }
}

