#include <cpctelera.h>
#include <types.h>
#include "../maps/campo.h"
#include "../characters/pingu.h"
#include "../characters/pingu2.h"
#include "../IA/ia.h"

typedef struct
{
   i16 ax, ay;           // Acceleration (instant velocity)
   i16 vx, vy;           // Acumulated velocity
   i16 max_x, max_y;     // Max velocity
} TVelocity;

typedef struct
{
   const u8* sprite;
   u8* videopos;
   u8 id, x, y, px, py, width, height, ignoreSQR;
   i16 kilograms;
   TVelocity vel;
} TEntity;

  u8 *getScreenPointer        (u8 y);
void moveEntityX              (TEntity* ent, i8 mx);
void moveEntityY              (TEntity* ent, i8 my);
  u8 updateEntities           (TEntity *pingu,  TEntity *pingu_enemy, TEntity *ball, i8 ia);
  u8 collisionEntity1X        (TEntity *ent1, TEntity *ent2, i8 dx);
  u8 collisionEntity1Y        (TEntity *ent1, TEntity *ent2, i8 dx);
void updateEntityAccelerations(TEntity *ent);
void checkUserInput           (TEntity *ent);
void updateEntityVideopos     (TEntity * ent) __z88dk_fastcall;
  u8 golPorteria              (TEntity * ent) __z88dk_fastcall;
void updateEntityPhysics      (TEntity * ent);
void calculateEntityCollisions(TEntity *pingu, TEntity *pingu_enemy, TEntity *ball);
void doubleCollisionX         (TEntity *ent1, TEntity *ent2);
void simpleCollisionX         (TEntity *ent1, TEntity *ent2);
void doubleCollisionY         (TEntity *ent1, TEntity *ent2);
void simpleCollisionY         (TEntity *ent1, TEntity *ent2);
void pairCheckCollisionY      (TEntity *ent1, TEntity *ent2);
void pairCheckCollisionY      (TEntity *ent1, TEntity *ent2);
void initFuzzy                (u8 level);
void initConstants            (i16 scaledFriction);
