//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Hair Boy
//  Copyright (C) 2016 Carlos Sevila (@CarlosSevila)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#include "util.h"

#include "../art/sprites.h"
#include "../globals.h"

u8 GetLeftPixelValue(u8 b) {
	u8 result = 0;

	if (b & BIT_2) {
		result |= BIT_4;
	}

	if (b & BIT_4) {
		result |= BIT_2;
	}

	if (b & BIT_6) {
		result |= BIT_3;
	}

	if (b & BIT_8) {
		result |= BIT_1;
	}

	return result;
}

u8 GetRightPixelValue(u8 b) {
	u8 result = 0;

	if (b & BIT_1) {
		result |= BIT_4;
	}

	if (b & BIT_3) {
		result |= BIT_2;
	}

	if (b & BIT_5) {
		result |= BIT_3;
	}

	if (b & BIT_7) {
		result |= BIT_1;
	}

	return result;
}

void DrawNumber(u8 number, u8* memory) {
	switch (number) {
		case 0:
			cpct_drawTileAligned2x8_f(kNumber0, memory);
			break;
		case 1:
			cpct_drawTileAligned2x8_f(kNumber1, memory);
			break;
		case 2:
			cpct_drawTileAligned2x8_f(kNumber2, memory);
			break;
		case 3:
			cpct_drawTileAligned2x8_f(kNumber3, memory);
			break;
		case 4:
			cpct_drawTileAligned2x8_f(kNumber4, memory);
			break;
		case 5:
			cpct_drawTileAligned2x8_f(kNumber5, memory);
			break;
		case 6:
			cpct_drawTileAligned2x8_f(kNumber6, memory);
			break;
		case 7:
			cpct_drawTileAligned2x8_f(kNumber7, memory);
			break;
		case 8:
			cpct_drawTileAligned2x8_f(kNumber8, memory);
			break;
		case 9:
			cpct_drawTileAligned2x8_f(kNumber9, memory);
			break;
		default:
			cpct_drawTileAligned2x8_f(kNumber0, memory);
	}
}

void DrawDots(u8* memory) {
	cpct_drawTileAligned2x8_f(kNumberDots, memory);
}

u8 DrawComposedNumber(u16 number, u8 x, u8 y, u8 reverse) {
	u8 *pscr;
	u8 digits[6];
	i8 i = 0;
	u8 size = 0;

	while (number > 9) {
		digits[i] = number % 10;
		number = number / 10;
		i++;
	}

	digits[i] = number;
	size = i;

	if (reverse) {
		for (i = 0; i <= size; i++) {
			pscr = cpct_getScreenPtr(CPCT_VMEM_START, x, y);
			DrawNumber(digits[i], pscr);
			x = x - 2;
		}
	} else {
		for (i = size; i > -1; i--) {
			pscr = cpct_getScreenPtr(CPCT_VMEM_START, x, y);
			DrawNumber(digits[i], pscr);
			x = x + 2;
		}
	}

	return size + 1;	// Number of digits of the number.
}

void WaitKeyUp(cpct_keyID key) {
    while (cpct_isKeyPressed(key)) {
        cpct_scanKeyboard_f();
    }
}
