//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Hair Boy
//  Copyright (C) 2016 Carlos Sevila (@CarlosSevila)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#include "score.h"

#include <cpctelera.h>
#include "../globals.h"
#include "../art/sprites.h"
#include "../util/util.h"

void InitializeScore(u8 *currentMap, u16 *totalDefeats, u8 *seconds, u16 *minutes) {
    u8 *pscr;
    u8 digits;

    cpct_clearScreen_f64(0);

    // Horizontal lines.
    pscr = cpct_getScreenPtr(CPCT_VMEM_START, 0, 0);
    cpct_drawSolidBox(pscr, cpct_px2byteM0(COLOR_RED, COLOR_RED), 40, 2);
    cpct_drawSolidBox(pscr + 40, cpct_px2byteM0(COLOR_RED, COLOR_RED), 40, 2);
    pscr = cpct_getScreenPtr(CPCT_VMEM_START, 0, SCR_HEIGHT - 2);
    cpct_drawSolidBox(pscr, cpct_px2byteM0(COLOR_RED, COLOR_RED), 40, 2);
    cpct_drawSolidBox(pscr + 40, cpct_px2byteM0(COLOR_RED, COLOR_RED), 40, 2);

    // Vertical lines.
    pscr = cpct_getScreenPtr(CPCT_VMEM_START, 0, 1);
    cpct_drawSolidBox(pscr, cpct_px2byteM0(COLOR_RED, COLOR_RED), 1, SCR_HEIGHT - 2);
    pscr = cpct_getScreenPtr(CPCT_VMEM_START, SCR_WIDTH - 1, 1);
    cpct_drawSolidBox(pscr, cpct_px2byteM0(COLOR_RED, COLOR_RED), 1, SCR_HEIGHT - 2);

    // Maps.
    pscr = cpct_getScreenPtr(CPCT_VMEM_START, 20, 40);
    cpct_drawSprite(kMapsText, pscr, 9, 8);

    digits = DrawComposedNumber(*currentMap, 48, 40, 0);

    pscr = cpct_getScreenPtr(CPCT_VMEM_START, 48 + digits * 2 + 2, 40);
    cpct_drawSprite(kOfText, pscr, 4, 8);

    digits = DrawComposedNumber(NUM_MAPS, 48 + digits * 2 + 8, 40, 0);

    // Defeats.
    pscr = cpct_getScreenPtr(CPCT_VMEM_START, 20, 64);
    cpct_drawSprite(kDefeatsText, pscr, 15, 8);

    digits = DrawComposedNumber(*totalDefeats, 48, 64, 0);

    // Time.
    pscr = cpct_getScreenPtr(CPCT_VMEM_START, 20, 88);
    cpct_drawSprite(kTimeText, pscr, 9, 8);

    digits = DrawComposedNumber(*minutes, 48, 88, 0);

    pscr = cpct_getScreenPtr(CPCT_VMEM_START, 48 + digits * 2, 88);
    DrawDots(pscr);

    if (*seconds < 10) {
        pscr = cpct_getScreenPtr(CPCT_VMEM_START, 48 + digits * 2 + 2, 88);
        DrawNumber(0, pscr);

        digits = DrawComposedNumber(*seconds, 48 + digits * 2 + 4, 88, 0);
    } else {
        DrawComposedNumber(*seconds, 48 + digits * 2 + 2, 88, 0);
    }

    // Player icon.
    if (*currentMap == NUM_MAPS) {
        pscr = cpct_getScreenPtr(CPCT_VMEM_START, 38, SCR_HEIGHT - 80);
        cpct_drawSprite(kPlayerWin01, pscr, TILE_WIDTH, TILE_HEIGHT);
    } else {
        pscr = cpct_getScreenPtr(CPCT_VMEM_START, 38, SCR_HEIGHT - 80);
        cpct_drawSprite(kPlayerDeath02, pscr, TILE_WIDTH, TILE_HEIGHT);
    }

    // Press Space.
    pscr = cpct_getScreenPtr(CPCT_VMEM_START, 29, SCR_HEIGHT - 50);
    cpct_drawSprite(kPressSpaceText, pscr, 22, 8);

    cpct_waitVSYNC();
}

void ScoreLoop() {
    u8 ticks = 0;
	u8 drawPressSpace = 0;
	u8 *pscr;

    while (1) {
        cpct_scanKeyboard_f();

        if (cpct_isKeyPressed(Key_Space)) {
            WaitKeyUp(Key_Space);
            break;
        }

		cpct_waitVSYNC();

        if (ticks == 64) {
            ticks = 0;

            if (drawPressSpace) {
                pscr = cpct_getScreenPtr(CPCT_VMEM_START, 29, SCR_HEIGHT - 50);
                cpct_drawSprite(kPressSpaceText, pscr, 22, 8);

                drawPressSpace = 0;
            } else {
                pscr = cpct_getScreenPtr(CPCT_VMEM_START, 29, SCR_HEIGHT - 50);
                cpct_drawSolidBox(pscr, cpct_px2byteM0(COLOR_BLACK, COLOR_BLACK), 22, 8);

                drawPressSpace = 1;
            }
        }

        ticks++;
    }
}
