//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Hair Boy
//  Copyright (C) 2016 Carlos Sevila (@CarlosSevila)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#include <cpctelera.h>
#include "state/game.h"
#include "state/menu.h"
#include "state/score.h"
#include "audio/audio.h"
#include "globals.h"

const u8 kPalette[16] = {
	0x00, 0x01, 0x02, 0x0B, 0x14, 0x17, 0x0A, 0x12, 0x13, 0x03, 0x06, 0x07, 0x10, 0x0F, 0x18, 0x1A
};

int i = 0;
void InterruptionHandler() {
	if (++i == 6) {
		cpct_akp_musicPlay();
		i = 0;
	}
}

void InitializeCPC() {
	cpct_disableFirmware();

	cpct_fw2hw(kPalette, 16);
	cpct_setPalette(kPalette, 16);
	cpct_setBorder(kPalette[0]);

	cpct_setVideoMode(0);

	musicIsOn = 1;
	cpct_akp_musicInit(kMusic);
	cpct_akp_SFXInit(kSfx);

	cpct_setInterruptHandler(InterruptionHandler);
}

void main(void) {
	InitializeCPC();

	while (1) {
		// Menu
		InitializeMenu();
		MenuLoop();

		// Game
		InitializeGame();
		GameLoop();

		// Score
		InitializeScore(&currentMap, &totalDefeats, &seconds, &minutes);
		ScoreLoop();
	}
}
