//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Hair Boy
//  Copyright (C) 2016 Carlos Sevila (@CarlosSevila)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#include <cpctelera.h>
#include "../globals.h"
#include "../art/sprites.h"
#include "../art/animation.h"

#ifndef _ENTITIES_H_
#define _ENTITIES_H_

typedef enum State {
	GROUNDED,
	JUMPING,
	FALLING
};

typedef struct {
	u8			x;
	u8			y;
	u8			prevX;
	u8			prevY;
	u8			right;
	u8			bottom;
	TAnimation	animation;
} TEntity;

typedef struct {
	enum State	state;
	u8			jumpFactor;
	u8			jumpBlocked;
	u8			leftSpeed;
	u8			rightSpeed;
	u8			lastSpeedIsRight;
	u8			startX;
	u8			startY;
	TEntity		entity;
} TPlayer;

typedef struct {
	i8		xSpeed;
	i8		ySpeed;
	u8		active;
	u8		startX;
	u8		startY;
	TEntity	entity;
} TBlock;

typedef struct {
	u8		x;
	u8		y;
	u8		time;
} TDeformBlock;

void DrawEntity(TEntity *entity);
void EraseEntity(TEntity *entity);
void SetAnimationFrame(TEntity *entity, TAnimFrame **animFrame, u8 loop);
u8 CheckEntitiesCollisionBB(TEntity *entityA, TEntity *entityB);

extern const u8 kJumpValues[JUMP_SIZE];

extern const TAnimFrame kAllAnimFrames[25];

extern TAnimFrame* const kPlayerIdleRight[3];
extern TAnimFrame* const kPlayerIdleLeft[3];
extern TAnimFrame* const kPlayerMoveRight[3];
extern TAnimFrame* const kPlayerMoveLeft[3];
extern TAnimFrame* const kPlayerWin[2];
extern TAnimFrame* const kPlayerJumpRight[3];
extern TAnimFrame* const kPlayerJumpLeft[3];
extern TAnimFrame* const kPlayerFallRight[3];
extern TAnimFrame* const kPlayerFallLeft[3];
extern TAnimFrame* const kPlayerDeath[6];

extern TAnimFrame* const kBlock[4];

#endif
