//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Hair Boy
//  Copyright (C) 2016 Carlos Sevila (@CarlosSevila)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#include "entities.h"

const u8 kJumpValues[JUMP_SIZE] = {6, 6, 5, 5, 4, 4, 3, 3, 3, 2, 2, 2, 2, 2, 1, 1, 1, 1};

const TAnimFrame kAllAnimFrames[25] = {
	{ kPlayerIdleRight01, 8 },
	{ kPlayerIdleRight02, 8 },
	{ kPlayerIdleLeft01, 8 },
	{ kPlayerIdleLeft02, 8 },
	{ kPlayerIdleRight01, 4},
	{ kPlayerIdleRight02, 4},
	{ kPlayerIdleLeft01, 4},
	{ kPlayerIdleLeft02, 4},
	{ kPlayerWin01, 8 },
	{ kPlayerJumpRight01, 7 },
	{ kPlayerJumpRight02, 7 },
	{ kPlayerJumpLeft01, 7 },
	{ kPlayerJumpLeft02, 7 },
	{ kPlayerFallRight01, 7 },
	{ kPlayerFallRight02, 7 },
	{ kPlayerFallLeft01, 7 },
	{ kPlayerFallLeft02, 7 },
	{ kPlayerDeath01, 5 },
	{ kPlayerDeath02, 5 },
	{ kPlayerDeath03, 5 },
	{ kPlayerDeath04, 5 },
	{ kPlayerDeath05, 5 },
	{ kBlock01, 5 },
	{ kBlock02, 5 },
	{ kBlock03, 5 }
};

#define AF kAllAnimFrames

TAnimFrame* const kPlayerIdleRight[3] = { &AF[0], &AF[1], 0 };
TAnimFrame* const kPlayerIdleLeft[3] = { &AF[2], &AF[3], 0 };
TAnimFrame* const kPlayerMoveRight[3] = { &AF[4], &AF[5], 0 };
TAnimFrame* const kPlayerMoveLeft[3] = { &AF[6], &AF[7], 0 };
TAnimFrame* const kPlayerWin[2] = { &AF[8], 0 };
TAnimFrame* const kPlayerJumpRight[3] = { &AF[9], &AF[10], 0 };
TAnimFrame* const kPlayerJumpLeft[3] = { &AF[11], &AF[12], 0 };
TAnimFrame* const kPlayerFallRight[3] = { &AF[13], &AF[14], 0 };
TAnimFrame* const kPlayerFallLeft[3] = { &AF[15], &AF[16], 0 };
TAnimFrame* const kPlayerDeath[6] = { &AF[17], &AF[18], &AF[19], &AF[20], &AF[21], 0 };

TAnimFrame* const kBlock[4] = { &AF[22], &AF[23], &AF[24], 0 };

#undef AF

void DrawEntity(TEntity *entity) {
	u8 *pscr;

	UpdateAnimation(&entity->animation);

	pscr = cpct_getScreenPtr(CPCT_VMEM_START, entity->prevX, entity->prevY);
	cpct_drawSolidBox(pscr, cpct_px2byteM0(COLOR_BLACK, COLOR_BLACK), TILE_WIDTH, TILE_HEIGHT);

	pscr = cpct_getScreenPtr(CPCT_VMEM_START, entity->x, entity->y);
	cpct_drawSprite(entity->animation.frames[entity->animation.frameId]->sprite, pscr, TILE_WIDTH, TILE_HEIGHT);
}

void EraseEntity(TEntity *entity) {
	u8 *pscr;
	pscr = cpct_getScreenPtr(CPCT_VMEM_START, entity->x, entity->y);
	cpct_drawSolidBox(pscr, cpct_px2byteM0(COLOR_BLACK, COLOR_BLACK), TILE_WIDTH, TILE_HEIGHT);
}

void SetAnimationFrame(TEntity *entity, TAnimFrame **animFrame, u8 loop) {
	if (entity->animation.frames != animFrame) {
		entity->animation.frames = animFrame;
		entity->animation.frameId = 0;
		entity->animation.time = 1;
		entity->animation.loop = loop;
	}
}

u8 CheckEntitiesCollisionBB(TEntity *entityA, TEntity *entityB) {
	return !(
		entityA->x > entityB->right
		|| entityB->x > entityA->right
		|| entityA->y > entityB->bottom
		|| entityB->y > entityA->bottom);
}
