//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Hair Boy
//  Copyright (C) 2016 Carlos Sevila (@CarlosSevila)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#include "animation.h"

u8 UpdateAnimation(TAnimation* animation) {
    animation->time--;

    if (animation->time == 0) {
        TAnimFrame* animFrame;

        animation->frameId++;
        animFrame = animation->frames[animation->frameId];

        if (animFrame) {
            animation->time = animFrame->time;
        } else {
            if (animation->loop) {
                animation->frameId = 0;
                animation->time = animation->frames[0]->time;
            }
        }
    }

    return 0;
}
