//======================================================== FX_HEADER
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//======================================================== FX_CONST
CLR1	EQU	6
BLINK_TBL_FIX	EQU	10


;------------------------ text colors
TXT_CLR_0A	EQU	0
TXT_CLR_0B	EQU	1
;---
TXT_CLR_1A	EQU	7
TXT_CLR_1B	EQU	7
;--
TXT_CLR_2A	EQU	6
TXT_CLR_2B	EQU	6
;--
TXT_CLR_3A	EQU	6
TXT_CLR_3B	EQU	0

TXT_CLR_4A	EQU	7
TXT_CLR_4B	EQU	7
;--
TXT_CLR_5A	EQU	0
TXT_CLR_5B	EQU	2
;--
TXT_CLR_6A	EQU	2
TXT_CLR_6B	EQU	2
;--
TXT_CLR_7A	EQU	6
TXT_CLR_7B	EQU	2
;--
TXT_CLR_8A	EQU	6
TXT_CLR_8B	EQU	7
;--
TXT_CLR_0	DW	TXT_CLR_1A + TXT_CLR_5A * 256
TXT_CLR_1	DW	TXT_CLR_2A + TXT_CLR_6A * 256
TXT_CLR_2	DW	TXT_CLR_3A + TXT_CLR_7A * 256
TXT_CLR_3	DW	TXT_CLR_4A + TXT_CLR_8A * 256
TXT_CLR_BG	DB	0
;--
TXT_CLR_A	DW	TXT_CLR_1A + TXT_CLR_5A * 256
		DW	TXT_CLR_2A + TXT_CLR_6A * 256
		DW	TXT_CLR_3A + TXT_CLR_7A * 256
		DW	TXT_CLR_4A + TXT_CLR_8A * 256
		DB	TXT_CLR_0A
;--
TXT_CLR_B	DW	TXT_CLR_1B + TXT_CLR_5B * 256
		DW	TXT_CLR_2B + TXT_CLR_6B * 256
		DW	TXT_CLR_3B + TXT_CLR_7B * 256
		DW	TXT_CLR_4B + TXT_CLR_8B * 256
		DB	TXT_CLR_0B

//======================================================== FX_INIT
EFF_INI_
	LD	A,#17
	CALL	PAGER
	LD	HL,ATTR1
	LD	DE,#5800
	LD	BC,768
	LDIR
	LD	HL,ATTR2
	LD	DE,#D800
	LD	BC,768
	LDIR
	LD	A,#10
	CALL	PAGER	
	RET
//======================================================== FX_MAINLOOP
EFF_RUN_
	EI
	HALT
	;---
	LD	A,#17
SWP_PG	EQU	$-1
	LD	BC,#7FFD
	OUT	(C),A
	;---
	LD	A,47
	CALL	OUT_PIX_DIFF
	DUP	14
	NOP
	EDUP
	DEC HL
	;---
	CALL	OUTFRAME
	;---
	LD	A,(SWP_ATTR)
	XOR	#80
	LD	(SWP_ATTR),A
	LD	A,(SWP_PIX)
	XOR	#80
	LD	(SWP_PIX),A
	LD	A,(SWP_PG)
	XOR	#08
	LD	(SWP_PG),A
	;---
	LD	BC,#7FFD
	OUT	(C),A
	;---
TXT2	LD	A,0
	XOR	#FF
	LD	(TXT2 + 1),A
	JP	Z,TXT0
	LD	HL,TXT_CLR_A
	JR	TXT1
TXT0	LD	HL,TXT_CLR_B
	JR	TXT1
TXT1	LD	DE,TXT_CLR_0
	DUP	8
	LDI
	EDUP
	;---
	CALL	NEXT_FRAME
	LD	A,11
	CALL	OUT_PIX_DIFF
	;---
	NOP:OR 0
	LD	BC,#00FE
	CALL	ACROSS_0
	;---
	LD	A,20 ;78 - 47+8
	CALL	OUT_PIX_DIFF
	;---
	CALL	RGB_BLINK
	;---
	AND	A
	RET	C
	;RET	C
	;RET	C
	;---
	RET
	;---
NF_HALT	EQU	3
NEXT_FRAME
	LD	A,NF_HALT
NF1	EQU	$-1
	DEC	A
	JP	Z,NF2
	OR	0
	LD	C,0
	JP	NF3
NF2	LD	A,NF_HALT
	LD	C,1
	JP	NF3
NF3	LD 	(NF1),A
	LD	A,0
NF4	EQU	$-1
	ADD	A,C
	AND	7
	LD	(NF4),A
	ADD	A,A
	ADD	A,A
	LD	C,A
	LD	B,0
	LD	HL,JP_FZ_TBL
	ADD	HL,BC
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	INC	HL
	LD	(JP_FZ),DE
	LD	E,(HL)
	INC	HL
	LD	D,(HL)
	LD	(PIXDIFF_SP),DE
	RET
JP_FZ_TBL
	DW	FAZEJP1
	DW	PIXDIFF_1
	DW	FAZEJP2
	DW	PIXDIFF_2
	DW	FAZEJP3
	DW	PIXDIFF_3
	DW	FAZEJP4
	DW	PIXDIFF_4
	DW	FAZEJP5
	DW	PIXDIFF_5
	DW	FAZEJP6
	DW	PIXDIFF_6
	DW	FAZEJP7
	DW	PIXDIFF_7
	DW	FAZEJP8
	DW	PIXDIFF_8
;----------------------
RGB_BLINK
	;LD	BC,#FFFD ;10
	;LD	A,9	;7
	;OUT	(C),A	;12
	;IN	A,(C)	;12 /41

	LD	HL,BLINK_TBL + BLINK_TBL_FIX
BLINK_TBL_ADR EQU	$-2
	LD	A,(HL)
	INC	HL
	LD	(BLINK_TBL_ADR),HL

	CP	1
	JP	Z,RBLNK0
	LD	E,0
	JP	RBLNK1
RBLNK0	LD	E,7
	JP	RBLNK1
RBLNK1	LD	A,0
	XOR	1
	LD	(RBLNK1 + 1),A
	LD	C,A
RBLNK2	LD	A,0
	JP	Z,RBLNK3
	LD	D,0
	JP	RBLNK4
RBLNK3	LD	D,1
	JP	RBLNK4
RBLNK4	SUB	D
	ADC	A,0
	OR	E
	LD	(RBLNK2+1),A
	;---
	ADD	A,A
	ADD	A,C
	LD	C,A
	LD	B,0
	LD	HL,BLINK_CLR_TBL
	ADD	HL,BC
	LD	A,(HL)
	;---
	LD	(XCLR0),A
	LD	(XCLR1),A
	LD	(XCLR2),A
	LD	E,A
	ADD	A,A
	ADD	A,A
	ADD	A,A
	OR	E
	LD	(XCLR0+1),A
	AND	7
	LD	(#58F8),A
	LD	(#591A),A
	OR	#44
	LD	(#D8F8),A
	LD	(#D91A),A
	RET
BLINK_CLR_TBL
	DB	0,2
	DB	7,2
	DB	7,2
	DB	7,2
	DB	7,6
	DB	7,6
	DB	7,7
	DB	7,7
//======================================================== FX_PROCEDURES
;	HL` = attr adr
;	D` = ink+paper
;	E` = ink
;	C` = 0
;	B` = 7
OUTFRAME
	LD	(SOHRSP1),SP
	LD	SP,FAZEJP1
JP_FZ	EQU	$-2
	LD	HL,#5800
SWP_ATTR EQU	$-1
	LD	DE,(CLR1*8 + CLR1)*256 + CLR1
XCLR0	EQU	$-2
	LD	BC,7*256
	EXX
	LD	BC,#00FE
	LD	D,CLR1
XCLR1	EQU	$-1
	LD	A,CLR1
XCLR2	EQU	$-1
	AND	A
	RET
FRAME_RET
	XOR	A
	OUT	(#FE),A
	LD	SP,0
SOHRSP1	EQU	$-2
	RET
;----------------------
LN_RET	
	EXX: NOP: OR 0
	JP (IX)
;----------------------
; имеем 48*224 = 9856 тактов для вывода diff pix
;95*A + 70+17+7(94)
;LD	A,78
OUT_PIX_DIFF
	LD	(SOHRSP2),SP	;20
	LD	SP,PIXDIFF_1	;10
PIXDIFF_SP EQU	$-2
	LD	BC,#4000	;10 /30
SWP_PIX	EQU	$-1
	;-----
OPD1	POP	HL	;10
	ADD	HL,BC	;11
	;---
	POP	DE	;10
	LD	(HL),E	;7
	INC	H	;4
	LD	(HL),D	;7
	INC	H	;4
	;---
	POP	DE	;10
	LD	(HL),E	;7
	INC	H	;4
	LD	(HL),D	;7 /81t //11b *78=6318t (~28ln)
	;---
	DEC	A	;4
	JP	NZ,OPD1	;10 /95t *78 = 7410t (~33ln)
	;bytes = 6 * 78 * 8 = 3744b + code 858 = 4602
	;v1 = 6318t (~28ln) / 4602b
	;v2 = 7410t (~33ln) / 3757b
	;-----
	LD	(PIXDIFF_SP),SP	;20
	LD	SP,0		;10
SOHRSP2	EQU	$-2
	RET			;10 /40

;текст по высоте = 28
;v2 - сверху отрезаем 16 линий (2 знакоместа)
;v2+ - сверху отрезаем 10 линий (знакоместо с небольшим)
	
	DISPLAY "V1: ", /A, (#A600 + 3576)
	DISPLAY "V2: ", /A, (#A600 + 3744)
	DISPLAY "V2+: ", /A, (#A600 + 4602)
	

	
//======================================================== FX_INCLUDE_DATA
	INCLUDE "generated/diff_lines_code.asm"
	INCLUDE "generated/diff_scr_code.asm"
	INCLUDE "generated/diff_top.asm"
	INCLUDE "generated/diff_waits.asm"
	INCLUDE "generated/pixdiff.asm"
	INCLUDE	"txt_across.asm"
//======================================================== FX_TABLES




	DISPLAY	"FAZEJP1: ", /A, FAZEJP1
	