//========================================================
// FX HEADER
//========================================================
EFF_INI		JP	EFF_INI_
EFF_RUN		JP	EFF_RUN_
//========================================================
// FX CONST
//========================================================
	IF MACHINE_TYPE=MT_PENTAGON
CNT_UP	EQU	31
CNT_DW	EQU	17
CNT_DW2	EQU	4
	ENDIF
;------- setup for original_zx
	IF MACHINE_TYPE=MT_ZX128 OR MACHINE_TYPE=MT_ZX2A
CNT_UP	EQU	26
CNT_DW	EQU	22
CNT_DW2	EQU	2
	ENDIF




BARTBL1A	EQU	#BE00-16*31-1
BARTBL2A	EQU	BARTBL1A-16*24
BARTBL1B 	EQU	BARTBL2A-16*31-1
BARTBL2B	EQU	BARTBL1B-16*24
UP_RAM		EQU	BARTBL2B

;----------------   
BCLR0	EQU	0
;--
BCLR1A	EQU	2
BCLR1B	EQU	0
;--
BRCLR	EQU	7 ;  	
;----------------  
C0A	EQU	0	;0	; 
C0B	EQU	2
;- mini left
C1A	EQU	7
C1B	EQU	7
;- big left
C2A	EQU	2
C2B	EQU	6
;- big mid
C3A	EQU	0
C3B	EQU	0
;- big center
C4A	EQU	#07
C4B	EQU	#07
;- mini center 
C5A	EQU	#06
C5B	EQU	#42
;- mini mid
C6A	EQU	#07
C6B	EQU	#42
;-
;------
C0Ai	EQU	C0A+7*8
C1Ai	EQU	C1A+7*8
C2Ai	EQU	C2A+7*8
C3Ai	EQU	C3A+7*8
C4Ai	EQU	C4A+7*8
C5Ai	EQU	C5A+7*8
C6Ai	EQU	C6A+7*8
;---
C0Bi	EQU	C0B+7*8
C1Bi	EQU	C1B+7*8
C2Bi	EQU	C2B+7*8
C3Bi	EQU	C3B+7*8
C4Bi	EQU	C4B+7*8
C5Bi	EQU	C5B+7*8
C6Bi	EQU	C6B+7*8
;----------------    ( )
STP1	EQU	6	;4
STP2	EQU	0-2	;-1
STP1x	EQU	11	;8
STP2x	EQU	4	;3

//========================================================
// FX INIT
//========================================================
EFF_INI_
	EI
	HALT
	LD	A,7
	OUT	(#FE),A
	;---
	LD	A,#17
	CALL	PAGER
	;---
	LD	HL,#5800
	LD	DE,#5801
	LD	BC,767
	LD	(HL),7*8+7
	LDIR
	;---
	LD	HL,#4000
	LD	DE,#4001
	LD	BC,6143
	LD	(HL),#FF
	LDIR
	;---
	LD	HL,#4000
	LD	DE,#C000
	LD	BC,6144
	LDIR
	;---
	CALL	INI_PLASMTBL
	CALL	INI_BOARD
	;---
	RET
;------------------------
INI_PLASMTBL ;----- [jp_adr,scr_adr]
	LD	HL,P_TBL
	LD	DE,#5800+32
	LD	BC,32
	LD	LX,48/2
INI0	LD (HL),E:INC L:LD(HL),D:INC L:INC L:INC L
	SET	7,D
	LD (HL),E:INC L:LD(HL),D:INC L:INC L:INC L
	RES	7,D
	EX HL,DE:ADD HL,BC:EX HL,DE
	DEC	LX
	JP	NZ,INI0
	RET
;-------
INI_BOARD
	LD	HL,BARTBL1A
	LD	HY,BCLR1A
	CALL	BAR1_INI
	;--
	LD	HL,BARTBL1B
	LD	HY,BCLR1B
	CALL	BAR1_INI
	;--
	LD	HL,BARTBL2A
	LD	HY,BCLR1A
	CALL	BAR2_INI
	;--
	LD	HL,BARTBL2B
	LD	HY,BCLR1B
BAR2_INI ;---------------------------
	LD	IX,MAPZX+7
	LD	LY,16
INI4x	;--
	PUSH	IX
	LD	C,6
INI3x	;--
	LD	A,(IX)
	DEC	IX
	LD	B,4
INI2x	;--
	RRA
	LD	E,BCLR0
	JP	C,INI1x
	LD	E,HY
INI1x	RRA
	LD	(HL),E
	INC	HL
	DJNZ	INI2x
	DEC	C
	JP	NZ,INI3x
	;--
	POP	IX
	LD	BC,8
	ADD	IX,BC
	DEC	LY
	JP	NZ,INI4x	
	;--
	RET
BAR1_INI ;---------------------------
	LD	IX,MAPZX
	LD	LY,16
INI4	;--
	LD	C,8
INI3	;--
	LD	A,(IX)
	INC	IX
	LD	B,4
INI2	;--
	RLA
	RLA
	LD	E,BCLR0
	JP	C,INI1
	LD	E,HY
INI1	LD	(HL),E
	INC	HL
	DJNZ	INI2
	;--
	DEC	C
	JP	NZ,INI3
	;--
	DEC HL
	DEC	LY
	JP	NZ,INI4
	;--
	RET
;-------------------------
DOWNDE	INC	D
	LD	A,D
	AND	7
	RET	NZ
	LD	A,E
	ADD	A,#20
	LD	E,A
	RET	C
	LD	A,D
	SUB	8
	LD	D,A
	RET


//========================================================
// FX MAINLOOP
//========================================================
EFF_RUN_
	EI
	HALT
	LD A,0: OUT (#FE),A
	;---
	IF MACHINE_TYPE=MT_PENTAGON
	LD	BC,673-599
W0	DEC	BC
	LD	A,B
	OR	C
	JP	NZ,W0
	ENDIF
	;---
	DS	13,0
	;---
	IF MACHINE_TYPE=MT_ZX128 OR MACHINE_TYPE=MT_ZX2A
	LD	A,12
	DEC A:JP NZ,$-1
	NOP:NOP:NOP:NOP:NOP
	ENDIF
	;------------
	CALL	BAR_UP
	CALL	PLASM
	CALL	BAR_DW
	;------------ NEXT STEP
	LD	A,0
CNT	EQU	$-1
	INC	A
	AND	15
	LD	(CNT),A
	ADD	A,A
	ADD	A,A
	LD	L,A
	LD	H,BAR_ADR_A/256
BAR_ADR_SWP	EQU	$-1
	LD	DE,BARu
	LDI:LDI
	LD	DE,BARd
	LDI:LDI
	;---
	LD	A,0
SIN0	EQU	$-1
	ADD	A,STP1
	LD	(SIN0),A
	LD	(SIN0a),A
	LD	A,(SIN1)
	ADD	A,STP2
	LD	(SIN1),A
	;---swap colors
	LD	A,0
SWP_A	EQU	$-1
	XOR	#FF
	LD	(SWP_A),A
	JP	Z,SWP_C1
	;-
	LD	A,JPTBL_A/256
	LD	HL,C4B*256+C3B
	LD	DE,C2B*256+C1B
	LD	BC,C0B*256 + BAR_ADR_B/256
	JP	SWP_C2
SWP_C1	;-
	LD	A,JPTBL_B/256
	LD	HL,C4A*256+C3A
	LD	DE,C2A*256+C1A
	LD	BC,C0A*256 + BAR_ADR_A/256
	JP	SWP_C2
SWP_C2	;-
	LD	(JPTBL_ADR),A
	;-
	LD	(CLR_ADR1),DE
	LD	(CLR_ADR2),HL
	LD	A,B
	LD	(CLR_ADR0),A
	LD	A,C
	LD	(BAR_ADR_SWP),A
	;---
	SCF
	RET	NC
	RET	NC
	RET	NC

	RET
;================================================
;  /  (+ )
;================================================
BAR_UP	LD	HL,P_TBL+CNT_DW*4
	LD	(SPBAR),HL
	LD	DE,BARTBL1A
BARu	EQU	$-2
	LD	LX,CNT_UP
	CALL	BAR00
	;--
	LD	A,BRCLR	;7
	OUT	(#FE),A	;11
	LD	A,14
	DEC A:JP NZ,$-1	;14*14
	OUT	(#FE),A	;12
	LD DE,0:LD DE,0
	;LD	(BARu),DE ;20
	RET
	;-----------------
BAR_DW	LD	A,4
	DEC A:JP NZ,$-1
	LD	HL,P_TBL
	LD	(SPBAR),HL
	LD	DE,BARTBL2A
BARd	EQU	$-2
	LD	IX,CNT_DW2*256+CNT_DW
	;---
	DS	8,0
	LD	A,BRCLR	;7
	OUT	(#FE),A	;11
	LD	A,14-2
	DEC A:JP NZ,$-1	;14*14
	;--
	
	CALL	BAR00
	;--
BAR2	LD	A,(DE)	;7
	OUT	(#FE),A	;11
	INC	DE	;6
	LD	A,12+16	;7
	LD	A,12+16	;7
	DEC A:JP NZ,$-1
	DEC	HX	;8
	JP	NZ,BAR2	;10
	;--
	XOR	A
	OUT	(#FE),A

	LD DE,0:LD DE,0
;LD	(BARd),DE ;20
	RET		;10
;---------------------------
BAR00	LD	(SOHRSP0),SP
BAR0	;--
	LD	A,(DE)	;7
	INC	DE	;6
	OUT	(#FE),A	;11 /24
	;--
	LD	SP,0	;10
SPBAR	EQU	$-2
	POP	HL	;10
	RET		;10 /30
BAR1	;--22free
	IF MACHINE_TYPE=MT_ZX128 OR MACHINE_TYPE=MT_ZX2A
		NOP:NOP
	ENDIF
	NOP		;4pause
	DEC	LX	;8
	JP	NZ,BAR0	;10 /18
	LD	SP,0
SOHRSP0	EQU	$-2
	RET

;------  :
P0A	LD (SPBAR),SP:LD SP,HL:LD BC,C1Ai*256+C1Ai:PUSH BC:LD BC,C1Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C1Ai:PUSH BC:LD BC,C1Ai*256+C1Ai:PUSH BC:JP BAR1
P1A	LD (SPBAR),SP:LD SP,HL:LD BC,C1Ai*256+C1Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C1Ai*256+C1Ai:PUSH BC:JP BAR1
P2A	LD (SPBAR),SP:LD SP,HL:LD BC,C1Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C1Ai:PUSH BC:JP BAR1
P3A	LD (SPBAR),SP:LD SP,HL:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:JP BAR1
P4A	LD (SPBAR),SP:LD SP,HL:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:JP BAR1
P5A	LD (SPBAR),SP:LD SP,HL:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:JP BAR1
P6A	LD (SPBAR),SP:LD SP,HL:LD BC,C0Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C0Ai:PUSH BC:JP BAR1
P7A	LD (SPBAR),SP:LD SP,HL:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:JP BAR1
P8A	LD (SPBAR),SP:LD SP,HL:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C2Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:JP BAR1
P9A	LD (SPBAR),SP:LD SP,HL:LD BC,C2Ai*256+C2Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C2Ai*256+C2Ai:PUSH BC:JP BAR1
P10A	LD (SPBAR),SP:LD SP,HL:LD BC,C2Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C2Ai:PUSH BC:JP BAR1
P11A	LD (SPBAR),SP:LD SP,HL:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:JP BAR1
P12A	LD (SPBAR),SP:LD SP,HL:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:JP BAR1
P13A	LD (SPBAR),SP:LD SP,HL:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:JP BAR1
P14A	LD (SPBAR),SP:LD SP,HL:LD BC,C0Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C0Ai:PUSH BC:JP BAR1
P15A	LD (SPBAR),SP:LD SP,HL:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:JP BAR1
P16A	LD (SPBAR),SP:LD SP,HL:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:JP BAR1
P17A	LD (SPBAR),SP:LD SP,HL:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:JP BAR1
P18A	LD (SPBAR),SP:LD SP,HL:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C5Ai:PUSH BC:LD BC,C5Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C3Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:JP BAR1
P19A	LD (SPBAR),SP:LD SP,HL:LD BC,C3Ai*256+C3Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C5Ai*256+C5Ai:PUSH BC:LD BC,C5Ai*256+C5Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C3Ai*256+C3Ai:PUSH BC:JP BAR1
P20A	LD (SPBAR),SP:LD SP,HL:LD BC,C3Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C5Ai:PUSH BC:LD BC,C5Ai*256+C5Ai:PUSH BC:LD BC,C5Ai*256+C5Ai:PUSH BC:LD BC,C5Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C3Ai:PUSH BC:JP BAR1
P21A	LD (SPBAR),SP:LD SP,HL:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C5Ai*256+C5Ai:PUSH BC:LD BC,C5Ai*256+C5Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:JP BAR1
P22A	LD (SPBAR),SP:LD SP,HL:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C5Ai:PUSH BC:LD BC,C5Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:JP BAR1
P23A	LD (SPBAR),SP:LD SP,HL:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:JP BAR1
P24A	LD (SPBAR),SP:LD SP,HL:LD BC,C0Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C0Ai:PUSH BC:JP BAR1
P25A	LD (SPBAR),SP:LD SP,HL:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:JP BAR1
P26A	LD (SPBAR),SP:LD SP,HL:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:JP BAR1
P27A	LD (SPBAR),SP:LD SP,HL:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:JP BAR1
P28A	LD (SPBAR),SP:LD SP,HL:LD BC,C4Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C6Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C6Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C6Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C6Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C4Ai:PUSH BC:JP BAR1
P29A	LD (SPBAR),SP:LD SP,HL:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C4Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:JP BAR1
P30A	LD (SPBAR),SP:LD SP,HL:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C6Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C6Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C6Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C6Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:JP BAR1
P31A	LD (SPBAR),SP:LD SP,HL:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C4Ai:PUSH BC:LD BC,C4Ai*256+C0Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C6Ai*256+C6Ai:PUSH BC:LD BC,C0Ai*256+C0Ai:PUSH BC:JP BAR1
;-----------------------------------------
P0B	LD (SPBAR),SP:LD SP,HL:LD BC,C1Bi*256+C1Bi:PUSH BC:LD BC,C1Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C1Bi:PUSH BC:LD BC,C1Bi*256+C1Bi:PUSH BC:JP BAR1
P1B	LD (SPBAR),SP:LD SP,HL:LD BC,C1Bi*256+C1Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C1Bi*256+C1Bi:PUSH BC:JP BAR1
P2B	LD (SPBAR),SP:LD SP,HL:LD BC,C1Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C1Bi:PUSH BC:JP BAR1
P3B	LD (SPBAR),SP:LD SP,HL:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:JP BAR1
P4B	LD (SPBAR),SP:LD SP,HL:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:JP BAR1
P5B	LD (SPBAR),SP:LD SP,HL:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:JP BAR1
P6B	LD (SPBAR),SP:LD SP,HL:LD BC,C0Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C0Bi:PUSH BC:JP BAR1
P7B	LD (SPBAR),SP:LD SP,HL:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:JP BAR1
P8B	LD (SPBAR),SP:LD SP,HL:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C2Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:JP BAR1
P9B	LD (SPBAR),SP:LD SP,HL:LD BC,C2Bi*256+C2Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C2Bi*256+C2Bi:PUSH BC:JP BAR1
P10B	LD (SPBAR),SP:LD SP,HL:LD BC,C2Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C2Bi:PUSH BC:JP BAR1
P11B	LD (SPBAR),SP:LD SP,HL:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:JP BAR1
P12B	LD (SPBAR),SP:LD SP,HL:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:JP BAR1
P13B	LD (SPBAR),SP:LD SP,HL:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:JP BAR1
P14B	LD (SPBAR),SP:LD SP,HL:LD BC,C0Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C0Bi:PUSH BC:JP BAR1
P15B	LD (SPBAR),SP:LD SP,HL:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:JP BAR1
P16B	LD (SPBAR),SP:LD SP,HL:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:JP BAR1
P17B	LD (SPBAR),SP:LD SP,HL:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:JP BAR1
P18B	LD (SPBAR),SP:LD SP,HL:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C5Bi:PUSH BC:LD BC,C5Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C3Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:JP BAR1
P19B	LD (SPBAR),SP:LD SP,HL:LD BC,C3Bi*256+C3Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C5Bi*256+C5Bi:PUSH BC:LD BC,C5Bi*256+C5Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C3Bi*256+C3Bi:PUSH BC:JP BAR1
P20B	LD (SPBAR),SP:LD SP,HL:LD BC,C3Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C5Bi:PUSH BC:LD BC,C5Bi*256+C5Bi:PUSH BC:LD BC,C5Bi*256+C5Bi:PUSH BC:LD BC,C5Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C3Bi:PUSH BC:JP BAR1
P21B	LD (SPBAR),SP:LD SP,HL:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C5Bi*256+C5Bi:PUSH BC:LD BC,C5Bi*256+C5Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:JP BAR1
P22B	LD (SPBAR),SP:LD SP,HL:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C5Bi:PUSH BC:LD BC,C5Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:JP BAR1
P23B	LD (SPBAR),SP:LD SP,HL:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:JP BAR1
P24B	LD (SPBAR),SP:LD SP,HL:LD BC,C0Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C0Bi:PUSH BC:JP BAR1
P25B	LD (SPBAR),SP:LD SP,HL:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:JP BAR1
P26B	LD (SPBAR),SP:LD SP,HL:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:JP BAR1
P27B	LD (SPBAR),SP:LD SP,HL:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:JP BAR1
P28B	LD (SPBAR),SP:LD SP,HL:LD BC,C4Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C6Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C6Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C6Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C6Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C4Bi:PUSH BC:JP BAR1
P29B	LD (SPBAR),SP:LD SP,HL:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C4Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:JP BAR1
P30B	LD (SPBAR),SP:LD SP,HL:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C6Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C6Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C6Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C6Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:JP BAR1
P31B	LD (SPBAR),SP:LD SP,HL:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C4Bi:PUSH BC:LD BC,C4Bi*256+C0Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C6Bi*256+C6Bi:PUSH BC:LD BC,C0Bi*256+C0Bi:PUSH BC:JP BAR1
;================================================
;     (+)
;================================================
	MACRO PAUSE_24
	NOP:NOP:NOP:NOP:NOP:NOP
	IF MACHINE_TYPE=MT_ZX128 OR MACHINE_TYPE=MT_ZX2A
		NOP
	ENDIF
	ENDM
	;---
	MACRO NEXT_LINE
	IF MACHINE_TYPE=MT_ZX128 OR MACHINE_TYPE=MT_ZX2A
		NOP
	ENDIF
	EXX:OUT(C),A:JP (HL)
	ENDM
	;---
CALC_1	;---17t (95free)
	EXX			;4
	LD	HL,SINTBL 	;10
SIN0a	EQU	$-2
	LD	A,L		;4
	ADD	A,STP1x		;7
	LD	L,A		;4
	LD	(SIN0a),HL	;16 /45
	;--
	LD	A,E		;4
	ADD	A,STP2x		;7
	LD	E,A		;4
	LD	A,(DE)		;7
	ADD	A,(HL)		;7
	ADD	A,16		;7 /36
	;--
	EXX			;4
	RET			;10 /14
CALC_2	;---17t (95free)
	EXX			;4
	ADD	A,A		;4
	ADD	A,A		;4
	LD	L,A		;4
	LD	H,JPTBL_A/256	;7 /23
JPTBL_ADR EQU	$-1
	LD A,0	;7
	;--
	LD	A,(HL)		;7
	INC	L		;4
	LD	(IX),A		;19
	INC	IX		;10
	LD	A,(HL)		;7
	INC	L		;4 /51
	;--
	EXX			;4
	RET			;10 /14
CALC_3	;---17t (95free)
	EXX			;4
	LD	(IX),A		;19
	INC IX:INC LX:INC IX	;28 /51
	;--
;	RET PE	;5
	NOP:NOP
	;--
	LD	A,(HL)		;7
	INC	L		;4
	LD	H,(HL)		;7
	LD	L,A		;7 /25
	;--
	EXX			;4
	RET			;10 /14
CALC_4	;---17t (95free)
	EXX			;4
	POP	IY		;14 /18
	;--
	PUSH	HL		;11
	POP	HL		;10
	POP	HL		;10 /31
	;--
	LD	A,0	;7
	LD	A,#17		;7
CPAGE	EQU	$-1
	XOR	#08		;7
	LD	(CPAGE),A	;13 /27
	;--
	EXX			;4
	JP	(IY)		;8 /12
;--------------------------------------
PLASMRET
	XOR	A
	OUT	(#FE),A
	LD	SP,0
SOHRSP1	EQU	$-2
	RET
;--------
PLASM	LD	(SOHRSP1),SP
	LD	IX,P_TBL+2
	LD	SP,PB_TBL
	LD	DE,SINTBL
SIN1	EQU	$-2
	LD	BC,#7FFD
	EXX
	LD	DE,C2A*256+C1A
CLR_ADR1 EQU	$-2
	LD	HL,C4A*256+C3A
CLR_ADR2 EQU	$-2
	LD	BC,#FE+C0A*256
CLR_ADR0 EQU	$-1
	EXX
	DUP 12:NOP:EDUP
	LD A,R
	RET
PLASM0	;------------------- ln0
	EXX
	NOP:OUT (C),B:OUT (C),E:NOP:NOP:NOP:NOP
	CALL CALC_1
	NOP:NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP
	PAUSE_24
	;--
	NOP:OUT (C),B:OUT (C),E:NOP:NOP:NOP:NOP
	CALL CALC_2
	NOP:NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP
	PAUSE_24
	;--
	NOP:OUT (C),B:OUT (C),E:NOP:NOP:NOP:NOP
	CALL CALC_3
	NOP:NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP
	PAUSE_24
	;--
	NOP:OUT (C),B:OUT (C),E:NOP:NOP:NOP:NOP
	CALL CALC_4
	NOP:NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP
	NEXT_LINE
PLASM1	;------------------- ln0
	EXX
	NOP:OUT (C),B:NOP:OUT (C),E:NOP:NOP:NOP
	CALL CALC_1
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP
	PAUSE_24
	;--
	NOP:OUT (C),B:NOP:OUT (C),E:NOP:NOP:NOP
	CALL CALC_2
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP
	PAUSE_24
	;--
	NOP:OUT (C),B:NOP:OUT (C),E:NOP:NOP:NOP
	CALL CALC_3
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP
	PAUSE_24
	;--
	NOP:OUT (C),B:NOP:OUT (C),E:NOP:NOP:NOP
	CALL CALC_4
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP
	NEXT_LINE
PLASM2	;------------------- ln0
	EXX
	NOP:OUT (C),B:NOP:NOP:OUT (C),E:NOP:NOP
	CALL	CALC_1
	NOP:NOP:NOP:NOP:NOP:OUT	(C),B:NOP:NOP:NOP
	PAUSE_24
	;--
	NOP:OUT (C),B:NOP:NOP:OUT (C),E:NOP:NOP
	CALL	CALC_2
	NOP:NOP:NOP:NOP:NOP:OUT	(C),B:NOP:NOP:NOP
	PAUSE_24
	;--
	NOP:OUT (C),B:NOP:NOP:OUT (C),E:NOP:NOP
	CALL	CALC_3
	NOP:NOP:NOP:NOP:NOP:OUT	(C),B:NOP:NOP:NOP
	PAUSE_24
	;--
	NOP:OUT (C),B:NOP:NOP:OUT (C),E:NOP:NOP
	CALL	CALC_4
	NOP:NOP:NOP:NOP:NOP:OUT	(C),B:NOP:NOP:NOP
	NEXT_LINE
PLASM3	;------------------- ln0
	EXX
	OUT (C),D:OUT (C),B:NOP:OUT (C),E:NOP		
	CALL	CALC_1
	NOP:OUT (C),E:OUT (C),B:NOP:OUT (C),D
	PAUSE_24
	;--
	OUT (C),D:OUT (C),B:NOP:OUT (C),E:NOP		
	CALL	CALC_2
	NOP:OUT (C),E:OUT (C),B:NOP:OUT (C),D
	PAUSE_24
	;--
	OUT (C),D:OUT (C),B:NOP:OUT (C),E:NOP		
	CALL	CALC_3
	NOP:OUT (C),E:OUT (C),B:NOP:OUT (C),D
	PAUSE_24
	;--
	OUT (C),D:OUT (C),B:NOP:OUT (C),E:NOP		
	CALL	CALC_4
	NOP:OUT (C),E:OUT (C),B:NOP:OUT (C),D
	NEXT_LINE
PLASM4	;------------------- ln0
	EXX
	OUT (C),D:NOP:OUT (C),B:NOP:NOP:NOP:NOP		
	CALL	CALC_1
	NOP:NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),D:NOP
	PAUSE_24
	;--
	OUT (C),D:NOP:OUT (C),B:NOP:NOP:NOP:NOP		
	CALL	CALC_2
	NOP:NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),D:NOP
	PAUSE_24
	;--
	OUT (C),D:NOP:OUT (C),B:NOP:NOP:NOP:NOP		
	CALL	CALC_3
	NOP:NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),D:NOP
	PAUSE_24
	;--
	OUT (C),D:NOP:OUT (C),B:NOP:NOP:NOP:NOP		
	CALL	CALC_4
	NOP:NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),D:NOP
	NEXT_LINE
PLASM5	;------------------- ln0
PLASM15	;--
	EXX
	OUT (C),D:NOP:NOP:OUT (C),B:NOP:NOP:NOP		
	CALL	CALC_1
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),D:NOP:NOP
	PAUSE_24
	;--
	OUT (C),D:NOP:NOP:OUT (C),B:NOP:NOP:NOP		
	CALL	CALC_2
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),D:NOP:NOP
	PAUSE_24
	;--
	OUT (C),D:NOP:NOP:OUT (C),B:NOP:NOP:NOP		
	CALL	CALC_3
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),D:NOP:NOP
	PAUSE_24
	;--
	OUT (C),D:NOP:NOP:OUT (C),B:NOP:NOP:NOP		
	CALL	CALC_4
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),D:NOP:NOP
	NEXT_LINE
PLASM6	;------------------- ln0
PLASM14	;--
	EXX
	OUT (C),D:NOP:NOP:NOP:OUT (C),B:NOP:NOP		
	CALL	CALC_1
	NOP:NOP:NOP:NOP:NOP:OUT (C),D:NOP:NOP:NOP
	PAUSE_24
	;--
	OUT (C),D:NOP:NOP:NOP:OUT (C),B:NOP:NOP		
	CALL	CALC_2
	NOP:NOP:NOP:NOP:NOP:OUT (C),D:NOP:NOP:NOP
	PAUSE_24
	;--
	OUT (C),D:NOP:NOP:NOP:OUT (C),B:NOP:NOP		
	CALL	CALC_3
	NOP:NOP:NOP:NOP:NOP:OUT (C),D:NOP:NOP:NOP
	PAUSE_24
	;--
	OUT (C),D:NOP:NOP:NOP:OUT (C),B:NOP:NOP		
	CALL	CALC_4
	NOP:NOP:NOP:NOP:NOP:OUT (C),D:NOP:NOP:NOP
	NEXT_LINE
PLASM7	;------------------- ln0
PLASM13	;--
	EXX
	OUT (C),B:OUT (C),D:NOP:OUT (C),B:NOP
	CALL	CALC_1
	NOP:NOP:NOP:NOP:OUT (C),D:NOP:OUT (C),B
	PAUSE_24
	;--
	OUT (C),B:OUT (C),D:NOP:OUT (C),B:NOP
	CALL	CALC_2
	NOP:NOP:NOP:NOP:OUT (C),D:NOP:OUT (C),B
	PAUSE_24
	;--
	OUT (C),B:OUT (C),D:NOP:OUT (C),B:NOP
	CALL	CALC_3
	NOP:NOP:NOP:NOP:OUT (C),D:NOP:OUT (C),B
	PAUSE_24
	;--
	OUT (C),B:OUT (C),D:NOP:OUT (C),B:NOP
	CALL	CALC_4
	NOP:NOP:NOP:NOP:OUT (C),D:NOP:OUT (C),B
	NEXT_LINE
PLASM8	;------------------- ln0
	EXX
	NOP:OUT (C),B:OUT (C),D:NOP:NOP:NOP:NOP
	CALL	CALC_1
	NOP:NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP
	PAUSE_24
	;--
	NOP:OUT (C),B:OUT (C),D:NOP:NOP:NOP:NOP
	CALL	CALC_2
	NOP:NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP
	PAUSE_24
	;--
	NOP:OUT (C),B:OUT (C),D:NOP:NOP:NOP:NOP
	CALL	CALC_3
	NOP:NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP
	PAUSE_24
	;--
	NOP:OUT (C),B:OUT (C),D:NOP:NOP:NOP:NOP
	CALL	CALC_4
	NOP:NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP
	NEXT_LINE
PLASM9	;------------------- ln0
PLASM10 ;--
PLASM11 ;--
	EXX
	NOP:OUT (C),B:NOP:OUT (C),D:NOP:NOP:NOP
	CALL	CALC_1
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP
	PAUSE_24
	;--
	NOP:OUT (C),B:NOP:OUT (C),D:NOP:NOP:NOP
	CALL	CALC_2
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP
	PAUSE_24
	;--
	NOP:OUT (C),B:NOP:OUT (C),D:NOP:NOP:NOP
	CALL	CALC_3
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP
	PAUSE_24
	;--
	NOP:OUT (C),B:NOP:OUT (C),D:NOP:NOP:NOP
	CALL	CALC_4
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP
	NEXT_LINE
PLASM12	;------------------- ln0
	EXX
	NOP:OUT (C),B:OUT (C),D:NOP:OUT	(C),B
	CALL	CALC_1
	NOP:NOP:NOP:OUT (C),D:NOP:OUT (C),B:NOP
	PAUSE_24
	;--
	NOP:OUT (C),B:OUT (C),D:NOP:OUT	(C),B
	CALL	CALC_2
	NOP:NOP:NOP:OUT (C),D:NOP:OUT (C),B:NOP
	PAUSE_24
	;--
	NOP:OUT (C),B:OUT (C),D:NOP:OUT	(C),B
	CALL	CALC_3
	NOP:NOP:NOP:OUT (C),D:NOP:OUT (C),B:NOP
	PAUSE_24
	;--
	NOP:OUT (C),B:OUT (C),D:NOP:OUT	(C),B
	CALL	CALC_4
	NOP:NOP:NOP:OUT (C),D:NOP:OUT (C),B:NOP
	NEXT_LINE
PLASM16	;------------------- ln0
	EXX
	NOP:OUT (C),D:OUT (C),B:NOP:OUT	(C),L
	CALL	CALC_1
	NOP:NOP:NOP:OUT (C),B:NOP:OUT (C),D:NOP
	PAUSE_24
	;--
	NOP:OUT (C),D:OUT (C),B:NOP:OUT	(C),L
	CALL	CALC_2
	NOP:NOP:NOP:OUT (C),B:NOP:OUT (C),D:NOP
	PAUSE_24
	;--
	NOP:OUT (C),D:OUT (C),B:NOP:OUT	(C),L
	CALL	CALC_3
	NOP:NOP:NOP:OUT (C),B:NOP:OUT (C),D:NOP
	PAUSE_24
	;--
	NOP:OUT (C),D:OUT (C),B:NOP:OUT	(C),L
	CALL	CALC_4
	NOP:NOP:NOP:OUT (C),B:NOP:OUT (C),D:NOP
	NEXT_LINE
PLASM17	;------------------- ln0
	EXX
	OUT (C),D:OUT (C),B:NOP:OUT (C),L:NOP
	CALL	CALC_1
	NOP:NOP:NOP:NOP:OUT (C),B:NOP:OUT (C),D
	PAUSE_24
	;--
	OUT (C),D:OUT (C),B:NOP:OUT (C),L:NOP
	CALL	CALC_2
	NOP:NOP:NOP:NOP:OUT (C),B:NOP:OUT (C),D
	PAUSE_24
	;--
	OUT (C),D:OUT (C),B:NOP:OUT (C),L:NOP
	CALL	CALC_3
	NOP:NOP:NOP:NOP:OUT (C),B:NOP:OUT (C),D
	PAUSE_24
	;--
	OUT (C),D:OUT (C),B:NOP:OUT (C),L:NOP
	CALL	CALC_4
	NOP:NOP:NOP:NOP:OUT (C),B:NOP:OUT (C),D
	NEXT_LINE
PLASM18	;------------------- ln0
	EXX
	OUT (C),B:NOP:NOP:NOP:OUT (C),L:NOP:NOP
	CALL	CALC_1
	NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP:NOP
	PAUSE_24
	;--
	OUT (C),B:NOP:NOP:NOP:OUT (C),L:NOP:NOP
	CALL	CALC_2
	NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP:NOP
	PAUSE_24
	;--
	OUT (C),B:NOP:NOP:NOP:OUT (C),L:NOP:NOP
	CALL	CALC_3
	NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP:NOP
	PAUSE_24
	;--
	OUT (C),B:NOP:NOP:NOP:OUT (C),L:NOP:NOP
	CALL	CALC_4
	NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP:NOP
	NEXT_LINE
PLASM19	;------------------- ln0
	EXX
	OUT (C),B:NOP:NOP:OUT (C),L:NOP:NOP:NOP
	CALL	CALC_1
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP
	PAUSE_24
	;--
	OUT (C),B:NOP:NOP:OUT (C),L:NOP:NOP:NOP
	CALL	CALC_2
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP
	PAUSE_24
	;--
	OUT (C),B:NOP:NOP:OUT (C),L:NOP:NOP:NOP
	CALL	CALC_3
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP
	PAUSE_24
	;--
	OUT (C),B:NOP:NOP:OUT (C),L:NOP:NOP:NOP
	CALL	CALC_4
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP
	NEXT_LINE
PLASM20	;------------------- ln0
	EXX
	OUT (C),B:NOP:OUT (C),L:NOP:NOP:NOP:NOP
	CALL	CALC_1
	NOP:NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP
	PAUSE_24
	;--
	OUT (C),B:NOP:OUT (C),L:NOP:NOP:NOP:NOP
	CALL	CALC_2
	NOP:NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP
	PAUSE_24
	;--
	OUT (C),B:NOP:OUT (C),L:NOP:NOP:NOP:NOP
	CALL	CALC_3
	NOP:NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP
	PAUSE_24
	;--
	OUT (C),B:NOP:OUT (C),L:NOP:NOP:NOP:NOP
	CALL	CALC_4
	NOP:NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP
	NEXT_LINE
PLASM21	;------------------- ln0
	EXX
	OUT (C),B:OUT (C),L:NOP:NOP:NOP:NOP:NOP
	CALL	CALC_1
	NOP:NOP:NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B
	PAUSE_24
	;--
	OUT (C),B:OUT (C),L:NOP:NOP:NOP:NOP:NOP
	CALL	CALC_2
	NOP:NOP:NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B
	PAUSE_24
	;--
	OUT (C),B:OUT (C),L:NOP:NOP:NOP:NOP:NOP
	CALL	CALC_3
	NOP:NOP:NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B
	PAUSE_24
	;--
	OUT (C),B:OUT (C),L:NOP:NOP:NOP:NOP:NOP
	CALL	CALC_4
	NOP:NOP:NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B
	NEXT_LINE
PLASM22	;------------------- ln0
	EXX
	OUT (C),L:NOP:NOP:NOP:NOP:NOP:OUT (C),B
	CALL	CALC_1
	NOP:NOP:NOP:OUT (C),L:NOP:NOP:NOP:NOP:NOP
	PAUSE_24
	;--
	OUT (C),L:NOP:NOP:NOP:NOP:NOP:OUT (C),B
	CALL	CALC_2
	NOP:NOP:NOP:OUT (C),L:NOP:NOP:NOP:NOP:NOP
	PAUSE_24
	;--
	OUT (C),L:NOP:NOP:NOP:NOP:NOP:OUT (C),B
	CALL	CALC_3
	NOP:NOP:NOP:OUT (C),L:NOP:NOP:NOP:NOP:NOP
	PAUSE_24
	;--
	OUT (C),L:NOP:NOP:NOP:NOP:NOP:OUT (C),B
	CALL	CALC_4
	NOP:NOP:NOP:OUT (C),L:NOP:NOP:NOP:NOP:NOP
	NEXT_LINE
PLASM23	;------------------- ln0
	EXX
	OUT (C),L:NOP:NOP:NOP:NOP:OUT (C),B:NOP
	CALL	CALC_1
	NOP:NOP:NOP:NOP:OUT (C),L:NOP:NOP:NOP:NOP
	PAUSE_24
	;--
	OUT (C),L:NOP:NOP:NOP:NOP:OUT (C),B:NOP
	CALL	CALC_2
	NOP:NOP:NOP:NOP:OUT (C),L:NOP:NOP:NOP:NOP
	PAUSE_24
	;--
	OUT (C),L:NOP:NOP:NOP:NOP:OUT (C),B:NOP
	CALL	CALC_3
	NOP:NOP:NOP:NOP:OUT (C),L:NOP:NOP:NOP:NOP
	PAUSE_24
	;--
	OUT (C),L:NOP:NOP:NOP:NOP:OUT (C),B:NOP
	CALL	CALC_4
	NOP:NOP:NOP:NOP:OUT (C),L:NOP:NOP:NOP:NOP
	NEXT_LINE
PLASM24	;------------------- ln0
	EXX
	OUT (C),L:NOP:NOP:NOP:OUT (C),B:NOP:NOP
	CALL	CALC_1
	NOP:NOP:NOP:NOP:NOP:OUT (C),L:NOP:NOP:NOP
	PAUSE_24
	;--
	OUT (C),L:NOP:NOP:NOP:OUT (C),B:NOP:NOP
	CALL	CALC_2
	NOP:NOP:NOP:NOP:NOP:OUT (C),L:NOP:NOP:NOP
	PAUSE_24
	;--
	OUT (C),L:NOP:NOP:NOP:OUT (C),B:NOP:NOP
	CALL	CALC_3
	NOP:NOP:NOP:NOP:NOP:OUT (C),L:NOP:NOP:NOP
	PAUSE_24
	;--
	OUT (C),L:NOP:NOP:NOP:OUT (C),B:NOP:NOP
	CALL	CALC_4
	NOP:NOP:NOP:NOP:NOP:OUT (C),L:NOP:NOP:NOP
	NEXT_LINE
PLASM25	;------------------- ln0
	EXX
	OUT (C),L:NOP:NOP:OUT (C),B:NOP:NOP:NOP
	CALL	CALC_1
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),L:NOP:NOP
	PAUSE_24
	;--
	OUT (C),L:NOP:NOP:OUT (C),B:NOP:NOP:NOP
	CALL	CALC_2
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),L:NOP:NOP
	PAUSE_24
	;--
	OUT (C),L:NOP:NOP:OUT (C),B:NOP:NOP:NOP
	CALL	CALC_3
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),L:NOP:NOP
	PAUSE_24
	;--
	OUT (C),L:NOP:NOP:OUT (C),B:NOP:NOP:NOP
	CALL	CALC_4
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),L:NOP:NOP
	NEXT_LINE
PLASM26	;------------------- ln0
	EXX
	OUT (C),L:NOP:OUT (C),B:NOP:OUT (C),H
	CALL	CALC_1
	NOP:NOP:NOP:OUT (C),B:NOP:OUT (C),L:NOP
	PAUSE_24
	;--
	OUT (C),L:NOP:OUT (C),B:NOP:OUT (C),H
	CALL	CALC_2
	NOP:NOP:NOP:OUT (C),B:NOP:OUT (C),L:NOP
	PAUSE_24
	;--
	OUT (C),L:NOP:OUT (C),B:NOP:OUT (C),H
	CALL	CALC_3
	NOP:NOP:NOP:OUT (C),B:NOP:OUT (C),L:NOP
	PAUSE_24
	;--
	OUT (C),L:NOP:OUT (C),B:NOP:OUT (C),H
	CALL	CALC_4
	NOP:NOP:NOP:OUT (C),B:NOP:OUT (C),L:NOP
	NEXT_LINE
PLASM27	;------------------- ln0
	EXX
	OUT (C),L:OUT (C),B:NOP:OUT (C),H:NOP
	CALL	CALC_1
	NOP:NOP:NOP:NOP:OUT (C),B:NOP:OUT (C),L
	PAUSE_24
	;--
	OUT (C),L:OUT (C),B:NOP:OUT (C),H:NOP
	CALL	CALC_2
	NOP:NOP:NOP:NOP:OUT (C),B:NOP:OUT (C),L
	PAUSE_24
	;--
	OUT (C),L:OUT (C),B:NOP:OUT (C),H:NOP
	CALL	CALC_3
	NOP:NOP:NOP:NOP:OUT (C),B:NOP:OUT (C),L
	PAUSE_24
	;--
	OUT (C),L:OUT (C),B:NOP:OUT (C),H:NOP
	CALL	CALC_4
	NOP:NOP:NOP:NOP:OUT (C),B:NOP:OUT (C),L
	NEXT_LINE
PLASM28	;------------------- ln0
	EXX
	OUT (C),B:NOP:NOP:NOP:OUT (C),H:NOP:NOP
	CALL	CALC_1
	NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP:NOP
	PAUSE_24
	;--
	OUT (C),B:NOP:NOP:NOP:OUT (C),H:NOP:NOP
	CALL	CALC_2
	NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP:NOP
	PAUSE_24
	;--
	OUT (C),B:NOP:NOP:NOP:OUT (C),H:NOP:NOP
	CALL	CALC_3
	NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP:NOP
	PAUSE_24
	;--
	OUT (C),B:NOP:NOP:NOP:OUT (C),H:NOP:NOP
	CALL	CALC_4
	NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP:NOP
	NEXT_LINE
PLASM29	;------------------- ln0
	EXX
	OUT (C),B:NOP:NOP:OUT (C),H:NOP:NOP:NOP
	CALL	CALC_1
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP
	PAUSE_24
	;--
	OUT (C),B:NOP:NOP:OUT (C),H:NOP:NOP:NOP
	CALL	CALC_2
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP
	PAUSE_24
	;--
	OUT (C),B:NOP:NOP:OUT (C),H:NOP:NOP:NOP
	CALL	CALC_3
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP
	PAUSE_24
	;--
	OUT (C),B:NOP:NOP:OUT (C),H:NOP:NOP:NOP
	CALL	CALC_4
	NOP:NOP:NOP:NOP:NOP:NOP:OUT (C),B:NOP:NOP
	NEXT_LINE
PLASM30	;------------------- ln0
	EXX
	OUT (C),B:NOP:OUT (C),H:NOP:OUT	(C),B
	CALL	CALC_1
	NOP:NOP:NOP:OUT (C),H:NOP:OUT (C),B:NOP
	PAUSE_24
	;--
	OUT (C),B:NOP:OUT (C),H:NOP:OUT	(C),B
	CALL	CALC_2
	NOP:NOP:NOP:OUT (C),H:NOP:OUT (C),B:NOP
	PAUSE_24
	;--
	OUT (C),B:NOP:OUT (C),H:NOP:OUT	(C),B
	CALL	CALC_3
	NOP:NOP:NOP:OUT (C),H:NOP:OUT (C),B:NOP
	PAUSE_24
	;--
	OUT (C),B:NOP:OUT (C),H:NOP:OUT	(C),B
	CALL	CALC_4
	NOP:NOP:NOP:OUT (C),H:NOP:OUT (C),B:NOP
	NEXT_LINE
PLASM31	;------------------- ln0
	EXX
	OUT (C),B:OUT (C),H:NOP:NOP:OUT	(C),B
	CALL	CALC_1
	NOP:NOP:NOP:OUT (C),H:NOP:NOP:OUT (C),B
	PAUSE_24
	;--
	OUT (C),B:OUT (C),H:NOP:NOP:OUT	(C),B
	CALL	CALC_2
	NOP:NOP:NOP:OUT (C),H:NOP:NOP:OUT (C),B
	PAUSE_24
	;--
	OUT (C),B:OUT (C),H:NOP:NOP:OUT	(C),B
	CALL	CALC_3
	NOP:NOP:NOP:OUT (C),H:NOP:NOP:OUT (C),B
	PAUSE_24
	;--
	OUT (C),B:OUT (C),H:NOP:NOP:OUT	(C),B
	CALL	CALC_4
	NOP:NOP:NOP:OUT (C),H:NOP:NOP:OUT (C),B
	NEXT_LINE
;------------------------------------------------
; VARIABLES
;------------------------------------------------
	ORG	(($/256)+1)*256
;----------------------
MAPZX	INCBIN	"mapzx.bin"
;----------------------
	DS	128,0
;------------------------
SINTBL	INCBIN	"costbl.bin"
;------------------------
JPTBL_A	DUP	2
	DW	P0A,PLASM0
	DW	P1A,PLASM1
	DW	P2A,PLASM2
	DW	P3A,PLASM3
	DW	P4A,PLASM4
	DW	P5A,PLASM5
	DW	P6A,PLASM6
	DW	P7A,PLASM7
	DW	P8A,PLASM8
	DW	P9A,PLASM9
	DW	P10A,PLASM10
	DW	P11A,PLASM11
	DW	P12A,PLASM12
	DW	P13A,PLASM13
	DW	P14A,PLASM14
	DW	P15A,PLASM15
	DW	P16A,PLASM16
	DW	P17A,PLASM17
	DW	P18A,PLASM18
	DW	P19A,PLASM19
	DW	P20A,PLASM20
	DW	P21A,PLASM21
	DW	P22A,PLASM22
	DW	P23A,PLASM23
	DW	P24A,PLASM24
	DW	P25A,PLASM25
	DW	P26A,PLASM26
	DW	P27A,PLASM27
	DW	P28A,PLASM28
	DW	P29A,PLASM29
	DW	P30A,PLASM30
	DW	P31A,PLASM31
	EDUP
;--------------
JPTBL_B	DUP	2
	DW	P0B,PLASM0
	DW	P1B,PLASM1
	DW	P2B,PLASM2
	DW	P3B,PLASM3
	DW	P4B,PLASM4
	DW	P5B,PLASM5
	DW	P6B,PLASM6
	DW	P7B,PLASM7
	DW	P8B,PLASM8
	DW	P9B,PLASM9
	DW	P10B,PLASM10
	DW	P11B,PLASM11
	DW	P12B,PLASM12
	DW	P13B,PLASM13
	DW	P14B,PLASM14
	DW	P15B,PLASM15
	DW	P16B,PLASM16
	DW	P17B,PLASM17
	DW	P18B,PLASM18
	DW	P19B,PLASM19
	DW	P20B,PLASM20
	DW	P21B,PLASM21
	DW	P22B,PLASM22
	DW	P23B,PLASM23
	DW	P24B,PLASM24
	DW	P25B,PLASM25
	DW	P26B,PLASM26
	DW	P27B,PLASM27
	DW	P28B,PLASM28
	DW	P29B,PLASM29
	DW	P30B,PLASM30
	DW	P31B,PLASM31
	EDUP
	
;------------------------
P_TBL	DUP	48		;48*4=192_len	SCR_ADR,JP_ADR
	DW	#0000,P0A
	EDUP
;------------------------
PB_TBL	DUP	48
	DW	PLASM0
	EDUP
	DW PLASMRET
;------------------------
	ORG	(($+255)/256)*256
BAR_ADR_A ;---------------
	DW	(31-CNT_UP)+BARTBL1A,BARTBL2A
	DW	(31-CNT_UP)+BARTBL1A+31*1,BARTBL2A+24*1
	DW	(31-CNT_UP)+BARTBL1A+31*2,BARTBL2A+24*2
	DW	(31-CNT_UP)+BARTBL1A+31*3,BARTBL2A+24*3
	DW	(31-CNT_UP)+BARTBL1A+31*4,BARTBL2A+24*4
	DW	(31-CNT_UP)+BARTBL1A+31*5,BARTBL2A+24*5
	DW	(31-CNT_UP)+BARTBL1A+31*6,BARTBL2A+24*6
	DW	(31-CNT_UP)+BARTBL1A+31*7,BARTBL2A+24*7
	DW	(31-CNT_UP)+BARTBL1A+31*8,BARTBL2A+24*8
	DW	(31-CNT_UP)+BARTBL1A+31*9,BARTBL2A+24*9
	DW	(31-CNT_UP)+BARTBL1A+31*10,BARTBL2A+24*10
	DW	(31-CNT_UP)+BARTBL1A+31*11,BARTBL2A+24*11
	DW	(31-CNT_UP)+BARTBL1A+31*12,BARTBL2A+24*12
	DW	(31-CNT_UP)+BARTBL1A+31*13,BARTBL2A+24*13
	DW	(31-CNT_UP)+BARTBL1A+31*14,BARTBL2A+24*14
	DW	(31-CNT_UP)+BARTBL1A+31*15,BARTBL2A+24*15
	ORG	(($+255)/256)*256
BAR_ADR_B ;---------------
	DW	(31-CNT_UP)+BARTBL1B,BARTBL2B
	DW	(31-CNT_UP)+BARTBL1B+31*1,BARTBL2B+24*1
	DW	(31-CNT_UP)+BARTBL1B+31*2,BARTBL2B+24*2
	DW	(31-CNT_UP)+BARTBL1B+31*3,BARTBL2B+24*3
	DW	(31-CNT_UP)+BARTBL1B+31*4,BARTBL2B+24*4
	DW	(31-CNT_UP)+BARTBL1B+31*5,BARTBL2B+24*5
	DW	(31-CNT_UP)+BARTBL1B+31*6,BARTBL2B+24*6
	DW	(31-CNT_UP)+BARTBL1B+31*7,BARTBL2B+24*7
	DW	(31-CNT_UP)+BARTBL1B+31*8,BARTBL2B+24*8
	DW	(31-CNT_UP)+BARTBL1B+31*9,BARTBL2B+24*9
	DW	(31-CNT_UP)+BARTBL1B+31*10,BARTBL2B+24*10
	DW	(31-CNT_UP)+BARTBL1B+31*11,BARTBL2B+24*11
	DW	(31-CNT_UP)+BARTBL1B+31*12,BARTBL2B+24*12
	DW	(31-CNT_UP)+BARTBL1B+31*13,BARTBL2B+24*13
	DW	(31-CNT_UP)+BARTBL1B+31*14,BARTBL2B+24*14
	DW	(31-CNT_UP)+BARTBL1B+31*15,BARTBL2B+24*15





	DISPLAY	"UP_RAM = ",/A,UP_RAM
	DISPLAY	"PLASM = ",/A,PLASM
	DISPLAY	"PB_TBL = ",/A,PB_TBL




