/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBBindlessTexture {
    public static final int GL_UNSIGNED_INT64_ARB = 5135;
    public final long GetTextureHandleARB;
    public final long GetTextureSamplerHandleARB;
    public final long MakeTextureHandleResidentARB;
    public final long MakeTextureHandleNonResidentARB;
    public final long GetImageHandleARB;
    public final long MakeImageHandleResidentARB;
    public final long MakeImageHandleNonResidentARB;
    public final long UniformHandleui64ARB;
    public final long UniformHandleui64vARB;
    public final long ProgramUniformHandleui64ARB;
    public final long ProgramUniformHandleui64vARB;
    public final long IsTextureHandleResidentARB;
    public final long IsImageHandleResidentARB;
    public final long VertexAttribL1ui64ARB;
    public final long VertexAttribL1ui64vARB;
    public final long GetVertexAttribLui64vARB;

    public ARBBindlessTexture(FunctionProvider provider) {
        this.GetTextureHandleARB = provider.getFunctionAddress("glGetTextureHandleARB");
        this.GetTextureSamplerHandleARB = provider.getFunctionAddress("glGetTextureSamplerHandleARB");
        this.MakeTextureHandleResidentARB = provider.getFunctionAddress("glMakeTextureHandleResidentARB");
        this.MakeTextureHandleNonResidentARB = provider.getFunctionAddress("glMakeTextureHandleNonResidentARB");
        this.GetImageHandleARB = provider.getFunctionAddress("glGetImageHandleARB");
        this.MakeImageHandleResidentARB = provider.getFunctionAddress("glMakeImageHandleResidentARB");
        this.MakeImageHandleNonResidentARB = provider.getFunctionAddress("glMakeImageHandleNonResidentARB");
        this.UniformHandleui64ARB = provider.getFunctionAddress("glUniformHandleui64ARB");
        this.UniformHandleui64vARB = provider.getFunctionAddress("glUniformHandleui64vARB");
        this.ProgramUniformHandleui64ARB = provider.getFunctionAddress("glProgramUniformHandleui64ARB");
        this.ProgramUniformHandleui64vARB = provider.getFunctionAddress("glProgramUniformHandleui64vARB");
        this.IsTextureHandleResidentARB = provider.getFunctionAddress("glIsTextureHandleResidentARB");
        this.IsImageHandleResidentARB = provider.getFunctionAddress("glIsImageHandleResidentARB");
        this.VertexAttribL1ui64ARB = provider.getFunctionAddress("glVertexAttribL1ui64ARB");
        this.VertexAttribL1ui64vARB = provider.getFunctionAddress("glVertexAttribL1ui64vARB");
        this.GetVertexAttribLui64vARB = provider.getFunctionAddress("glGetVertexAttribLui64vARB");
    }

    public static ARBBindlessTexture getInstance() {
        return GL.getCapabilities().__ARBBindlessTexture;
    }

    static ARBBindlessTexture create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_bindless_texture")) {
            return null;
        }
        ARBBindlessTexture funcs = new ARBBindlessTexture(provider);
        boolean supported = Checks.checkFunctions(funcs.GetTextureHandleARB, funcs.GetTextureSamplerHandleARB, funcs.MakeTextureHandleResidentARB, funcs.MakeTextureHandleNonResidentARB, funcs.GetImageHandleARB, funcs.MakeImageHandleResidentARB, funcs.MakeImageHandleNonResidentARB, funcs.UniformHandleui64ARB, funcs.UniformHandleui64vARB, funcs.ProgramUniformHandleui64ARB, funcs.ProgramUniformHandleui64vARB, funcs.IsTextureHandleResidentARB, funcs.IsImageHandleResidentARB, funcs.VertexAttribL1ui64ARB, funcs.VertexAttribL1ui64vARB, funcs.GetVertexAttribLui64vARB);
        return GL.checkExtension("GL_ARB_bindless_texture", funcs, supported);
    }

    public static native long nglGetTextureHandleARB(int var0, long var1);

    public static long glGetTextureHandleARB(int texture) {
        long __functionAddress = ARBBindlessTexture.getInstance().GetTextureHandleARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return ARBBindlessTexture.nglGetTextureHandleARB(texture, __functionAddress);
    }

    public static native long nglGetTextureSamplerHandleARB(int var0, int var1, long var2);

    public static long glGetTextureSamplerHandleARB(int texture, int sampler) {
        long __functionAddress = ARBBindlessTexture.getInstance().GetTextureSamplerHandleARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return ARBBindlessTexture.nglGetTextureSamplerHandleARB(texture, sampler, __functionAddress);
    }

    public static native void nglMakeTextureHandleResidentARB(long var0, long var2);

    public static void glMakeTextureHandleResidentARB(long handle) {
        long __functionAddress = ARBBindlessTexture.getInstance().MakeTextureHandleResidentARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBBindlessTexture.nglMakeTextureHandleResidentARB(handle, __functionAddress);
    }

    public static native void nglMakeTextureHandleNonResidentARB(long var0, long var2);

    public static void glMakeTextureHandleNonResidentARB(long handle) {
        long __functionAddress = ARBBindlessTexture.getInstance().MakeTextureHandleNonResidentARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBBindlessTexture.nglMakeTextureHandleNonResidentARB(handle, __functionAddress);
    }

    public static native long nglGetImageHandleARB(int var0, int var1, boolean var2, int var3, int var4, long var5);

    public static long glGetImageHandleARB(int texture, int level, boolean layered, int layer, int format) {
        long __functionAddress = ARBBindlessTexture.getInstance().GetImageHandleARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return ARBBindlessTexture.nglGetImageHandleARB(texture, level, layered, layer, format, __functionAddress);
    }

    public static native void nglMakeImageHandleResidentARB(long var0, int var2, long var3);

    public static void glMakeImageHandleResidentARB(long handle, int access) {
        long __functionAddress = ARBBindlessTexture.getInstance().MakeImageHandleResidentARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBBindlessTexture.nglMakeImageHandleResidentARB(handle, access, __functionAddress);
    }

    public static native void nglMakeImageHandleNonResidentARB(long var0, long var2);

    public static void glMakeImageHandleNonResidentARB(long handle) {
        long __functionAddress = ARBBindlessTexture.getInstance().MakeImageHandleNonResidentARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBBindlessTexture.nglMakeImageHandleNonResidentARB(handle, __functionAddress);
    }

    public static native void nglUniformHandleui64ARB(int var0, long var1, long var3);

    public static void glUniformHandleui64ARB(int location, long value) {
        long __functionAddress = ARBBindlessTexture.getInstance().UniformHandleui64ARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBBindlessTexture.nglUniformHandleui64ARB(location, value, __functionAddress);
    }

    public static native void nglUniformHandleui64vARB(int var0, int var1, long var2, long var4);

    public static void nglUniformHandleui64vARB(int location, int count, long values) {
        long __functionAddress = ARBBindlessTexture.getInstance().UniformHandleui64vARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBBindlessTexture.nglUniformHandleui64vARB(location, count, values, __functionAddress);
    }

    public static void glUniformHandleui64vARB(int location, int count, ByteBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)values, count << 3);
        }
        ARBBindlessTexture.nglUniformHandleui64vARB(location, count, MemoryUtil.memAddress(values));
    }

    public static void glUniformHandleui64vARB(int location, LongBuffer values) {
        ARBBindlessTexture.nglUniformHandleui64vARB(location, values.remaining(), MemoryUtil.memAddress(values));
    }

    public static native void nglProgramUniformHandleui64ARB(int var0, int var1, long var2, long var4);

    public static void glProgramUniformHandleui64ARB(int program, int location, long value) {
        long __functionAddress = ARBBindlessTexture.getInstance().ProgramUniformHandleui64ARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBBindlessTexture.nglProgramUniformHandleui64ARB(program, location, value, __functionAddress);
    }

    public static native void nglProgramUniformHandleui64vARB(int var0, int var1, int var2, long var3, long var5);

    public static void nglProgramUniformHandleui64vARB(int program, int location, int count, long values) {
        long __functionAddress = ARBBindlessTexture.getInstance().ProgramUniformHandleui64vARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBBindlessTexture.nglProgramUniformHandleui64vARB(program, location, count, values, __functionAddress);
    }

    public static void glProgramUniformHandleui64vARB(int program, int location, int count, ByteBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)values, count << 3);
        }
        ARBBindlessTexture.nglProgramUniformHandleui64vARB(program, location, count, MemoryUtil.memAddress(values));
    }

    public static void glProgramUniformHandleui64vARB(int program, int location, LongBuffer values) {
        ARBBindlessTexture.nglProgramUniformHandleui64vARB(program, location, values.remaining(), MemoryUtil.memAddress(values));
    }

    public static native boolean nglIsTextureHandleResidentARB(long var0, long var2);

    public static boolean glIsTextureHandleResidentARB(long handle) {
        long __functionAddress = ARBBindlessTexture.getInstance().IsTextureHandleResidentARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return ARBBindlessTexture.nglIsTextureHandleResidentARB(handle, __functionAddress);
    }

    public static native boolean nglIsImageHandleResidentARB(long var0, long var2);

    public static boolean glIsImageHandleResidentARB(long handle) {
        long __functionAddress = ARBBindlessTexture.getInstance().IsImageHandleResidentARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return ARBBindlessTexture.nglIsImageHandleResidentARB(handle, __functionAddress);
    }

    public static native void nglVertexAttribL1ui64ARB(int var0, long var1, long var3);

    public static void glVertexAttribL1ui64ARB(int index, long x) {
        long __functionAddress = ARBBindlessTexture.getInstance().VertexAttribL1ui64ARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBBindlessTexture.nglVertexAttribL1ui64ARB(index, x, __functionAddress);
    }

    public static native void nglVertexAttribL1ui64vARB(int var0, long var1, long var3);

    public static void nglVertexAttribL1ui64vARB(int index, long v) {
        long __functionAddress = ARBBindlessTexture.getInstance().VertexAttribL1ui64vARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBBindlessTexture.nglVertexAttribL1ui64vARB(index, v, __functionAddress);
    }

    public static void glVertexAttribL1ui64vARB(int index, ByteBuffer v) {
        ARBBindlessTexture.nglVertexAttribL1ui64vARB(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttribL1ui64vARB(int index, LongBuffer v) {
        ARBBindlessTexture.nglVertexAttribL1ui64vARB(index, MemoryUtil.memAddress(v));
    }

    public static native void nglGetVertexAttribLui64vARB(int var0, int var1, long var2, long var4);

    public static void nglGetVertexAttribLui64vARB(int index, int pname, long params) {
        long __functionAddress = ARBBindlessTexture.getInstance().GetVertexAttribLui64vARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBBindlessTexture.nglGetVertexAttribLui64vARB(index, pname, params, __functionAddress);
    }

    public static void glGetVertexAttribLui64vARB(int index, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        ARBBindlessTexture.nglGetVertexAttribLui64vARB(index, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetVertexAttribLui64vARB(int index, int pname, LongBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBBindlessTexture.nglGetVertexAttribLui64vARB(index, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetVertexAttribLui64ARB(int index, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        ARBBindlessTexture.nglGetVertexAttribLui64vARB(index, pname, __buffer.address(params));
        return __buffer.longValue(params);
    }
}

