#include <genesis.h>


#include "gfx.h"


//DEFINES
#define DIR_NONE	0
#define DIR_LEFT 	1
#define DIR_RIGHT	2
#define DIR_ACTION		3


#define PAD_LEFT	0
#define PAD_LEFT_ANIM	1
#define PAD_RIGHT	2
#define PAD_RIGHT_ANIM	3
#define PAD_A	4
#define PAD_A_ANIM	5

#define MIN_POSX        FIX32(-5)
#define MAX_POSX        FIX32(5)


//GLOBS
s16 dir;

// sprites structure
Sprite sprites[5];

fix32 camposx;
fix32 posx;
fix32 posy;
u8 show_sequence;
int sequence[5];


//FUNCTIONS
static void handleInput()
{
    u16 value = JOY_readJoypad(JOY_1);

	/* if (value & BUTTON_A) dir = ACTION_DONE;
    else dir = ACTION_NONE; */
    if (value & BUTTON_LEFT) dir = DIR_LEFT;
    else if (value & BUTTON_RIGHT) dir = DIR_RIGHT;
	else if (value & BUTTON_A) dir = DIR_ACTION;
	 else dir = DIR_NONE;
	
}

void myJoyHandler( u16 joy, u16 changed, u16 state)
{
	
}

static void updatePhysic()
{

	

}

static void updateAnim()
{
   switch(dir){
		case DIR_LEFT : 
		SPR_setAnim(&sprites[0],PAD_LEFT_ANIM);
		SPR_setAnim(&sprites[3],1); //1
		
		break;
		case DIR_RIGHT: 
		SPR_setAnim(&sprites[1],PAD_RIGHT_ANIM);
		SPR_setAnim(&sprites[3],2); //2
	
		break;
		/* case DIR_NONE : 
		SPR_setAnim(&sprites[0],PAD_LEFT);
			SPR_setAnim(&sprites[1],PAD_RIGHT);
		break; */
		case DIR_ACTION : 
		SPR_setAnim(&sprites[2],PAD_A_ANIM);
		SPR_setAnim(&sprites[3],3); // 3
		break;
		/* case ACTION_NONE : 
		SPR_setAnim(&sprites[2],PAD_A);break; */
		default:
		SPR_setAnim(&sprites[0],PAD_LEFT);
			SPR_setAnim(&sprites[1],PAD_RIGHT);
			SPR_setAnim(&sprites[2],PAD_A);
			//SPR_setAnim(&sprites[3],0);
		break;
	}
}

static void initSequence(){
	if (show_sequence) {
		VDP_drawText("Memorise la danse ",12,8);
	VDP_drawText("de Lapinou ...",12,9);
	
	VDP_drawText("Mouvement 1",12,19);
	sequence[0] = DIR_LEFT;
	SPR_setAnim(&sprites[3],DIR_LEFT);
	SPR_update(sprites,4);
	waitMs(2000);
	
	VDP_drawText("Mouvement 2",12,19);
	sequence[1] = DIR_LEFT;
	SPR_setAnim(&sprites[3],DIR_LEFT);
	SPR_update(sprites,4);
	waitMs(2000);
	
	VDP_drawText("Mouvement 3",12,19);
	sequence[2] = DIR_RIGHT;
	SPR_setAnim(&sprites[3],DIR_RIGHT);
	SPR_update(sprites,4);
	waitMs(2000);
	
	VDP_drawText("Mouvement 4",12,19);
	sequence[3] = DIR_ACTION;
	SPR_setAnim(&sprites[3],DIR_ACTION);
	SPR_update(sprites,4);
	waitMs(2000);
	
	VDP_drawText("Mouvement 5",12,19);
	sequence[4] = DIR_ACTION;
	SPR_setAnim(&sprites[3],DIR_ACTION);
	SPR_update(sprites,4);
	waitMs(2000);
	
	show_sequence = 0;
	SPR_setAnim(&sprites[3],DIR_NONE);
	SPR_update(sprites,4);
	VDP_drawText("A ton tour         ",12,8);
	VDP_drawText("Danse comme             ",12,9);
	VDP_drawText("Lapinou              ",12,10);
		VDP_drawText("           ",12,19);
	}
}
//MAIN
int main( )
{
	//init vars
	dir=DIR_NONE;
	show_sequence = 1;

   u16 palette[64];
     u16 ind;
   
   posx = FIX32(24);
   posy = FIX32(175);
   
     camposx = -1;
	 
	//init funcs
	// disable interrupt when accessing VDP
    SYS_disableInts();
    // initialization
    VDP_setScreenWidth320();
	 // init sprites engine
    SPR_init(256);
	// set all palette to black
    VDP_setPaletteColors(0, palette_black, 64);
	
	JOY_init();
	JOY_setEventHandler( &myJoyHandler );

	  // load background
    ind = TILE_USERINDEX;
	VDP_drawImageEx(BPLAN, &background, TILE_ATTR_FULL(PAL0, FALSE, FALSE, FALSE, ind), 0, 0, TRUE, TRUE);
	  ind += background.tileset->numTile;
	  
	 // init pad sprite
    SPR_initSprite(&sprites[0], &spritesheet, fix32ToInt(posx - camposx), fix32ToInt(posy), TILE_ATTR(PAL1, TRUE, FALSE, FALSE));
    SPR_initSprite(&sprites[1], &spritesheet, fix32ToInt((posx - camposx)+FIX32(32)), fix32ToInt(posy), TILE_ATTR(PAL1, TRUE, FALSE, FALSE));
	SPR_initSprite(&sprites[2], &spritesheet, fix32ToInt((posx - camposx)+FIX32(215)), fix32ToInt(posy), TILE_ATTR(PAL1, TRUE, FALSE, FALSE));
	
	//init lapinou sprite
	SPR_initSprite(&sprites[3], &lapinou, 150, 100, TILE_ATTR(PAL2, TRUE, FALSE, FALSE));
	
/* 	SPR_update(sprites, 1);
	SPR_update(sprites,2); */
 	//SPR_setAnim(&sprites[0],PAD_LEFT_ANIM);
/*	SPR_setAnim(&sprites[1],3);
	SPR_setAnim(&sprites[2],5); */
	
	// prepare palettes
     memcpy(&palette[0], background.palette->data, 16 * 2);
    memcpy(&palette[16], spritesheet.palette->data, 16 * 2);
	 //memcpy(&palette[32], lapinou.palette->data, 16 * 2);
   

    // fade in
    VDP_fadeIn(0, (3 * 16) - 1, palette, 20, FALSE);
	
	   // VDP process done, we can re enable interrupts
    SYS_enableInts();
	

	//loop
	while(1)
	{
		initSequence();
			handleInput();
			
			updatePhysic();
			updateAnim();

        // update sprites pad
        SPR_update(sprites, 1);
SPR_update(sprites,2);
SPR_update(sprites,3);

// update sprites lapinou
SPR_update(sprites,4);



		VDP_waitVSync();
	}
	return 0;
}
