#ifndef DNLOAD_H
#define DNLOAD_H

/** \file
 * \brief Dynamic loader header stub.
 *
 * This file was automatically generated by 'dnload.py'.
 */

#if defined(WIN32)
/** \cond */
#define _USE_MATH_DEFINES
#define NOMINMAX
/** \endcond */
#else
/** \cond */
#define GL_GLEXT_PROTOTYPES
/** \endcond */
#endif

#if defined(__cplusplus)
#include <cmath>
#include <cstdlib>
#else
#include <math.h>
#include <stdlib.h>
#endif

#if defined(DNLOAD_VIDEOCORE)
#include "bcm_host.h"
#include "EGL/egl.h"
#endif

#if defined(USE_LD)
#if defined(WIN32)
#include "windows.h"
#include "GL/glew.h"
#include "GL/glu.h"
#include "ft2build.h"
#include FT_FREETYPE_H
#include "SDL.h"
#elif defined(__APPLE__)
#include "GL/glew.h"
#include <OpenGL/glu.h>
#include "ft2build.h"
#include FT_FREETYPE_H
#include "SDL.h"
#else
#if defined(DNLOAD_GLESV2)
#include "GLES2/gl2.h"
#include "GLES2/gl2ext.h"
#else
#include "GL/glew.h"
#include "GL/glu.h"
#endif
#include "ft2build.h"
#include FT_FREETYPE_H
#include "SDL.h"
#endif
#include "bsd_rand.h"
#else
#if defined(__APPLE__)
#include <OpenGL/gl.h>
#include <OpenGL/glext.h>
#include <OpenGL/glu.h>
#include "ft2build.h"
#include FT_FREETYPE_H
#include "SDL.h"
#else
#if defined(DNLOAD_GLESV2)
#include "GLES2/gl2.h"
#include "GLES2/gl2ext.h"
#else
#include "GL/gl.h"
#include "GL/glext.h"
#include "GL/glu.h"
#endif
#include "ft2build.h"
#include FT_FREETYPE_H
#include "SDL.h"
#endif
#endif

#if defined(SDL_INIT_EVERYTHING) && defined(__APPLE__) 
#define DNLOAD_MAIN SDL_main
#else
#define DNLOAD_MAIN main
#endif

/** Macro stringification helper (adds indirection). */
#define DNLOAD_MACRO_STR_HELPER(op) #op
/** Macro stringification. */
#define DNLOAD_MACRO_STR(op) DNLOAD_MACRO_STR_HELPER(op)

#if defined(DNLOAD_GLESV2)
/** Apientry definition (OpenGL ES 2.0). */
#define DNLOAD_APIENTRY GL_APIENTRY
#else
/** Apientry definition (OpenGL). */
#define DNLOAD_APIENTRY GLAPIENTRY
#endif

#if (defined(_LP64) && _LP64) || (defined(__LP64__) && __LP64__)
/** Size of pointer in bytes (64-bit). */
#define DNLOAD_POINTER_SIZE 8
#else
/** Size of pointer in bytes (32-bit). */
#define DNLOAD_POINTER_SIZE 4
#endif

#if !defined(USE_LD)
/** Error string for when assembler exit procedure is not available. */
#define DNLOAD_ASM_EXIT_ERROR "no assembler exit procedure defined for current operating system or architecture"
/** Perform exit syscall in assembler. */
static void asm_exit(void)
{
#if !defined(DNLOAD_NO_DEBUGGER_TRAP) && (defined(__x86_64__) || defined(__i386__))
  asm("int $0x3" : /* no output */ : /* no input */ : /* no clobber */);
#elif defined(__x86_64__)
#if defined(__FreeBSD__)
  asm_exit() asm("syscall" : /* no output */ : "a"(1) : /* no clobber */);
#elif defined(__linux__)
  asm_exit() asm("syscall" : /* no output */ : "a"(60) : /* no clobber */);
#else
#pragma message DNLOAD_MACRO_STR(DNLOAD_ASM_EXIT_ERROR)
#error
#endif
#elif defined(__i386__)
#if defined(__FreeBSD__) || defined(__linux__)
  asm("int $0x80" : /* no output */ : "a"(1) : /* no clobber */);
#else
#pragma message DNLOAD_MACRO_STR(DNLOAD_ASM_EXIT_ERROR)
#error
#endif
#elif defined(__arm__)
#if defined(__linux__)
  register int r7 asm("r7") = 1;
  asm("swi #0" : /* no output */ : "r"(r7) : /* no clobber */);
#else
#pragma message DNLOAD_MACRO_STR(DNLOAD_ASM_EXIT_ERROR)
#error
#endif
#else
#pragma message DNLOAD_MACRO_STR(DNLOAD_ASM_EXIT_ERROR)
#error
#endif
}
#endif

#if defined(USE_LD)
/** \cond */
#define dnload_glActiveTexture glActiveTexture
#define dnload_glAttachShader glAttachShader
#define dnload_glBindBuffer glBindBuffer
#define dnload_glBindFramebuffer glBindFramebuffer
#define dnload_glBindRenderbuffer glBindRenderbuffer
#define dnload_glBindTexture glBindTexture
#define dnload_glBlendFuncSeparate glBlendFuncSeparate
#define dnload_glBufferData glBufferData
#define dnload_glClear glClear
#define dnload_glClearColor glClearColor
#define dnload_glColorMask glColorMask
#define dnload_glCompileShader glCompileShader
#define dnload_glCreateProgram glCreateProgram
#define dnload_glCreateShader glCreateShader
#define dnload_glCullFace glCullFace
#define dnload_glDeleteBuffers glDeleteBuffers
#define dnload_glDepthFunc glDepthFunc
#define dnload_glDepthMask glDepthMask
#define dnload_glDisable glDisable
#define dnload_glDisableVertexAttribArray glDisableVertexAttribArray
#define dnload_glDrawArrays glDrawArrays
#define dnload_glDrawElements glDrawElements
#define dnload_glEnable glEnable
#define dnload_glEnableVertexAttribArray glEnableVertexAttribArray
#define dnload_glFramebufferRenderbuffer glFramebufferRenderbuffer
#define dnload_glFramebufferTexture2D glFramebufferTexture2D
#define dnload_glGenBuffers glGenBuffers
#define dnload_glGenFramebuffers glGenFramebuffers
#define dnload_glGenRenderbuffers glGenRenderbuffers
#define dnload_glGenTextures glGenTextures
#define dnload_glGenerateMipmap glGenerateMipmap
#define dnload_glGetAttribLocation glGetAttribLocation
#define dnload_glGetUniformLocation glGetUniformLocation
#define dnload_glLinkProgram glLinkProgram
#define dnload_glPolygonOffset glPolygonOffset
#define dnload_glRenderbufferStorage glRenderbufferStorage
#define dnload_glShaderSource glShaderSource
#define dnload_glStencilFunc glStencilFunc
#define dnload_glStencilMask glStencilMask
#define dnload_glStencilOpSeparate glStencilOpSeparate
#define dnload_glTexImage2D glTexImage2D
#define dnload_glTexParameteri glTexParameteri
#define dnload_glUniform1f glUniform1f
#define dnload_glUniform1i glUniform1i
#define dnload_glUniform2fv glUniform2fv
#define dnload_glUniform3fv glUniform3fv
#define dnload_glUniform4f glUniform4f
#define dnload_glUniformMatrix3fv glUniformMatrix3fv
#define dnload_glUniformMatrix4fv glUniformMatrix4fv
#define dnload_glUseProgram glUseProgram
#define dnload_glVertexAttribPointer glVertexAttribPointer
#define dnload_glViewport glViewport
#define dnload_SDL_CondSignal SDL_CondSignal
#define dnload_SDL_CondWait SDL_CondWait
#define dnload_SDL_CreateCond SDL_CreateCond
#define dnload_SDL_CreateMutex SDL_CreateMutex
#define dnload_SDL_CreateThread SDL_CreateThread
#define dnload_SDL_Delay SDL_Delay
#define dnload_SDL_DestroyCond SDL_DestroyCond
#define dnload_SDL_DestroyMutex SDL_DestroyMutex
#define dnload_SDL_GetTicks SDL_GetTicks
#define dnload_SDL_Init SDL_Init
#define dnload_SDL_OpenAudio SDL_OpenAudio
#define dnload_SDL_PauseAudio SDL_PauseAudio
#define dnload_SDL_PollEvent SDL_PollEvent
#define dnload_SDL_Quit SDL_Quit
#define dnload_SDL_ShowCursor SDL_ShowCursor
#define dnload_SDL_WaitThread SDL_WaitThread
#define dnload_SDL_CreateWindow SDL_CreateWindow
#define dnload_SDL_GL_CreateContext SDL_GL_CreateContext
#define dnload_SDL_GL_SetAttribute SDL_GL_SetAttribute
#define dnload_SDL_GL_SwapWindow SDL_GL_SwapWindow
#define dnload_SDL_LockMutex SDL_LockMutex
#define dnload_SDL_UnlockMutex SDL_UnlockMutex
#define dnload_memset memset
#define dnload_qsort qsort
#define dnload_realloc realloc
#define dnload_FT_Get_Char_Index FT_Get_Char_Index
#define dnload_FT_Init_FreeType FT_Init_FreeType
#define dnload_FT_Load_Glyph FT_Load_Glyph
#define dnload_FT_New_Face FT_New_Face
#define dnload_FT_Render_Glyph FT_Render_Glyph
#define dnload_FT_Set_Pixel_Sizes FT_Set_Pixel_Sizes
#define dnload_atan2f atan2f
#define dnload_atanf atanf
#define dnload_cosf cosf
#define dnload_fmodf fmodf
#define dnload_sinf sinf
#define dnload_sqrtf sqrtf
#define dnload_tanf tanf
/** \endcond */
#else
/** \cond */
#define dnload_glActiveTexture g_symbol_table.glActiveTexture
#define dnload_glAttachShader g_symbol_table.glAttachShader
#define dnload_glBindBuffer g_symbol_table.glBindBuffer
#define dnload_glBindFramebuffer g_symbol_table.glBindFramebuffer
#define dnload_glBindRenderbuffer g_symbol_table.glBindRenderbuffer
#define dnload_glBindTexture g_symbol_table.glBindTexture
#define dnload_glBlendFuncSeparate g_symbol_table.glBlendFuncSeparate
#define dnload_glBufferData g_symbol_table.glBufferData
#define dnload_glClear g_symbol_table.glClear
#define dnload_glClearColor g_symbol_table.glClearColor
#define dnload_glColorMask g_symbol_table.glColorMask
#define dnload_glCompileShader g_symbol_table.glCompileShader
#define dnload_glCreateProgram g_symbol_table.glCreateProgram
#define dnload_glCreateShader g_symbol_table.glCreateShader
#define dnload_glCullFace g_symbol_table.glCullFace
#define dnload_glDeleteBuffers g_symbol_table.glDeleteBuffers
#define dnload_glDepthFunc g_symbol_table.glDepthFunc
#define dnload_glDepthMask g_symbol_table.glDepthMask
#define dnload_glDisable g_symbol_table.glDisable
#define dnload_glDisableVertexAttribArray g_symbol_table.glDisableVertexAttribArray
#define dnload_glDrawArrays g_symbol_table.glDrawArrays
#define dnload_glDrawElements g_symbol_table.glDrawElements
#define dnload_glEnable g_symbol_table.glEnable
#define dnload_glEnableVertexAttribArray g_symbol_table.glEnableVertexAttribArray
#define dnload_glFramebufferRenderbuffer g_symbol_table.glFramebufferRenderbuffer
#define dnload_glFramebufferTexture2D g_symbol_table.glFramebufferTexture2D
#define dnload_glGenBuffers g_symbol_table.glGenBuffers
#define dnload_glGenFramebuffers g_symbol_table.glGenFramebuffers
#define dnload_glGenRenderbuffers g_symbol_table.glGenRenderbuffers
#define dnload_glGenTextures g_symbol_table.glGenTextures
#define dnload_glGenerateMipmap g_symbol_table.glGenerateMipmap
#define dnload_glGetAttribLocation g_symbol_table.glGetAttribLocation
#define dnload_glGetUniformLocation g_symbol_table.glGetUniformLocation
#define dnload_glLinkProgram g_symbol_table.glLinkProgram
#define dnload_glPolygonOffset g_symbol_table.glPolygonOffset
#define dnload_glRenderbufferStorage g_symbol_table.glRenderbufferStorage
#define dnload_glShaderSource g_symbol_table.glShaderSource
#define dnload_glStencilFunc g_symbol_table.glStencilFunc
#define dnload_glStencilMask g_symbol_table.glStencilMask
#define dnload_glStencilOpSeparate g_symbol_table.glStencilOpSeparate
#define dnload_glTexImage2D g_symbol_table.glTexImage2D
#define dnload_glTexParameteri g_symbol_table.glTexParameteri
#define dnload_glUniform1f g_symbol_table.glUniform1f
#define dnload_glUniform1i g_symbol_table.glUniform1i
#define dnload_glUniform2fv g_symbol_table.glUniform2fv
#define dnload_glUniform3fv g_symbol_table.glUniform3fv
#define dnload_glUniform4f g_symbol_table.glUniform4f
#define dnload_glUniformMatrix3fv g_symbol_table.glUniformMatrix3fv
#define dnload_glUniformMatrix4fv g_symbol_table.glUniformMatrix4fv
#define dnload_glUseProgram g_symbol_table.glUseProgram
#define dnload_glVertexAttribPointer g_symbol_table.glVertexAttribPointer
#define dnload_glViewport g_symbol_table.glViewport
#define dnload_SDL_CondSignal g_symbol_table.SDL_CondSignal
#define dnload_SDL_CondWait g_symbol_table.SDL_CondWait
#define dnload_SDL_CreateCond g_symbol_table.SDL_CreateCond
#define dnload_SDL_CreateMutex g_symbol_table.SDL_CreateMutex
#define dnload_SDL_CreateThread g_symbol_table.SDL_CreateThread
#define dnload_SDL_Delay g_symbol_table.SDL_Delay
#define dnload_SDL_DestroyCond g_symbol_table.SDL_DestroyCond
#define dnload_SDL_DestroyMutex g_symbol_table.SDL_DestroyMutex
#define dnload_SDL_GetTicks g_symbol_table.SDL_GetTicks
#define dnload_SDL_Init g_symbol_table.SDL_Init
#define dnload_SDL_OpenAudio g_symbol_table.SDL_OpenAudio
#define dnload_SDL_PauseAudio g_symbol_table.SDL_PauseAudio
#define dnload_SDL_PollEvent g_symbol_table.SDL_PollEvent
#define dnload_SDL_Quit g_symbol_table.SDL_Quit
#define dnload_SDL_ShowCursor g_symbol_table.SDL_ShowCursor
#define dnload_SDL_WaitThread g_symbol_table.SDL_WaitThread
#define dnload_SDL_CreateWindow g_symbol_table.SDL_CreateWindow
#define dnload_SDL_GL_CreateContext g_symbol_table.SDL_GL_CreateContext
#define dnload_SDL_GL_SetAttribute g_symbol_table.SDL_GL_SetAttribute
#define dnload_SDL_GL_SwapWindow g_symbol_table.SDL_GL_SwapWindow
#define dnload_SDL_LockMutex g_symbol_table.SDL_LockMutex
#define dnload_SDL_UnlockMutex g_symbol_table.SDL_UnlockMutex
#define dnload_memset g_symbol_table.memset
#define dnload_qsort g_symbol_table.qsort
#define dnload_realloc g_symbol_table.realloc
#define dnload_FT_Get_Char_Index g_symbol_table.FT_Get_Char_Index
#define dnload_FT_Init_FreeType g_symbol_table.FT_Init_FreeType
#define dnload_FT_Load_Glyph g_symbol_table.FT_Load_Glyph
#define dnload_FT_New_Face g_symbol_table.FT_New_Face
#define dnload_FT_Render_Glyph g_symbol_table.FT_Render_Glyph
#define dnload_FT_Set_Pixel_Sizes g_symbol_table.FT_Set_Pixel_Sizes
#define dnload_atan2f g_symbol_table.atan2f
#define dnload_atanf g_symbol_table.atanf
#define dnload_cosf g_symbol_table.cosf
#define dnload_fmodf g_symbol_table.fmodf
#define dnload_sinf g_symbol_table.sinf
#define dnload_sqrtf sqrtf
#define dnload_tanf g_symbol_table.tanf
/** \endcond */
/** \brief Symbol table structure.
 *
 * Contains all the symbols required for dynamic linking.
 */
static struct SymbolTableStruct
{
  void (DNLOAD_APIENTRY *glActiveTexture)(GLenum);
  void (DNLOAD_APIENTRY *glAttachShader)(GLuint, GLuint);
  void (DNLOAD_APIENTRY *glBindBuffer)(GLenum, GLuint);
  void (DNLOAD_APIENTRY *glBindFramebuffer)(GLenum, GLuint);
  void (DNLOAD_APIENTRY *glBindRenderbuffer)(GLenum, GLuint);
  void (DNLOAD_APIENTRY *glBindTexture)(GLenum, GLuint);
  void (DNLOAD_APIENTRY *glBlendFuncSeparate)(GLenum, GLenum, GLenum, GLenum);
  void (DNLOAD_APIENTRY *glBufferData)(GLenum, GLsizeiptr, const GLvoid*, GLenum);
  void (DNLOAD_APIENTRY *glClear)(GLbitfield);
  void (DNLOAD_APIENTRY *glClearColor)(GLclampf, GLclampf, GLclampf, GLclampf);
  void (DNLOAD_APIENTRY *glColorMask)(GLboolean, GLboolean, GLboolean, GLboolean);
  void (DNLOAD_APIENTRY *glCompileShader)(GLuint);
  GLuint (DNLOAD_APIENTRY *glCreateProgram)(void);
  GLuint (DNLOAD_APIENTRY *glCreateShader)(GLenum);
  void (DNLOAD_APIENTRY *glCullFace)(GLenum);
  void (DNLOAD_APIENTRY *glDeleteBuffers)(GLsizei, const GLuint*);
  void (DNLOAD_APIENTRY *glDepthFunc)(GLenum);
  void (DNLOAD_APIENTRY *glDepthMask)(GLboolean);
  void (DNLOAD_APIENTRY *glDisable)(GLenum);
  void (DNLOAD_APIENTRY *glDisableVertexAttribArray)(GLuint);
  void (DNLOAD_APIENTRY *glDrawArrays)(GLenum, GLint, GLsizei);
  void (DNLOAD_APIENTRY *glDrawElements)(GLenum, GLsizei, GLenum, const GLvoid*);
  void (DNLOAD_APIENTRY *glEnable)(GLenum);
  void (DNLOAD_APIENTRY *glEnableVertexAttribArray)(GLuint);
  void (DNLOAD_APIENTRY *glFramebufferRenderbuffer)(GLenum, GLenum, GLint, GLuint);
  void (DNLOAD_APIENTRY *glFramebufferTexture2D)(GLenum, GLenum, GLenum, GLuint, GLint);
  void (DNLOAD_APIENTRY *glGenBuffers)(GLsizei, GLuint*);
  void (DNLOAD_APIENTRY *glGenFramebuffers)(GLsizei, GLuint*);
  void (DNLOAD_APIENTRY *glGenRenderbuffers)(GLsizei, GLuint*);
  void (DNLOAD_APIENTRY *glGenTextures)(GLsizei, GLuint*);
  void (DNLOAD_APIENTRY *glGenerateMipmap)(GLenum);
  GLint (DNLOAD_APIENTRY *glGetAttribLocation)(GLuint, const GLchar*);
  GLint (DNLOAD_APIENTRY *glGetUniformLocation)(GLuint, const GLchar*);
  void (DNLOAD_APIENTRY *glLinkProgram)(GLuint);
  void (DNLOAD_APIENTRY *glPolygonOffset)(GLfloat, GLfloat);
  void (DNLOAD_APIENTRY *glRenderbufferStorage)(GLenum, GLenum, GLsizei, GLsizei);
  void (DNLOAD_APIENTRY *glShaderSource)(GLuint, GLsizei, const GLchar**, const GLint*);
  void (DNLOAD_APIENTRY *glStencilFunc)(GLenum, GLint, GLuint);
  void (DNLOAD_APIENTRY *glStencilMask)(GLuint);
  void (DNLOAD_APIENTRY *glStencilOpSeparate)(GLenum, GLenum, GLenum, GLenum);
  void (DNLOAD_APIENTRY *glTexImage2D)(GLenum, GLint, GLint, GLsizei, GLsizei, GLint, GLenum, GLenum, const GLvoid*);
  void (DNLOAD_APIENTRY *glTexParameteri)(GLenum, GLenum, GLint);
  void (DNLOAD_APIENTRY *glUniform1f)(GLint, GLfloat);
  void (DNLOAD_APIENTRY *glUniform1i)(GLint, GLint);
  void (DNLOAD_APIENTRY *glUniform2fv)(GLint, GLsizei, const GLfloat*);
  void (DNLOAD_APIENTRY *glUniform3fv)(GLint, GLsizei, const GLfloat*);
  void (DNLOAD_APIENTRY *glUniform4f)(GLint, GLfloat, GLfloat, GLfloat, GLfloat);
  void (DNLOAD_APIENTRY *glUniformMatrix3fv)(GLint, GLsizei, GLboolean, const GLfloat*);
  void (DNLOAD_APIENTRY *glUniformMatrix4fv)(GLint, GLsizei, GLboolean, const GLfloat*);
  void (DNLOAD_APIENTRY *glUseProgram)(GLuint);
  void (DNLOAD_APIENTRY *glVertexAttribPointer)(GLuint, GLint, GLenum, GLboolean, GLsizei, const GLvoid*);
  void (DNLOAD_APIENTRY *glViewport)(GLint, GLint, GLsizei, GLsizei);
  int (*SDL_CondSignal)(SDL_cond*);
  int (*SDL_CondWait)(SDL_cond*, SDL_mutex*);
  SDL_cond* (*SDL_CreateCond)(void);
  SDL_mutex* (*SDL_CreateMutex)(void);
  SDL_Thread* (*SDL_CreateThread)(int (*)(void*), const char*, void*);
  void (*SDL_Delay)(Uint32);
  void (*SDL_DestroyCond)(SDL_cond*);
  void (*SDL_DestroyMutex)(SDL_mutex*);
  uint32_t (*SDL_GetTicks)(void);
  int (*SDL_Init)(Uint32);
  int (*SDL_OpenAudio)(SDL_AudioSpec*, SDL_AudioSpec*);
  void (*SDL_PauseAudio)(int);
  int (*SDL_PollEvent)(SDL_Event*);
  void (*SDL_Quit)(void);
  int (*SDL_ShowCursor)(int);
  void (*SDL_WaitThread)(SDL_Thread*, int*);
  SDL_Window* (*SDL_CreateWindow)(const char*, int, int, int, int, Uint32);
  SDL_GLContext (*SDL_GL_CreateContext)(SDL_Window*);
  int (*SDL_GL_SetAttribute)(SDL_GLattr, int);
  void (*SDL_GL_SwapWindow)(SDL_Window*);
  int (*SDL_LockMutex)(SDL_mutex*);
  int (*SDL_UnlockMutex)(SDL_mutex*);
  void* (*memset)(void*, int, size_t);
  void (*qsort)(void*, size_t, size_t, int (*)(const void*, const void*));
  void* (*realloc)(void*, size_t);
  FT_UInt (*FT_Get_Char_Index)(FT_Face, FT_ULong);
  FT_Error (*FT_Init_FreeType)(FT_Library*);
  FT_Error (*FT_Load_Glyph)(FT_Face, FT_UInt, FT_Int32);
  FT_Error (*FT_New_Face)(FT_Library, const char*, FT_Long, FT_Face*);
  FT_Error (*FT_Render_Glyph)(FT_GlyphSlot, FT_Render_Mode);
  FT_Error (*FT_Set_Pixel_Sizes)(FT_Face, FT_UInt, FT_UInt);
  float (*atan2f)(float, float);
  float (*atanf)(float);
  float (*cosf)(float);
  float (*fmodf)(float, float);
  float (*sinf)(float);
  float (*tanf)(float);
} g_symbol_table;
#endif

#if defined(USE_LD)
/** \cond */
#define dnload()
/** \endcond */
#else
#include <dlfcn.h>
static const char g_dynstr[] = ""
"libGLESv2.so\0"
"glActiveTexture\0"
"glAttachShader\0"
"glBindBuffer\0"
"glBindFramebuffer\0"
"glBindRenderbuffer\0"
"glBindTexture\0"
"glBlendFuncSeparate\0"
"glBufferData\0"
"glClear\0"
"glClearColor\0"
"glColorMask\0"
"glCompileShader\0"
"glCreateProgram\0"
"glCreateShader\0"
"glCullFace\0"
"glDeleteBuffers\0"
"glDepthFunc\0"
"glDepthMask\0"
"glDisable\0"
"glDisableVertexAttribArray\0"
"glDrawArrays\0"
"glDrawElements\0"
"glEnable\0"
"glEnableVertexAttribArray\0"
"glFramebufferRenderbuffer\0"
"glFramebufferTexture2D\0"
"glGenBuffers\0"
"glGenFramebuffers\0"
"glGenRenderbuffers\0"
"glGenTextures\0"
"glGenerateMipmap\0"
"glGetAttribLocation\0"
"glGetUniformLocation\0"
"glLinkProgram\0"
"glPolygonOffset\0"
"glRenderbufferStorage\0"
"glShaderSource\0"
"glStencilFunc\0"
"glStencilMask\0"
"glStencilOpSeparate\0"
"glTexImage2D\0"
"glTexParameteri\0"
"glUniform1f\0"
"glUniform1i\0"
"glUniform2fv\0"
"glUniform3fv\0"
"glUniform4f\0"
"glUniformMatrix3fv\0"
"glUniformMatrix4fv\0"
"glUseProgram\0"
"glVertexAttribPointer\0"
"glViewport\0"
"\0libSDL2.so\0"
"SDL_CondSignal\0"
"SDL_CondWait\0"
"SDL_CreateCond\0"
"SDL_CreateMutex\0"
"SDL_CreateThread\0"
"SDL_Delay\0"
"SDL_DestroyCond\0"
"SDL_DestroyMutex\0"
"SDL_GetTicks\0"
"SDL_Init\0"
"SDL_OpenAudio\0"
"SDL_PauseAudio\0"
"SDL_PollEvent\0"
"SDL_Quit\0"
"SDL_ShowCursor\0"
"SDL_WaitThread\0"
"SDL_CreateWindow\0"
"SDL_GL_CreateContext\0"
"SDL_GL_SetAttribute\0"
"SDL_GL_SwapWindow\0"
"SDL_LockMutex\0"
"SDL_UnlockMutex\0"
"\0libc.so\0"
"memset\0"
"qsort\0"
"realloc\0"
"\0libfreetype.so\0"
"FT_Get_Char_Index\0"
"FT_Init_FreeType\0"
"FT_Load_Glyph\0"
"FT_New_Face\0"
"FT_Render_Glyph\0"
"FT_Set_Pixel_Sizes\0"
"\0libm.so\0"
"atan2f\0"
"atanf\0"
"cosf\0"
"fmodf\0"
"sinf\0"
"tanf\0"
"\0";
/** \brief Perform init.
 *
 * dlopen/dlsym -style.
 */
static void dnload(void)
{
  char *src = (char*)g_dynstr;
  void **dst = (void**)&g_symbol_table;
  do {
    void *handle = dlopen(src, RTLD_LAZY);
    for(;;)
    {
      while(*(src++));
      if(!*(src))
      {
        break;
      }
      *dst++ = dlsym(handle, src);
    }
  } while(*(++src));
}
#endif

#if defined(__clang__)
/** Visibility declaration for symbols that require it (clang). */
#define DNLOAD_VISIBILITY __attribute__((visibility("default")))
#else
/** Visibility declaration for symbols that require it (gcc). */
#define DNLOAD_VISIBILITY __attribute__((externally_visible,visibility("default")))
#endif

#if !defined(USE_LD)
#if defined(__cplusplus)
extern "C" {
#endif
/** Program entry point. */
void _start() DNLOAD_VISIBILITY;
#if defined(__FreeBSD__)
/** Symbol required by libc. */
void *environ DNLOAD_VISIBILITY;
/** Symbol required by libc. */
void *__progname DNLOAD_VISIBILITY;
#endif

#if defined(__cplusplus)
}
#endif
#endif

#endif
