#version 330

uniform float uTime;
uniform vec2 uRes;

uniform float uSpeed;
uniform float uMax;
uniform float uVol;

uniform sampler2D uTex5;

float rayStrength(vec2 raySource, vec2 rayRefDirection, vec2 coord, float seedA, float seedB, float speed)
{
	vec2 sourceToCoord = coord - raySource;
	float cosAngle = dot(normalize(sourceToCoord), rayRefDirection);
	
	return clamp(
		(0.45 + 0.15 * sin(cosAngle * seedA + uTime * speed)) +
		(0.3 + 0.2 * cos(-cosAngle * seedB + uTime * speed)),
		0.0, 1.0) *
		clamp((uRes.x - length(sourceToCoord)) / uRes.x, 0.5, 1.0);
}

out vec4 fragColor;

void main ( void )
{
	vec2 uv = gl_FragCoord.xy / uRes.xy;
	uv.y = 1.0 - uv.y;
	vec2 coord = vec2(gl_FragCoord.x, uRes.y - gl_FragCoord.y);
	
	// Set the parameters of the sun rays
	vec2 rayPos1 = vec2(uRes.x * 0.7, uRes.y * -0.4);
	vec2 rayRefDir1 = normalize(vec2(1.0, -0.116));
	float raySeedA1 = 36.2214;
	float raySeedB1 = 21.11349;
	float raySpeed1 = 1.5;
	
	vec2 rayPos2 = vec2(uRes.x * 0.8, uRes.y * -0.6);
	vec2 rayRefDir2 = normalize(vec2(1.0, 0.241));
	const float raySeedA2 = 22.39910;
	const float raySeedB2 = 18.0234;
	const float raySpeed2 = 1.1;
	
	// Calculate the colour of the sun rays on the current fragment
	vec4 rays1 =
		vec4(1.0, 1.0, 1.0, 1.0) *
		rayStrength(rayPos1, rayRefDir1, coord, raySeedA1, raySeedB1, raySpeed1);
	 
	vec4 rays2 =
		vec4(1.0, 1.0, 1.0, 1.0) *
		rayStrength(rayPos2, rayRefDir2, coord, raySeedA2, raySeedB2, raySpeed2);
	
	fragColor = rays1 * 0.5 + rays2 * 0.4;
	
	// Attenuate brightness towards the bottom, simulating light-loss due to depth.
	// Give the whole thing a blue-green tinge as well.
	float brightness = 1.0 - (coord.y / uRes.y);
	fragColor.x *= 0.1 + (brightness * 0.8);
	fragColor.y *= 0.3 + (brightness * 0.6);
	fragColor.z *= 0.5 + (brightness * 0.5);

	fragColor *= uVol;

	// logo

 	// calc coord
	uv = ((gl_FragCoord.xy) / uRes.xy);

	// calc fade
	float fade;
	fade = abs( sin(3.14159*(uTime/uMax)) );

	// calc pixel color
	if (uTime <= uMax)
	fragColor += texture2D( uTex5, vec2(0.0, 0.0) + (uv*1.0) ) * fade;
	else
	fragColor = vec4(0.0, 0.0, 0.0, 1.0);

}
