#version 330

uniform float uTime;
uniform vec2 uRes;
uniform float uMax;

out vec4 fragColor;

uniform sampler2D uTex0;
uniform sampler2D uTex1;
uniform sampler2D uTex2;
uniform sampler2D uTex3;
uniform sampler2D uTex4;
uniform sampler2D uTex5;
uniform sampler2D uTex6;
uniform sampler2D uTex7;


void main ( void )
{
 	// calc coord
	vec2 uv = ((gl_FragCoord.xy) / uRes.xy);

	// calc fade
	float fade;
	fade = abs( sin(3.14159*(uTime/uMax)) );

	// calc pixel color
	if ((uTime >= 0.0) && (uTime <= uMax))
		fragColor = texture2D( uTex0, vec2(0.0, 0.0) + (uv*1.0) ) * fade;

	if ((uTime >= uMax) && (uTime <= 2*uMax))
		fragColor = texture2D( uTex1, vec2(0.0, 0.0) + (uv*1.0) ) * fade;

	if ((uTime >= 2*uMax) && (uTime <= 3*uMax))
		fragColor = texture2D( uTex2, vec2(0.0, 0.0) + (uv*1.0)) * fade;

	if ((uTime >= 3*uMax) && (uTime <= 4*uMax))
		fragColor = texture2D( uTex3, vec2(0.0, 0.0) + (uv*1.0) ) * fade;

	if ((uTime >= 4*uMax) && (uTime <= 5*uMax))
		fragColor = texture2D( uTex4, vec2(0.0, 0.0) + (uv*1.0) ) * fade;

	if ((uTime >= 5*uMax) && (uTime <= 6*uMax))
		fragColor = texture2D( uTex5, vec2(0.0, 0.0) + (uv*1.0)) * fade;

	if ((uTime >= 6*uMax) && (uTime <= 7*uMax))
		fragColor = texture2D( uTex6, vec2(0.0, 0.0) + (uv*1.0)) * fade;

	if ((uTime >= 7*uMax) && (uTime <= 8*uMax))
		fragColor = texture2D( uTex7, vec2(0.0, 0.0) + (uv*1.0)) * fade;

}
