#version 330

uniform float uTime;
uniform float uVol;

uniform vec2 uRes;

uniform sampler2D uTex0;

float warsztat(vec2 uv1)
{

	return 0.0;
}

vec3 sample_back(vec2 uv1, float start, float speed, float scale, vec2 mov)
{ 
   vec2 uv = ((uv1) * 2.0) - 1.0;
   float rot = start + uTime * speed;
   mat2 m = mat2(cos(rot), -sin(rot), sin(rot), cos(rot));
   uv = m * uv;
   uv = uv + mov;
   uv = uv * scale;
   uv = (uv + 1.0) * 0.5;
   return texture2D(uTex0, uv).rrr;
}

vec3 draw_warsztat(vec3 base, vec2 uv, float col,float alpha)
{
	float v = 0.0;
	if (warsztat(uv) > 0.99) v = alpha;
	return mix(base, vec3(col), v);
}


// From https://www.shadertoy.com/view/lsf3RH

float snoise(vec3 uv, float res)
{
	const vec3 s = vec3(1e0, 1e2, 1e3);
	
	uv *= res;
	
	vec3 uv0 = floor(mod(uv, res))*s;
	vec3 uv1 = floor(mod(uv+vec3(1.), res))*s;
	
	vec3 f = fract(uv); f = f*f*(3.0-2.0*f);

	vec4 v = vec4(uv0.x+uv0.y+uv0.z, uv1.x+uv0.y+uv0.z,
		      	  uv0.x+uv1.y+uv0.z, uv1.x+uv1.y+uv0.z);

	vec4 r = fract(sin(v*1e-1)*1e3);
	float r0 = mix(mix(r.x, r.y, f.x), mix(r.z, r.w, f.x), f.y);
	
	r = fract(sin((v + uv1.z - uv0.z)*1e-1)*1e3);
	float r1 = mix(mix(r.x, r.y, f.x), mix(r.z, r.w, f.x), f.y);
	
	return mix(r0, r1, f.z)*2.-1.;
}

vec3 explosion(vec2 p)
{
	// vec2 p = -.5 + gl_FragCoord.xy / uRes.xy;
	// p.x *= uRes.x/uRes.y;
	
	float color = 3.0 - (3.*length(2.*p));
	
	vec3 coord = vec3(atan(p.x,p.y)/6.2832+.5, length(p)*.4, .5);
	
	for(int i = 1; i <= 7; i++)
	{
		float power = pow(2.0, float(i));
		color += (1.5 / power) * snoise(coord + vec3(0.,-uTime*.05, uTime*.01), power*16.);
	}
	// return vec4( color, pow(max(color,0.),2.)*0.4, pow(max(color,0.),3.)*0.15 , 1.0);
	return vec3( color, pow(max(color,0.),2.)*0.4, pow(max(color,0.),3.)*0.15);
}



// From https://www.shadertoy.com/view/MdlGWX
//Credit: http://stackoverflow.com/questions/4200224/random-noise-functions-for-glsl
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec3 blackout_noise(vec2 uv)
{
	//Fragment position, only used as random seed
	// vec2 uv = gl_FragCoord.xy / uRes.xy; 
	
	//Flicker frequency
	float flicker = 10.0;
		
	//Play with power to change noise frequency
	float freq = sin(pow(mod(uTime, flicker)+flicker, 1.9));
	
	//Play with this to change raster dot size (x axis only, y is calculated with aspect ratio)
	float pieces = float(1000);
	
	//Calculations to maintain square pixels
	float ratio_x = 1.0 / pieces;
	float ratio_y = ratio_x * uRes.x / uRes.y;
	float half_way_x = abs(freq * ratio_x);
	float half_way_y = abs(freq * ratio_y);
		
	//Comment this out to see how raster dots are simulated (noise overlay)
	// col *= vec3(rand(uv+mod(uTime, freq)), rand(uv+mod(uTime+.1, freq)), rand(uv));
		
	//Use this for greyscale noise, comment out the line above (noise overlay)
	return vec3(rand(uv+mod(uTime, freq)), rand(uv+mod(uTime, freq)), rand(uv+mod(uTime, freq)));
}


// helpers

float sawtooth(float t, float period)
{
	return mod(t, period) / period;
}


// Main

#define WHOLE_ANIM_TIME 7.0
// #define MAIN_ANIM_TIME 5.0

#define WRENCH_ANIM_START 1.0
#define WRENCH_ANIM_END   5.0

#define EXPL_ANIM_START 0.0
#define EXPL_ANIM_END   5.0

#define BLACKOUT_ANIM_START 5.0
#define BLACKOUT_ANIM_END   7.0

out vec4 fragColor;

void main (void)
{
	vec2 uv = 2.0 * (gl_FragCoord.xy / uRes.xy) - 1.0;
	uv *= vec2(uRes.x / uRes.y, -1.0);

	vec3 col = vec3(0);


	float time = mod(uTime, WHOLE_ANIM_TIME);

	if ( time > EXPL_ANIM_START && time < EXPL_ANIM_END ) {
		float expl_t = (time - EXPL_ANIM_START) / (EXPL_ANIM_END - EXPL_ANIM_START);

		vec2 explosion_uv = log(expl_t) * uv * 0.5;
		// vec2 explosion_uv = -exp(-expl_t) * uv * 5.0;
		// vec2 explosion_uv = (1.0-expl_t) * uv * 5.0;
		col += explosion(explosion_uv);
	}

	if ( time > WRENCH_ANIM_START && time < WRENCH_ANIM_END ) {
		float wrench_t = (time - WRENCH_ANIM_START) / (WRENCH_ANIM_END - WRENCH_ANIM_START);

		vec2 warsztat_uv = uv;
		// warsztat_uv *= (sin(uTime*2.2+0.3)*0.1)+1.0;
		warsztat_uv = (1.0-wrench_t) * uv * 100.0; // (sin(uTime*2.2+0.3)*0.1)+1.0;

		// uv += 1.0;
		// uv *= 0.5;

		// You spin me right round, baby, right round...
		float rot_angle = wrench_t * 4.0;
		warsztat_uv *= mat2(sin(rot_angle), cos(rot_angle), cos(rot_angle), -sin(rot_angle));
		
		warsztat_uv += 1.0;
		warsztat_uv *= 0.5;
		
		float uvm = 1.0 / 26.0;
		
		col = draw_warsztat(col, warsztat_uv + vec2(-uvm*0.0, -uvm * 2.0), 0.0, 0.5);
		col = draw_warsztat(col, warsztat_uv - vec2(uvm, 0.0), 160.0/255.0, 1.0);
		col = draw_warsztat(col, warsztat_uv - vec2(-uvm, 0.0), 160.0/255.0, 1.0);
		col = draw_warsztat(col, warsztat_uv - vec2(0.0, uvm), 160.0/255.0, 1.0);
		col = draw_warsztat(col, warsztat_uv - vec2(0.0, -uvm), 160.0/255.0, 1.0);
		col = draw_warsztat(col, warsztat_uv, 80.0/255.0, 1.0);
	}

	if ( time > BLACKOUT_ANIM_START && time < BLACKOUT_ANIM_END ) {
		col = blackout_noise(uv);
	}

	fragColor = vec4(vec3(col), 1.0);
}
