var Kaleidoscope = function () {

    "use strict";

    var START_ANGLE = 0,
        PARTS = 1,
        _ctx,
        _bcxt,
        _width,
        _height;

    function setContext(ctx) {

        _ctx = ctx;

        _width = _ctx.canvas.width;
        _height = _ctx.canvas.height;

        var canvas = document.createElement('canvas');
        canvas.width = _width;
        canvas.height = _height;
        _bcxt = canvas.getContext('2d');
    }

    function buffer(x, y, width, height) {

        _bcxt.clearRect(0, 0, _bcxt.canvas.width, _bcxt.canvas.height);
        /*
         _bcxt.width = width;
         _bcxt.height = height;
         */
        _bcxt.drawImage(_ctx.canvas, x, y, width, height, 0, 0, width, height);
    }

    //mirrors right part to the left
    function mirrorAtY(x) {

        //save buffer
        buffer(x, 0, _width - x, _height);
        /*
        _bcxt.clearRect(0, 0, _width, _height);
        _bcxt.drawImage(_ctx.canvas, x, 0, _width - x, _height);//, 0, 0, _width - x, _height);
        */
        //clear part of mirror
        _ctx.clearRect(0, 0, x, _height);

        //mirror
        _ctx.save();
        _ctx.translate(x, 0);
        _ctx.scale(-1, 1);
        _ctx.drawImage(_bcxt.canvas, 0, 0, _width, _height);
        _ctx.restore();
    }

    function rotate(angle) {

        //save buffer
        _bcxt.clearRect(0, 0, _bcxt.canvas.width, _bcxt.canvas.height);
        _bcxt.drawImage(_ctx.canvas, 0, 0, _width, _height, 0, 0, _width, _height);

        //clear part of mirror
        _ctx.clearRect(0, 0, _width, _height);

        //mirror
        _ctx.save();
        _ctx.translate((_width / 2),( _height / 2));
        _ctx.rotate(Math.PI * angle / 180);
        _ctx.translate(-(_width / 2), -(_height / 2));

        _ctx.drawImage(_bcxt.canvas, 0, 0);
        _ctx.restore();
    }

    function render() {
        if(PARTS === 0){
            rotate(START_ANGLE);
            return;
        }
            
        for (var i = 0; i < 180; i += (180 / PARTS)) {
            rotate(START_ANGLE + i);
            mirrorAtY(_width / 2);
            rotate((START_ANGLE + i) * -1);
        }
    }

    function setAngle(newAngle){
        if(START_ANGLE == newAngle)
            return;

        START_ANGLE = newAngle;
    }
    
    function getAngle(newAngle){
        return START_ANGLE;
    }

    function setParts(newParts){
        if(PARTS == newParts)
            return;

        PARTS = Math.max(Math.round(newParts), 0);
    }

    function getParts(newParts){
        return PARTS;
    }
    
    return {
        render    :render,
        setContext:setContext,
        setAngle:setAngle,
        getAngle:getAngle,
        setParts:setParts,
        getParts:getParts
    };
};