var Valo = function(){
    PartBase.call(this);
    this.arrange = false;
    this.texture = TDEMO.TEXTURES.getTextures().satellite;
    //this.setDoF();
    this.setBloom(0.5);
    var ambientLight = new THREE.AmbientLight(0xffffff);
    this.scene.add(ambientLight);
    this.createSky();
    this.scene.fog = new THREE.Fog(0x800000, this.near, this.far);

//    this.addCat();
//    this.createBoxes();
    this.createBoxMat();

    this.lightTarget = new THREE.Object3D();
    this.lightTarget.position.set(0, 0, 0);

    this.lightTarget2 = this.lightTarget.clone();

    this.light1 = createLight(0xff0000, this.lightTarget);
    this.light1.position.set( 0, 550, 850 );
    this.scene.add(this.light1);

    this.light2 = createLight(0x0000ff, this.lightTarget2);
    this.light2.position.set( 300, -550, 750 );
    this.scene.add(this.light2);

    this.light3 = createLight(0xff6000, this.lightTarget);
    this.light3.position.set( -1000, 0, -200 );
    this.scene.add(this.light3);

    this.light4 = createLight(0x00ffdd, this.lightTarget2);
    this.light4.position.set( 1000, 600, -600 );
    this.scene.add(this.light4);

};

Valo.prototype = PartBase.prototype.inheritance();

Valo.prototype.prepare = function(){
    PartBase.prototype.prepare.call(this);
};

Valo.prototype.finish = function(){
   PartBase.prototype.finish.call(this);
};


Valo.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta);

    var objrot = TDEMO.SYNC.getObjRotation();
    var objpos = TDEMO.SYNC.getObjPosition();
    var targetpos = TDEMO.SYNC.getLightTarget();
    var beat = TDEMO.SYNC.getHeartBeat();


    this.lightTarget.position.x = targetpos.x;
    this.lightTarget.position.y = targetpos.y;
    this.lightTarget.position.z = targetpos.z;

    this.lightTarget2.position.x = targetpos.x*-1;
    this.lightTarget2.position.y = targetpos.y;
    this.lightTarget2.position.z = targetpos.z*-1;

    this.lightTarget.updateMatrixWorld();
    this.lightTarget2.updateMatrixWorld();

    this.boxmat.rotation.y += delta;
    this.boxmat.rotation.x = objrot.x;
    this.boxmat.rotation.z = objrot.z;

    this.boxmat.position.y += objpos.y;
    this.boxmat.position.x = objpos.x;
    this.boxmat.position.z = objpos.z;

    this.texture.offset.x += delta*objrot.y;
    this.texture.offset.y += delta*objrot.y;

    this.texture.needsUpdate = true;

    if(beat === 5.0) {
        this.sinMat(elapsedTime, delta);
    }

    if(beat === 6.0 ) {
        this.anotherMat(elapsedTime, delta);
    }

    if(beat>0 && beat<5) {
      this.beat(beat);
    }



    if(this.arrange && (beat < 5) ) {
        this.arrangeMat();
    }
};


Valo.prototype.beat = function(beat) {
    for (var i=0; i < this.boxArr.length; i++) {
        for (var j = 0; j < this.boxArr[i].length; j++) {
          var b = this.boxArr[i][j];
          b.scale.set(beat, beat, beat);
        }
    }
};

Valo.prototype.sinMat = function(elapsedTime, delta) {
    for (var i=0; i < this.boxArr.length; i++) {
        for (var j = 0; j < this.boxArr[i].length; j++) {
          var b = this.boxArr[i][j];
          b.position.y = (Math.sin(elapsedTime)*(b.position.z*2+2)+Math.cos(elapsedTime)*(2*b.position.x-2));
        }
    }

    this.arrange = true;
};


Valo.prototype.anotherMat = function(elapsedTime, delta) {
  for (var i = 0; i<this.boxArr.length; i++) {
    for (var j = 0; j<this.boxArr[i].length; j++) {
      if(i%2===0 && j%2 === 0) {
        var b = this.boxArr[i][j];
        b.position.y = (Math.sin(elapsedTime)+Math.cos(elapsedTime))*100  ;
      }
    }
  }

  this.arrange = true;
};

Valo.prototype.arrangeMat = function() {
  for (var i = 0; i<this.boxArr.length; i++) {
    for (var j = 0; j<this.boxArr[i].length; j++) {
        var b = this.boxArr[i][j];
        b.position.y = 0;
    }
  }

  this.arrange = false;
};


Valo.prototype.createBoxes = function() {
    var geometry = new THREE.BoxGeometry(150, 150, 150);
    this.material = new THREE.MeshPhongMaterial({
        color : 0x000000
    });


    this.testbox = new THREE.Mesh(geometry, this.material);
    this.scene.add(this.testbox);
    this.testbox.position.set(-400, 0, 200);

    this.box2 = new THREE.Mesh(geometry, this.material);
    this.box2.position.x = 400;
    this.scene.add(this.box2);

    this.box3 = new THREE.Mesh(geometry, this.material);
    this.box3.position.set(-400, 100, -200);
    this.scene.add(this.box3);
};


Valo.prototype.createBoxMat = function() {

    var sijx = -400;
    var sijz = -400;

    var geometry = new THREE.BoxGeometry(100, 100, 100);
    var material = new THREE.MeshPhongMaterial({
        color : 0x000000
    });

    this.boxmat = new THREE.Object3D();
    var box = new THREE.Mesh(geometry, material);
    box.position.set(sijx, 0, sijz);
    this.boxmat.add(box);

    //this.boxArr[0].push(box);
    this.boxArr = [[box]];



    for (var i = 0; i<6; i++) {
      var sijz = -400;
      if(i>0) {
        this.boxArr.push([]);
      }
      for (var j = 0; j < 6; j++) {
        if(i>0 || j>0) {
          var b = box.clone();
          box.position.set(sijx, 0, sijz);
          this.boxmat.add(b);
          this.boxArr[i].push(b);
          sijz += 200;
        }
      }

      sijx += 200;
    }

    this.boxmat.rotation.x = -Math.PI/4;
    this.scene.add(this.boxmat);
};


Valo.prototype.addCat = function() {
    this.cat = cat(0x000000);
    this.scene.add(this.cat);
    this.cat.position.set(0,0,0);
    this.cat.scale.set(7,7,7);
};


Valo.prototype.createSky = function(){
    //this.texture = TDEMO.TEXTURES.getTextures().satellite;
    var geometry = new THREE.SphereGeometry(600, 64, 64);
    var material = new THREE.MeshPhongMaterial({
        color: 0xffffff,
        map : this.texture,
        side : THREE.BackSide
    });

    this.sky = new THREE.Mesh(geometry, material);
    this.scene.add(this.sky);
    return this.sky;
};

var createLight = function( color , target) {
    var spotLight = new THREE.SpotLight(color);

    spotLight.angle = 0.4;
    spotLight.intensity = 0.7;
    spotLight.penumbra = 0.1;

    spotLight.target = target;

    return spotLight;
};
