var Tunneli = function(){
    PartBase.call(this);

    //POSTPROCESSING
    this.setBloom(0.1);

    this.scene.fog = new THREE.Fog(0x800000, this.near, this.far*0.75);

    this.texture = TDEMO.TEXTURES.getTextures().laakkeet;

    this.putki = this.createScene(this.texture);
    this.scene.add(this.putki);
};

Tunneli.prototype = PartBase.prototype.inheritance();

Tunneli.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta);
    this.texture.offset.y -= delta*0.25;
    this.texture.offset.y %= 1;

    this.texture.offset.x += delta*0.5;
    this.texture.offset.x %= 4;

    this.texture.needsUpdate = true;
};

Tunneli.prototype.createScene = function(map){
    var geometry = new THREE.CylinderGeometry(20, 20, 800, 124, 50, true);
    var material = new THREE.MeshBasicMaterial({
        map : map,
        side : THREE.BackSide
    });

    var putki = new THREE.Mesh(geometry, material);
    putki.rotation.x = Math.PI/2;

    return putki;
}
