var Lanka = function(){
    PartBase.call(this);

    //POSTPROCESSING
    //this.setEdgeDetection();
    this.setBloom(0.5);
    this.setDoF();
    //this.scene.fog = new THREE.Fog(0xf0f0f0, this.near, this.far);

    //VIDEO TEXTURE
    this.video = document.getElementById( 'lanka' );
    this.texture = new THREE.VideoTexture(this.video);
    this.texture.minFilter = THREE.LinearFilter;
    this.texture.magFilter = THREE.LinearFilter;
    this.texture.format = THREE.RGBFormat;


    var ambientLight = new THREE.AmbientLight(0xffffff);
    this.scene.add(ambientLight);
    this.createSky();
    //GEOMETRY
    var geometry = new THREE.PlaneGeometry(1000, 600);
    var material = new THREE.MeshBasicMaterial({
        map : this.texture,
        color : 0xffffff
    });

    var display = new THREE.Mesh(geometry, material);
    //this.scene.add(display);
    //display.rotation.y = Math.PI/4;
 
    var sphgeom = new THREE.SphereGeometry(200, 64, 64);
    var sph1 = new THREE.Mesh(sphgeom, material);
    //this.scene.add(sph1);
    
    var bgeom = new THREE.BoxGeometry(400, 400, 400);
    this.b1 = new THREE.Mesh(bgeom, material);
    this.scene.add(this.b1);
    //b1.rotation.set(Math.PI/4, Math.PI/5, Math.PI/3);
    

    
    //sph2 = sph1.clone();
    //this.scene.add(sph2);
    //sph2.position.set(-300, 50, -20);
    sph1.position.set(300, 50, -20);   
    //var ds2 = display.clone();
    //ds2.position.x += 400;
    //console.log(display.position.x + " " + display.position.y + " "+ display.position.z);
};

Lanka.prototype = PartBase.prototype.inheritance();

Lanka.prototype.prepare = function(){
    PartBase.prototype.prepare.call(this);
    this.video.currentTime = 0;
    this.video.play();
    //console.log("Lankavideo!");
};

Lanka.prototype.finish = function(){
   PartBase.prototype.finish.call(this);
   this.video.pause();
};

Lanka.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta);

    var objrot = TDEMO.SYNC.getObjRotation();
    var objpos = TDEMO.SYNC.getObjPosition();
    this.b1.rotation.x = objrot.x;
    this.b1.rotation.y = objrot.y;
    this.b1.rotation.z = objrot.z;
    
    this.texture2.offset.x += delta*0.5;
    this.texture2.offset.y += delta*0.5;

    this.texture2.needsUpdate = true;

};



Lanka.prototype.createSky = function(){
    this.texture2 = TDEMO.TEXTURES.getTextures().valot;
    var geometry = new THREE.SphereGeometry(600, 64, 64);
    var material2 = new THREE.MeshPhongMaterial({
        color: 0x0000ff,
        map : this.texture2,
        side : THREE.BackSide
    });
    
    var sky = new THREE.Mesh(geometry, material2);
    this.scene.add(sky);
    return sky;
};
