#!/bin/bash

# VERSION 1.0
# Codename "Now with ∞ more hugs"

if [[ ( $1 == "" ) || ( $# != 2 ) || ( $1 == "-h" ) || ( $1 == "--help" ) ]]; then
    echo -e "   -h or --help \nShow this help message.\n";
    echo -e "Usage: [scriptName] [set alarm in 24 hour format] [path to file]";
    echo -e "Example: ./alarm.sh 13:00 ~/alarmaudio.ogg";
    exit 0;
fi

curTime="`date +%k:%M`"
audioFile=$2
alarm=$1

if [[ "$alarm" =~ ^[0-2][0-9]\:[0-5][0-9]$ ]]; then
    echo "Time now $curTime"
    echo "Alarm set to $alarm"
    echo "Will play $audioFile"
else
    echo "Invalid time format :c"
    exit 0;
fi

while [[ $curTime != $alarm ]]; do
    curTime="`date +%k:%M`"
    sleep 2
done

if [ $curTime = $alarm ]; then
    echo $curTime
    echo "Time to wake up - you need to make a useful utility!"
    cvlc $audioFile
fi

exit 0
