package com.petterroea.neural;

import java.util.LinkedList;

public class OutputNode implements INode{
	
	private INode input = null;
	
	public OutputNode()
	{
		
	}

	@Override
	public boolean canConnectInput() {
		return input == null;
	}

	@Override
	public void connectInput(INode n) {
		if(canConnectInput())
		{
			input = n;
		}
	}

	@Override
	public void disconnectInput(INode n) {
		if(n.equals(input)) {
			input = null;
		}
	}

	@Override
	public boolean canSimulate() {
		// TODO Auto-generated method stub
		return input != null && input.hasSimulated();
	}

	@Override
	public void simulate() {
		//Nothing really
	}

	@Override
	public boolean hasSimulated() {
		return input != null && input.hasSimulated();
	}

	@Override
	public void connectOutput(INode n) {
		
	}

	@Override
	public boolean canConnectOutput() {
		return false;
	}

	@Override
	public void disconnectOutput(INode n) {
	}

	@Override
	public float getOutput() {
		return input.getOutput();
	}

	@Override
	public void reset() {
		input = null;
	}

	@Override
	public int getNeededInputs() {
		return input == null ? 1 : 0;
	}

	@Override
	public int getNeededOutputs() {
		return 0;
	}

}
