package com.petterroea.kartering.math;

import java.util.LinkedList;

public class AnalysisAStar {
	private LinkedList<AStarRoute> cachedRoutes = new LinkedList<AStarRoute>();
	private byte DIRECTION_UP = 0;
	private byte DIRECTION_DOWN = 1;
	private byte DIRECTION_LEFT = 2;
	private byte DIRECTION_RIGHT = 3;
	/**
	 * Map should be TRUE if not passablee...
	 * @param map
	 * @param mapWidth
	 * @param start
	 * @param end
	 * @return
	 */
	public AStarRoute getRoute(boolean[] map, int mapWidth, IntVect start, IntVect end)
	{
		for(int i = 0; i < cachedRoutes.size(); i++)
		{
			if(cachedRoutes.get(i).getStart().equals(start)&&cachedRoutes.get(i).getEnd().equals(end))
				return cachedRoutes.get(i);
		}
		//Step 1 Iterate through map until we find the goal, and make a "heatmap"
		short[] heatmap = getHeatmap(map, mapWidth, start, end);
		if(heatmap==null) { /*LogUtils.logDebug("Got no heatmap! ");*/ return null; }
		//Step 2: Start at the end position, and iterate through until we find the end.
		int xPos = end.getX(); //Here, we set start position for this algoritm
		int yPos = end.getY(); //The start position is our wanted target.
		//Here we store where we have been
		LinkedList<IntVect> route = new LinkedList<IntVect>();
		while(true)
		{
			route.add(new IntVect(xPos, yPos));
			if(xPos==start.getX()&&yPos==start.getY())
			{
				//We are home!
				IntVect[] routeData = new IntVect[route.size()];
				for(int i = 0; i < route.size(); i++)
				{
					routeData[i] = route.get(route.size()-1-i);
				}
				return new AStarRoute(routeData);
			}
			short posAt = heatmap[xPos+(yPos*mapWidth)];
			short smallestNeighbour = posAt;
			
			//Store coordinates in array, so code looks cleaner.
			int topCoord = xPos+((yPos-1)*mapWidth);
			int botCoord = xPos+((yPos+1)*mapWidth);
			int leftCoord = xPos-1+(yPos*mapWidth);
			int rightCoord = xPos+1+(yPos*mapWidth);
			
			/*if(yPos>0) { com.petterroea.util.LogUtils.logDebug("Top value: " + heatmap[topCoord]); } else { com.petterroea.util.LogUtils.logDebug("Top value: OOR!"); }
			if(yPos<(map.length/mapWidth)-1) { com.petterroea.util.LogUtils.logDebug("Bottom value: " + heatmap[botCoord]); } else { com.petterroea.util.LogUtils.logDebug("Bottom value: OOR!"); }
			if(xPos>0) { com.petterroea.util.LogUtils.logDebug("Left value: " + heatmap[leftCoord]); } else { com.petterroea.util.LogUtils.logDebug("Left value: OOR!"); }
			if(yPos<mapWidth-1) { com.petterroea.util.LogUtils.logDebug("Right value: " + heatmap[rightCoord]); } else { com.petterroea.util.LogUtils.logDebug("Right value: OOR!"); } */
			//Find neighbour with lowest height num
			LinkedList<Byte> places = new LinkedList<Byte>();
			//Check top
			if(yPos>0&&!map[topCoord])
			{
				if(heatmap[topCoord]<smallestNeighbour&&heatmap[topCoord]!=-1)
				{
					places.clear();
					places.add(DIRECTION_UP);
					smallestNeighbour = heatmap[topCoord];
				}
				else if(heatmap[topCoord]==smallestNeighbour)
				{
					places.add(DIRECTION_UP);
				}
			}
			//Check Bottom
			if(yPos>0&&!map[botCoord])
			{
				if(heatmap[botCoord]<smallestNeighbour&&heatmap[botCoord]!=-1)
				{
					places.clear();
					places.add(DIRECTION_DOWN);
					smallestNeighbour = heatmap[botCoord];
				}
				else if(heatmap[botCoord]==smallestNeighbour)
				{
					places.add(DIRECTION_DOWN);
				}
			}
			//Check left
			if(yPos>0&&!map[leftCoord])
			{
				if(heatmap[leftCoord]<smallestNeighbour&&heatmap[leftCoord]!=-1)
				{
					places.clear();
					places.add(DIRECTION_LEFT);
					smallestNeighbour = heatmap[leftCoord];
				}
				else if(heatmap[leftCoord]==smallestNeighbour)
				{
					places.add(DIRECTION_LEFT);
				}
			}
			//Check right
			if(yPos>0&&!map[rightCoord])
			{
				if(heatmap[rightCoord]<smallestNeighbour&&heatmap[rightCoord]!=-1)
				{
					places.clear();
					places.add(DIRECTION_RIGHT);
					smallestNeighbour = heatmap[rightCoord];
				}
				else if(heatmap[rightCoord]==smallestNeighbour)
				{
					places.add(DIRECTION_RIGHT);
				}
			}
			/*
			//Check top
			if(yPos>0&&
					!map[topCoord]&&
					heatmap[topCoord]<smallestNeighbour&&
					heatmap[topCoord]!=-1)
			{
				smallestNeighbour = heatmap[topCoord];
				directionFlag = DIRECTION_UP;
				com.petterroea.util.LogUtils.logDebug("Going up!" + smallestNeighbour);
			}
			//Check bottom
			System.out.println(!map[botCoord]);
			if(yPos<(map.length/mapWidth)-1&&
					!map[botCoord]&&
					heatmap[botCoord]<smallestNeighbour&&
					heatmap[botCoord]!=-1)
			{
				smallestNeighbour = heatmap[botCoord];
				directionFlag = DIRECTION_DOWN;
				com.petterroea.util.LogUtils.logDebug("Going down!" + smallestNeighbour);
			}
			//Check left
			if(xPos>0&&
					!map[leftCoord]&&
					heatmap[leftCoord]<smallestNeighbour&&
					heatmap[leftCoord]!=-1)
			{
				smallestNeighbour = heatmap[leftCoord];
				directionFlag = DIRECTION_LEFT;
				com.petterroea.util.LogUtils.logDebug("Going left!" + smallestNeighbour);
			}
			if(xPos<mapWidth-1&&
					!map[rightCoord]&&
					heatmap[rightCoord]<smallestNeighbour&&
					heatmap[rightCoord]!=-1)
			{
				smallestNeighbour = heatmap[rightCoord];
				directionFlag = DIRECTION_RIGHT;
				com.petterroea.util.LogUtils.logDebug("Going right!" + smallestNeighbour);
			}*/
			//Move position relative to new direction
			if(places.size()==0) return null;
			byte directionFlag = places.get((xPos+(yPos*mapWidth)+(int)(System.currentTimeMillis()/10000L))%places.size());
			if(directionFlag==DIRECTION_UP) yPos--;
			if(directionFlag==DIRECTION_DOWN) yPos++;
			if(directionFlag==DIRECTION_LEFT) xPos--;
			if(directionFlag==DIRECTION_RIGHT) xPos++;
		}
	}
	private short[] getHeatmap(boolean[] map, int mapWidth, IntVect start, IntVect end)
	{
		short[] heatmap = new short[map.length]; //Initialize heatmap array
		int[] pointCache = new int[map.length*2]; //We store points to be checked in next iteration here
		for(int i = 0; i < heatmap.length; i++)
		{
			heatmap[i] = -1;
		}
		int cacheSize = 1; //Store how many fields of the cache we are using
		
		//Put start position as checkable value
		pointCache[0] = start.getX();
		pointCache[1] = start.getY();
		heatmap[start.getX()+(start.getY()*mapWidth)] = 1;
		//Iteration loop
		while(cacheSize!=0)
		{
			//Temp storage for points
			int[] newPointCache = new int[map.length*2];
			int newCacheSize = 0;
			for(int i = 0; i < cacheSize; i++)
			{
				int xCoord = pointCache[(i*2)+0];
				int yCoord = pointCache[(i*2)+1];
				short val = heatmap[xCoord+(yCoord*mapWidth)];
				//Cache coord thingies
				int topCoord = xCoord + ((yCoord-1)*mapWidth);
				int bottomCoord = xCoord + ((yCoord+1)*mapWidth);
				int leftCoord = xCoord-1+(yCoord*mapWidth);
				int rightCoord = xCoord+1+(yCoord*mapWidth);
				/*
				 * Checks if neighbour tiles can be checked, if they are solid or not, or if the cells heatmap is not set or is higher then we want it to be.
				 */
				if(xCoord==end.getX()&&yCoord==end.getY())
				{
					for(int a = 0; a < heatmap.length; a++)
					{
						String s = heatmap[a] + "";
						if(s.length()==1)
						{
							System.out.print(" " + heatmap[a]+", ");
						}
						else
						{
							System.out.print(heatmap[a]+", ");
						}
						if(a%mapWidth==mapWidth-1)
						{
							System.out.println();
						}
					}
					return heatmap;
				}
				//Top
				if(yCoord>0&&(heatmap[topCoord]>val+1||heatmap[topCoord]==-1)&&!map[topCoord])
				{
					//If the cell above should be added, add it.
					heatmap[topCoord] = (short) (val+1);
					newPointCache[(newCacheSize*2)+0] = xCoord;
					newPointCache[(newCacheSize*2)+1] = (byte) (yCoord-1);
					newCacheSize++;
				}
				//Bot
				if(yCoord<(map.length/mapWidth)-1&&(heatmap[bottomCoord]>val+1||heatmap[bottomCoord]==-1)&&!map[bottomCoord])
				{
					//If the cell above should be added, add it.
					heatmap[bottomCoord] = (short) (val+1);
					newPointCache[(newCacheSize*2)+0] = xCoord;
					newPointCache[(newCacheSize*2)+1] = (byte) (yCoord+1);
					newCacheSize++;
				}
				//Left
				if(xCoord>0&&(heatmap[leftCoord]>val+1||heatmap[leftCoord]==-1)&&!map[leftCoord])
				{
					heatmap[leftCoord] = (short) (val+1);
					newPointCache[(newCacheSize*2)+0] = (byte) (xCoord-1);
					newPointCache[(newCacheSize*2)+1] = yCoord;
					newCacheSize++;
				}
				//Right
				if(xCoord<mapWidth-1&&(heatmap[rightCoord]>val+1||heatmap[rightCoord]==-1)&&!map[rightCoord])
				{
					heatmap[rightCoord] = (short) (val+1);
					newPointCache[(newCacheSize*2)+0] = (byte) (xCoord+1);
					newPointCache[(newCacheSize*2)+1] = yCoord;
					newCacheSize++;
				}
			}
			pointCache = newPointCache;
			cacheSize = newCacheSize;
		}
		return null;
	}
	public void newTurn()
	{
		cachedRoutes.clear();
	}
	public void newRound()
	{
		newTurn();
	}
}
