package com.petterroea.kartering;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.petterroea.kartering.map.MatchData;
import com.petterroea.kartering.map.Tile;
import com.petterroea.kartering.math.FloatVect;
import com.petterroea.kartering.math.IntVect;
import com.petterroea.kartering.abstraction.IServer;

public class NetworkManager implements IServer{
	private Socket client;
    private BufferedReader reader;
    private PrintWriter writer;
    private OutputStream outStream;
    private byte[] data = new byte[256];
    private InetSocketAddress endPoint;
    
	public NetworkManager(String ip, int port, String name)
	{
		try 
		{
			client = new Socket();
	        endPoint = new InetSocketAddress(ip, port);
	        client.connect(endPoint);
	        reader = new BufferedReader(new InputStreamReader(client.getInputStream()));
	        outStream = client.getOutputStream();
	        writer = new PrintWriter(outStream, true);
	        send(name);
		}
		catch(Exception e)
		{
			System.out.println("There was an error!");
			e.printStackTrace();
		}
	}
	public boolean Connected() {
        return client.isConnected() && !client.isClosed() && !writer.checkError();
    }
	public void send(String data)
	{
		System.out.println("OUT: " + data);
		writer.println(data);
		writer.flush();
	}
	public void sendByte(int b) {
		System.out.println("OUT: " + b);
		//try {
			/*outStream.write(0);
			outStream.write(b);
			outStream.write((short)'\n');
			outStream.flush();*/
			send(b+"");
		/*} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			System.exit(0);*/
		//}
	}
	public String readLine()
	{
		try
		{
			StringBuilder b = new StringBuilder();
			while(true) {
				//System.out.print(reader.read() + ", ");
				char c = (char)reader.read();
				//System.out.print((int)c + ", ");
				if(c != '\n') {
					b.append(c);
				} else {
					System.out.println();
					break;
				}
			}
			String l = b.toString();
			System.out.println("IN: "+l);
			return l;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.exit(0);
			return "";
		}
	}
	public MatchData getMapData()
	{
		String line = readLine();
		JsonObject mapData = JsonObject.readFrom(line);
		JsonObject map = mapData.get("map").asObject();
		//Values
		int selfId = mapData.get("id").asInt();
		int tileWidth = map.get("tile_width").asInt();
		int tileHeight = map.get("tile_height").asInt();
		JsonArray tileArray = map.get("tiles").asArray();
		int mapHeight = tileArray.size();
		int mapWidth = tileArray.get(0).asArray().size();
		Tile[] tiles = new Tile[mapWidth*mapHeight];
		for(int y = 0; y < tileArray.size(); y++)
		{
			JsonArray row = tileArray.get(y).asArray();
			for(int x = 0; x < row.size(); x++)
			{
				tiles[x+(y*mapWidth)] = new Tile(row.get(x).asString()); //http://puu.sh/gXAkf/e5cb4bacd9.odp
			}
		}
		JsonArray modifierList = map.get("modifiers").asArray();
		Modifier[] modifiers = new Modifier[modifierList.size()];
		for(int i = 0; i < modifierList.size(); i++)
		{
			JsonObject modifierObject = modifierList.get(i).asObject();
			modifiers[i] = new Modifier(modifierObject.get("type").asString(), new FloatVect(modifierObject.get("x").asFloat(), modifierObject.get("y").asFloat()), new FloatVect(modifierObject.get("width").asFloat(), modifierObject.get("height").asFloat()));
		}
		JsonArray pathList = map.get("path").asArray();
		IntVect[] path = new IntVect[pathList.size()];
		for(int i = 0; i < pathList.size(); i++)
		{
			JsonObject point = pathList.get(i).asObject();
			path[i] = new IntVect(point.get("tile_x").asInt(), point.get("tile_y").asInt());
		}
		return new MatchData(selfId, tileWidth, tileHeight, mapWidth, mapHeight, tiles, modifiers, path);
	}
	public GameState getGameState()
	{
		String line = readLine();
		JsonObject stateData = JsonObject.readFrom(line);
		JsonArray carList = stateData.get("cars").asArray();
		Car[] cars = new Car[carList.size()];
		for(int i = 0; i < cars.length; i++)
		{
			JsonObject carObject = carList.get(i).asObject();
			int id = carObject.get("id").asInt();
			JsonObject directionObject = carObject.get("direction").asObject();
			FloatVect direction = new FloatVect(directionObject.get("x").asFloat(), directionObject.get("y").asFloat());
			JsonObject velocityObject = carObject.get("velocity").asObject();
			FloatVect velocity = new FloatVect(velocityObject.get("x").asFloat(), velocityObject.get("y").asFloat());
			JsonObject positionObject = carObject.get("pos").asObject();
			FloatVect position = new FloatVect(positionObject.get("x").asFloat(), positionObject.get("y").asFloat());
			boolean drifting = carObject.get("drift").asInt() == 1;
			int width = carObject.get("width").asInt();
			int height = carObject.get("height").asInt();
			cars[i] = new Car(id, direction, velocity, position, width, height, drifting);
		}
		JsonArray shellList = stateData.get("shells").asArray();
		Shell[] shells = new Shell[shellList.size()];
		for(int i = 0; i < shells.length; i++)
		{
			JsonObject shellObject = shellList.get(i).asObject();
			String type = shellObject.get("type").asString();
			FloatVect position = new FloatVect(shellObject.get("x").asFloat(), shellObject.get("y").asFloat());
			FloatVect velocity = new FloatVect(shellObject.get("dx").asFloat(), shellObject.get("dy").asFloat());
			shells[i] = new Shell(type, position, velocity);
		}
		JsonArray boxList = stateData.get("boxes").asArray();
		Box[] boxes = new Box[boxList.size()];
		for(int i = 0; i < boxes.length; i++)
		{
			JsonObject boxObject = boxList.get(i).asObject();
			FloatVect position = new FloatVect(boxObject.get("x").asFloat(), boxObject.get("y").asFloat());
			FloatVect size = new FloatVect(boxObject.get("width").asFloat(), boxObject.get("height").asFloat());
			boxes[i] = new Box(position, size);
		}
		JsonArray itemList = stateData.get("items").asArray();
		Item[] items = new Item[itemList.size()];
		for(int i = 0; i < items.length; i++)
		{
			JsonObject itemObject = itemList.get(i).asObject();
			String type = itemObject.get("type").asString();
			FloatVect position = new FloatVect(itemObject.get("x").asFloat(), itemObject.get("y").asFloat());
			FloatVect size = new FloatVect(itemObject.get("width").asFloat(), itemObject.get("height").asFloat());
			items[i] = new Item(type, position, size);
		}
		return new GameState(cars, shells, boxes, items);
	}
	
}
