package com.petterroea.kartering;

import com.petterroea.kartering.map.*;
import com.petterroea.kartering.math.*;

public class GameState {
	private Car[] cars;
	private Shell[] shells;
	private Box[] boxes;
	private Item[] items;
	public GameState(Car[] cars, Shell[] shells, Box[] boxes, Item[] items)
	{
		this.cars = cars;
		this.shells = shells;
		this.boxes = boxes;
		this.items = items;
	}
	public Car[] getCars()
	{
		return cars;
	}
	public Car getCar(int id)
	{
		return cars[id];
	}
	public Shell[] getShells()
	{
		return shells;
	}
	public Shell getShell(int id)
	{
		return shells[id];
	}
	public Box[] getBoxes()
	{
		return boxes;
	}
	public Box getBox(int id)
	{
		return boxes[id];
	}
	public Item[] getItems()
	{
		return items;
	}
	public Item getItem(int id)
	{
		return items[id];
	}
	public Car getMyCar(MatchData data) {
		return cars[data.getSelfId()];
	}
	public IntVect getTileCoord(IntVect coord, MatchData data) {
		return new IntVect(coord.getX()/data.getTileWidth(), coord.getY()/data.getTileHeight());
	}
	public int getCheckpoint(MatchData data) {
		FloatVect myPos = getMyCar(data).getPosition();
		IntVect tile = getTileCoord(myPos.toIntVect(), data);
		for(int i = 0; i < data.getPath().length; i++) {
			IntVect v = data.getPath()[i];
			if(v.getX() == tile.getX() && v.getY() == tile.getY())
			{
				return i;
			}
		}
		return -1;
	}
	public FloatVect getCheckpointVector(IntVect intVect, MatchData data) {
		// TODO Auto-generated method stub
		return new FloatVect((float)(intVect.getX()*data.getTileWidth()) + (float)(data.getTileWidth()/2), (float)(intVect.getY()*data.getTileHeight()) + (float)(data.getTileHeight()/2));
	}
}
