﻿#region License

// --------------------------------------------------
// Copyright © OKB. All Rights Reserved.
// 
// This software is proprietary information of OKB.
// USE IS SUBJECT TO LICENSE TERMS.
// --------------------------------------------------

#endregion

using System;
using System.Data;
using System.Security.Policy;
using Newtonsoft.Json;
using Tasks.Models;

namespace Tasks
{
    public class Processor : Logger
    {
        public int Id;
        public Map Map;
        public Game State;

        public void LoadMap(string data)
        {
            this.Log(LogType.INFO, "Loading the map...", "Waiting...");
            this.State = JsonConvert.DeserializeObject<Game>(data);
            this.Log(LogType.INFO, "Map loaded!", "OK");
            this.Log(LogType.INFO, "Bot ID", State.Id.ToString());
        }

        public void ProcessUpdate(string data)
        {
            this.State = JsonConvert.DeserializeObject<Game>(data);
            //this.Log(LogType.INFO, "Reading update", "OK");
            //this.Log(LogType.INFO, "Velocity", State.Cars[State.Id].Velocity.X + " - " + State.Cars[State.Id].Velocity.Y);

            Console.Clear();
            Console.WriteLine("Position X: \t" + State.Cars[State.Id].Pos.X);
            Console.WriteLine("Position Y: \t" + State.Cars[State.Id].Pos.Y);
            Console.WriteLine("Velocity X: \t" + State.Cars[State.Id].Velocity.X);
            Console.WriteLine("Velocity Y: \t" + State.Cars[State.Id].Velocity.Y);
            Console.WriteLine("Speed: \t\t" + this.Speed(State.Id));
            Console.WriteLine("Direction X: \t" + State.Cars[State.Id].Direction.X);
            Console.WriteLine("Direction Y: \t" + State.Cars[State.Id].Direction.Y);

            Console.WriteLine(); //Spacing
            Console.WriteLine(string.Format("| {0,-5} | {1,-30} | {2,-21} | {3,10} |",
                                            "Type", "Message", "Value", "Time"));
            Line();

            for (int i = BackLogg.Count - 1; i > BackLogg.Count - 11; i--)
            {
                try
                {
                    Console.WriteLine(BackLogg[i]);
                }
                catch (Exception e)
                {
                }
            }
        }

        public float Distance(int CarId, Coordinate target)
        {
            Coordinate position = State.Cars[CarId].Pos;
            return Math.Abs(position.X - target.X) + Math.Abs(position.Y - target.Y);
        }


        public float Speed(int id)
        {
            return (Math.Abs(State.Cars[id].Velocity.Y) + Math.Abs(State.Cars[id].Velocity.X));
        }

        public double AngleToTarget(int CarId, Coordinate target)
        {
            Coordinate current = State.Cars[CarId].Pos;
            Coordinate direction = State.Cars[CarId].Direction;
            float deltaX1 = target.X - current.X;
            float deltaY1 = target.Y - current.Y;

            double angle1 = Math.Atan2(direction.X, direction.Y) * (180 / Math.PI);
            double angle2 = Math.Atan2(deltaX1, deltaY1) * (180 / Math.PI);

            double angleInDegrees = angle1 - angle2;

            if (Math.Abs(angleInDegrees) > 180)
            {
                return angle2 - angle1;
            }
            
            return angleInDegrees;
        }
    }
}